/*
 * Decompiled with CFR 0.152.
 */
package Tropicraft.Installer;

public class OSManager {
    int category;

    public OSManager() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("win")) {
            this.category = 1;
        } else if (os.startsWith("mac")) {
            this.category = 2;
        } else if (os.contains("nix") || os.contains("nux")) {
            this.category = 3;
        } else if (os.contains("solaris")) {
            this.category = 3;
        }
    }

    public boolean equals(OSManager other) {
        return this.category == other.category;
    }

    public boolean isWindows() {
        return this.category == 1;
    }

    public boolean isMac() {
        return this.category == 2;
    }

    public boolean isLinux() {
        return this.category == 3;
    }

    public String getMinecraftDir() {
        if (this.isMac()) {
            return String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/minecraft/";
        }
        if (this.isLinux()) {
            return String.valueOf(System.getProperty("user.home")) + "/.minecraft/";
        }
        if (this.isWindows()) {
            return String.valueOf(System.getenv("APPDATA")) + "/.minecraft/";
        }
        throw new RuntimeException("Unknown OS!");
    }
}

