/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.blocks.liquids;

import java.util.Random;
import net.tropicraft.blocks.liquids.BlockFluidLAPI;
import net.tropicraft.blocks.liquids.LAPI;

public class BlockFlowingLAPI
extends BlockFluidLAPI {
    int numAdjacentSources = 0;
    boolean[] isOptimalFlowDirection = new boolean[4];
    int[] flowCost = new int[4];

    public BlockFlowingLAPI(int par1, int liqID, agi par2Material) {
        super(par1, liqID, par2Material);
        this.liquidID = liqID;
        this.cl = LAPI.getTextureIDFromLiquidID(liqID, true);
    }

    private void updateFlow(yc par1World, int par2, int par3, int par4) {
        int var5 = par1World.h(par2, par3, par4);
        par1World.c(par2, par3, par4, LAPI.getPairedBlockID(this.cm), var5);
        par1World.e(par2, par3, par4, par2, par3, par4);
    }

    @Override
    public boolean c(ym par1IBlockAccess, int par2, int par3, int par4) {
        return this.cB != agi.i;
    }

    public void b(yc par1World, int par2, int par3, int par4, Random par5Random) {
        int var10;
        int var6 = this.getFlowDecay(par1World, par2, par3, par4);
        int var7 = 1;
        if (this.cB == agi.i && !par1World.u.e) {
            var7 = 2;
        }
        boolean var8 = true;
        if (var6 > 0) {
            int var9 = -100;
            this.numAdjacentSources = 0;
            int var12 = this.getSmallestFlowDecay(par1World, par2 - 1, par3, par4, var9);
            var12 = this.getSmallestFlowDecay(par1World, par2 + 1, par3, par4, var12);
            var12 = this.getSmallestFlowDecay(par1World, par2, par3, par4 - 1, var12);
            var10 = (var12 = this.getSmallestFlowDecay(par1World, par2, par3, par4 + 1, var12)) + var7;
            if (var10 >= 8 || var12 < 0) {
                var10 = -1;
            }
            if (this.getFlowDecay(par1World, par2, par3 + 1, par4) >= 0) {
                int var11 = this.getFlowDecay(par1World, par2, par3 + 1, par4);
                var10 = var11 >= 8 ? var11 : var11 + 8;
            }
            if (this.numAdjacentSources >= 2 && this.cB == agi.h) {
                if (par1World.g(par2, par3 - 1, par4).a()) {
                    var10 = 0;
                } else if (par1World.g(par2, par3 - 1, par4) == this.cB && par1World.h(par2, par3, par4) == 0) {
                    var10 = 0;
                }
            }
            if (this.cB == agi.i && var6 < 8 && var10 < 8 && var10 > var6 && par5Random.nextInt(4) != 0) {
                var10 = var6;
                var8 = false;
            }
            if (var10 == var6) {
                if (var8) {
                    this.updateFlow(par1World, par2, par3, par4);
                }
            } else {
                var6 = var10;
                if (var10 < 0) {
                    par1World.e(par2, par3, par4, 0);
                } else {
                    par1World.c(par2, par3, par4, var10);
                    par1World.a(par2, par3, par4, this.cm, this.r_());
                    par1World.h(par2, par3, par4, this.cm);
                }
            }
        } else {
            this.updateFlow(par1World, par2, par3, par4);
        }
        if (this.liquidCanDisplaceBlock(par1World, par2, par3 - 1, par4)) {
            if (this.cB == agi.i && par1World.g(par2, par3 - 1, par4) == agi.h) {
                par1World.e(par2, par3 - 1, par4, amq.w.cm);
                this.triggerLavaMixEffects(par1World, par2, par3 - 1, par4);
                return;
            }
            if (var6 >= 8) {
                this.flowIntoBlock(par1World, par2, par3 - 1, par4, var6);
            } else {
                this.flowIntoBlock(par1World, par2, par3 - 1, par4, var6 + 8);
            }
        } else if (var6 >= 0 && (var6 == 0 || this.blockBlocksFlow(par1World, par2, par3 - 1, par4))) {
            boolean[] var13 = this.getOptimalFlowDirections(par1World, par2, par3, par4);
            var10 = var6 + var7;
            if (var6 >= 8) {
                var10 = 1;
            }
            if (var10 >= 8) {
                return;
            }
            if (var13[0]) {
                this.flowIntoBlock(par1World, par2 - 1, par3, par4, var10);
            }
            if (var13[1]) {
                this.flowIntoBlock(par1World, par2 + 1, par3, par4, var10);
            }
            if (var13[2]) {
                this.flowIntoBlock(par1World, par2, par3, par4 - 1, var10);
            }
            if (var13[3]) {
                this.flowIntoBlock(par1World, par2, par3, par4 + 1, var10);
            }
        }
    }

    private void flowIntoBlock(yc par1World, int par2, int par3, int par4, int par5) {
        if (this.liquidCanDisplaceBlock(par1World, par2, par3, par4)) {
            int var6 = par1World.a(par2, par3, par4);
            if (var6 > 0) {
                if (this.cB == agi.i) {
                    this.triggerLavaMixEffects(par1World, par2, par3, par4);
                } else {
                    amq.p[var6].c(par1World, par2, par3, par4, par1World.h(par2, par3, par4), 0);
                }
            }
            par1World.d(par2, par3, par4, this.cm, par5);
        }
    }

    private int calculateFlowCost(yc par1World, int par2, int par3, int par4, int par5, int par6) {
        int var7 = 1000;
        for (int var8 = 0; var8 < 4; ++var8) {
            int var12;
            if (var8 == 0 && par6 == 1 || var8 == 1 && par6 == 0 || var8 == 2 && par6 == 3 || var8 == 3 && par6 == 2) continue;
            int var9 = par2;
            int var11 = par4;
            if (var8 == 0) {
                var9 = par2 - 1;
            }
            if (var8 == 1) {
                ++var9;
            }
            if (var8 == 2) {
                var11 = par4 - 1;
            }
            if (var8 == 3) {
                ++var11;
            }
            if (this.blockBlocksFlow(par1World, var9, par3, var11) || par1World.g(var9, par3, var11) == this.cB && par1World.h(var9, par3, var11) == 0) continue;
            if (!this.blockBlocksFlow(par1World, var9, par3 - 1, var11)) {
                return par5;
            }
            if (par5 >= 4 || (var12 = this.calculateFlowCost(par1World, var9, par3, var11, par5 + 1, var8)) >= var7) continue;
            var7 = var12;
        }
        return var7;
    }

    private boolean[] getOptimalFlowDirections(yc par1World, int par2, int par3, int par4) {
        int var6;
        int var5;
        for (var5 = 0; var5 < 4; ++var5) {
            this.flowCost[var5] = 1000;
            var6 = par2;
            int var8 = par4;
            if (var5 == 0) {
                var6 = par2 - 1;
            }
            if (var5 == 1) {
                ++var6;
            }
            if (var5 == 2) {
                var8 = par4 - 1;
            }
            if (var5 == 3) {
                ++var8;
            }
            if (this.blockBlocksFlow(par1World, var6, par3, var8) || par1World.g(var6, par3, var8) == this.cB && par1World.h(var6, par3, var8) == 0) continue;
            this.flowCost[var5] = this.blockBlocksFlow(par1World, var6, par3 - 1, var8) ? this.calculateFlowCost(par1World, var6, par3, var8, 1, var5) : 0;
        }
        var5 = this.flowCost[0];
        for (var6 = 1; var6 < 4; ++var6) {
            if (this.flowCost[var6] >= var5) continue;
            var5 = this.flowCost[var6];
        }
        for (var6 = 0; var6 < 4; ++var6) {
            this.isOptimalFlowDirection[var6] = this.flowCost[var6] == var5;
        }
        return this.isOptimalFlowDirection;
    }

    private boolean blockBlocksFlow(yc par1World, int par2, int par3, int par4) {
        int var5 = par1World.a(par2, par3, par4);
        if (var5 != amq.aH.cm && var5 != amq.aO.cm && var5 != amq.aG.cm && var5 != amq.aI.cm && var5 != amq.ba.cm) {
            if (var5 == 0) {
                return false;
            }
            agi var6 = amq.p[var5].cB;
            return var6 == agi.C ? true : var6.c();
        }
        return true;
    }

    protected int getSmallestFlowDecay(yc par1World, int par2, int par3, int par4, int par5) {
        int var6 = this.getFlowDecay(par1World, par2, par3, par4);
        if (var6 < 0) {
            return par5;
        }
        if (var6 == 0) {
            ++this.numAdjacentSources;
        }
        if (var6 >= 8) {
            var6 = 0;
        }
        return par5 >= 0 && var6 >= par5 ? par5 : var6;
    }

    private boolean liquidCanDisplaceBlock(yc par1World, int par2, int par3, int par4) {
        agi var5 = par1World.g(par2, par3, par4);
        return var5 == this.cB ? false : (var5 == agi.i ? false : !this.blockBlocksFlow(par1World, par2, par3, par4));
    }

    @Override
    public void g(yc par1World, int par2, int par3, int par4) {
        super.g(par1World, par2, par3, par4);
        if (par1World.a(par2, par3, par4) == this.cm) {
            par1World.a(par2, par3, par4, this.cm, this.r_());
        }
    }
}

