/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.blocks.liquids;

import net.tropicraft.blocks.liquids.LAPI;
import net.tropicraft.blocks.liquids.LAPITextureFX;

public class TropicraftLAPITextureFX
extends LAPITextureFX {
    private int tickCounter;
    private boolean isAnimated;

    public TropicraftLAPITextureFX(int i, boolean isAnimatedLiquid) {
        super(i, isAnimatedLiquid);
        this.e = i;
        this.h = isAnimatedLiquid ? 2 : 1;
        this.opacity = -1;
        this.isAnimated = isAnimatedLiquid;
        this.i = 2;
        this.red = new float[256];
        this.green = new float[256];
        this.blue = new float[256];
        this.alpha = new float[256];
    }

    @Override
    public void a() {
        super.a();
        if (this.isAnimated) {
            ++this.tickCounter;
            for (int i = 0; i < 16; ++i) {
                for (int k = 0; k < 16; ++k) {
                    float f = 0.0f;
                    for (int j1 = k - 2; j1 <= k; ++j1) {
                        int k1 = i & 0xF;
                        int i2 = j1 & 0xF;
                        f += this.red[k1 + i2 * 16];
                    }
                    this.green[i + k * 16] = f / 3.2f + this.blue[i + k * 16] * 0.8f;
                }
            }
            for (int j = 0; j < 16; ++j) {
                for (int l = 0; l < 16; ++l) {
                    int n = j + l * 16;
                    this.blue[n] = this.blue[n] + this.alpha[j + l * 16] * 0.05f;
                    if (this.blue[j + l * 16] < 0.0f) {
                        this.blue[j + l * 16] = 0.0f;
                    }
                    int n2 = j + l * 16;
                    this.alpha[n2] = this.alpha[n2] - 0.3f;
                    if (!(Math.random() < 0.2)) continue;
                    this.alpha[j + l * 16] = 0.5f;
                }
            }
            float[] af = this.green;
            this.green = this.red;
            this.red = af;
            for (int i1 = 0; i1 < 256; ++i1) {
                int average;
                float f1 = this.red[i1 - this.tickCounter * 16 & 0xFF];
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                if (f1 < 0.0f) {
                    f1 = 0.0f;
                }
                float f2 = f1 * f1;
                int l1 = (int)(32.0f + f2 * 32.0f);
                int j2 = (int)(50.0f + f2 * 64.0f);
                int k2 = 255;
                int l2 = (int)(146.0f + f2 * 50.0f);
                if (this.f) {
                    int i3 = (l1 * 30 + j2 * 59 + k2 * 11) / 100;
                    int j3 = (l1 * 30 + j2 * 70) / 100;
                    int k3 = (l1 * 30 + k2 * 70) / 100;
                    l1 = i3;
                    j2 = j3;
                    k2 = k3;
                }
                l1 = average = (l1 + j2 + k2) / 3;
                j2 = average;
                k2 = average;
                if (this.opacity < 0) {
                    this.opacity = l2;
                }
                this.d[i1 * 4 + 0] = (byte)(l1 + 0);
                this.d[i1 * 4 + 1] = (byte)(j2 + 60);
                this.d[i1 * 4 + 2] = (byte)(k2 + 110);
                this.d[i1 * 4 + 3] = (byte)this.opacity;
            }
        } else {
            ++this.tickCounter;
            for (int i = 0; i < 16; ++i) {
                for (int k = 0; k < 16; ++k) {
                    float f = 0.0f;
                    for (int j1 = i - 1; j1 <= i + 1; ++j1) {
                        int k1 = j1 & 0xF;
                        int i2 = k & 0xF;
                        f += this.red[k1 + i2 * 16];
                    }
                    this.green[i + k * 16] = f / 3.3f + this.blue[i + k * 16] * 0.8f;
                }
            }
            for (int j = 0; j < 16; ++j) {
                for (int l = 0; l < 16; ++l) {
                    int n = j + l * 16;
                    this.blue[n] = this.blue[n] + this.alpha[j + l * 16] * 0.05f;
                    if (this.blue[j + l * 16] < 0.0f) {
                        this.blue[j + l * 16] = 0.0f;
                    }
                    int n3 = j + l * 16;
                    this.alpha[n3] = this.alpha[n3] - 0.1f;
                    if (!(Math.random() < 0.05)) continue;
                    this.alpha[j + l * 16] = 0.5f;
                }
            }
            float[] af = this.green;
            this.green = this.red;
            this.red = af;
            for (int i1 = 0; i1 < 256; ++i1) {
                int average;
                float f1 = this.red[i1];
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                if (f1 < 0.0f) {
                    f1 = 0.0f;
                }
                float f2 = f1 * f1;
                int l1 = (int)(32.0f + f2 * 32.0f);
                int j2 = (int)(50.0f + f2 * 64.0f);
                int k2 = 255;
                int l2 = (int)(146.0f + f2 * 50.0f);
                if (this.f) {
                    int i3 = (l1 * 30 + j2 * 59 + k2 * 11) / 100;
                    int j3 = (l1 * 30 + j2 * 70) / 100;
                    int k3 = (l1 * 30 + k2 * 70) / 100;
                    l1 = i3;
                    j2 = j3;
                    k2 = k3;
                }
                l1 = average = (l1 + j2 + k2) / 3;
                j2 = average;
                k2 = average;
                Integer liquidColor = (Integer)LAPI.colorMap.get(this.e);
                if (liquidColor == null) {
                    liquidColor = 0xFFFFFF;
                }
                if (this.opacity < 0) {
                    this.opacity = l2;
                }
                this.d[i1 * 4 + 0] = (byte)(l1 + 0);
                this.d[i1 * 4 + 1] = (byte)(l1 + 60);
                this.d[i1 * 4 + 2] = (byte)(l1 + 110);
                this.d[i1 * 4 + 3] = (byte)this.opacity;
            }
        }
    }
}

