/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.encyclopedia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.tropicraft.encyclopedia.TropicalBook;
import net.tropicraft.mods.TropicraftMod;

public class Encyclopedia
extends TropicalBook {
    private HashMap recipes = new HashMap();
    private HashMap itemEntries = new HashMap();

    public Encyclopedia(String savedDataFile, String contentsFile, String outsideTexture, String insideTexture) {
        super(savedDataFile, contentsFile, outsideTexture, insideTexture, false);
    }

    @Override
    public boolean hasRecipeList() {
        return true;
    }

    public void includeItem(String itemname, ur item) {
        if (!this.itemEntries.containsKey(itemname)) {
            this.itemEntries.put(itemname, new ArrayList());
        }
        ((List)this.itemEntries.get(itemname)).add(item);
    }

    public void includeRecipe(ur result, Object[] aobj) {
        HashSet recipeContents = new HashSet();
        this.addItemToRecipeContents(recipeContents, result);
        String recipeString = "";
        int i = 0;
        int width = 0;
        int height = 0;
        if (aobj[i] instanceof String[]) {
            String[] cols = (String[])aobj[i++];
            for (int j = 0; j < cols.length; ++j) {
                String row = cols[j];
                ++height;
                width = row.length();
                recipeString = recipeString + row;
            }
        } else {
            while (aobj[i] instanceof String) {
                String row = (String)aobj[i++];
                ++height;
                width = row.length();
                recipeString = recipeString + row;
            }
        }
        HashMap<Character, ur> charMap = new HashMap<Character, ur>();
        while (i < aobj.length) {
            Character itemChar = (Character)aobj[i];
            ur itemStack = null;
            if (aobj[i + 1] instanceof up) {
                itemStack = new ur((up)aobj[i + 1]);
            } else if (aobj[i + 1] instanceof amq) {
                itemStack = new ur((amq)aobj[i + 1], 1, -1);
            } else if (aobj[i + 1] instanceof ur) {
                itemStack = (ur)aobj[i + 1];
            }
            charMap.put(itemChar, itemStack);
            this.addItemToRecipeContents(recipeContents, itemStack);
            i += 2;
        }
        ur[] slotArray = new ur[width * height];
        for (int slots = 0; slots < width * height; ++slots) {
            char itemChar = recipeString.charAt(slots);
            slotArray[slots] = charMap.containsKey(Character.valueOf(itemChar)) ? ((ur)charMap.get(Character.valueOf(itemChar))).l() : null;
        }
        wq recipe = new wq(width, height, slotArray, result);
        for (ur item : recipeContents) {
            boolean foundKey = false;
            for (ur key : this.recipes.keySet()) {
                if (!item.a(key)) continue;
                foundKey = true;
                ((List)this.recipes.get(key)).add(recipe);
                break;
            }
            if (foundKey) continue;
            this.recipes.put(item, new ArrayList());
            ((List)this.recipes.get(item)).add(recipe);
        }
    }

    public List getRecipesForEntry(int page) {
        List entryItems = (List)this.itemEntries.get(this.getPageName(page));
        ArrayList recipeList = new ArrayList();
        if (entryItems != null) {
            for (ur item : entryItems) {
                for (ur recipeItem : this.recipes.keySet()) {
                    List itemRecipes;
                    if (!recipeItem.a(item) || (itemRecipes = (List)this.recipes.get(recipeItem)) == null) continue;
                    recipeList.addAll(itemRecipes);
                }
            }
        }
        return recipeList;
    }

    @Override
    public int getContentPageCount(int page, TropicalBook.ContentMode mode) {
        if (page >= 0 && page < this.getPageCount()) {
            List recipeList;
            if (mode == TropicalBook.ContentMode.INFO) {
                return 1;
            }
            if (mode == TropicalBook.ContentMode.RECIPE && (recipeList = this.getRecipesForEntry(page)) != null) {
                return recipeList.size();
            }
        }
        return 0;
    }

    @Override
    public int entriesPerContentPage(TropicalBook.ContentMode mode) {
        if (mode == TropicalBook.ContentMode.RECIPE) {
            return 3;
        }
        return super.entriesPerContentPage(mode);
    }

    @Override
    public boolean hasIndexIcons() {
        return true;
    }

    @Override
    public ur getPageItemStack(int page) {
        List items;
        if (page >= 0 && page < this.getPageCount() && (items = (List)this.itemEntries.get(this.getPageName(page))) != null && !items.isEmpty()) {
            return (ur)items.get(0);
        }
        return null;
    }

    @Override
    public void updatePagesFromInventory(qw inv) {
        for (ur is : inv.a) {
            if (is == null) continue;
            ur comparison = new ur(is.b(), 1, is.j());
            for (String entry : this.itemEntries.keySet()) {
                if (this.isPageVisible(entry)) continue;
                List itemsInBook = (List)this.itemEntries.get(entry);
                for (ur itemInBook : itemsInBook) {
                    if (!ur.b((ur)itemInBook, (ur)comparison)) continue;
                    this.markPageAsNewlyVisible(entry);
                }
            }
        }
    }

    private void addItemToRecipeContents(Set items, ur i) {
        boolean shouldAdd = !items.contains(i);
        for (ur listItem : items) {
            if (!listItem.a(i)) continue;
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            items.add(i);
        }
    }

    public RecipeEntry getFormattedRecipe(wq recipe) {
        try {
            int width = (Integer)TropicraftMod.getPrivateValueBoth(wq.class, recipe, "b", "recipeWidth");
            int height = (Integer)TropicraftMod.getPrivateValueBoth(wq.class, recipe, "c", "recipeHeight");
            ur[] items = (ur[])TropicraftMod.getPrivateValueBoth(wq.class, recipe, "d", "recipeItems");
            ur output = (ur)TropicraftMod.getPrivateValueBoth(wq.class, recipe, "e", "recipeOutput");
            return new RecipeEntry(width, height, items, output);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public class RecipeEntry {
        public int width;
        public int height;
        public ur[] ingredients;
        public ur output;

        public RecipeEntry(int width, int height, ur[] ingredients, ur output) {
            this.width = width;
            this.height = height;
            this.ingredients = ingredients;
            this.output = output;
        }
    }
}

