/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.entities;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.tropicraft.entities.EntityKoaMemberNew;
import net.tropicraft.entities.TropicraftSentence;

public class ConversationHandler {
    protected TropicraftSentence speak;
    protected EntityKoaMemberNew entity;
    public Random rand;
    public boolean hasGreeted;
    public boolean hasSaidFirstSentence;
    public boolean playerInRange;
    public static long sentStart = 0L;
    public List tribeQuestions;
    public final String[] greetinglines = new String[]{"Aloha!", "Oaloha!"};
    public final String[] contentlines = new String[]{"Maika'i", "Hau'oli", "Hoaloha", "Laule'a"};
    public final String[] upsetlines = new String[]{"\u00a74a'ole", "\u00a74hu hu"};
    public final String[] tribalMaleNames = new String[]{"Akamu", "Ekewaka", "Ikaika", "Iukini", "Kai", "Kaimana", "Kaimi", "Kanoa", "Kapena", "Keahi", "Keaweaheulu", "Kekipi", "Kekoa", "Konani", "Makani", "Mano", "Nahele"};
    public final String[] nameMaleMeanings = new String[]{"Earth, or Red", "Guardian of Prosperity", "Well Born", "Strong", "Sea", "Diamond", "The Seeker", "The Free One", "The Captain", "Flames", "Cool Breeze Over the Mountains", "Rebel", "The Brave One", "Bright", "Wind", "Shark", "Forest"};
    public final String[] tribalFemaleNames = new String[]{"Alamea", "Alani", "Alaula", "Ewa", "Kai", "Kaiolohia", "Kalama", "Keala", "Kiele", "Mahina", "Makala", "Maylea", "Noe"};
    public final String[] nameFemaleMeanings = new String[]{"Precious", "Orange Tree", "Dawn", "Life", "Sea", "Calm Sea", "Flaming Torch", "The Pathway", "Fragant Blossom", "Moon, or Moonlight", "Myrtle", "Wildflower", "Mist or Misty Rain"};

    public ConversationHandler(md entity) {
        this.speak = new TropicraftSentence();
        this.rand = entity.p.t;
        if (entity instanceof EntityKoaMemberNew) {
            this.entity = (EntityKoaMemberNew)entity;
        }
        this.hasGreeted = false;
        this.tribeQuestions = new LinkedList();
        this.addConversations();
    }

    protected void clearSpoken() {
        this.speak.clear();
    }

    protected void onUpdate() {
        int qIndex = 0;
        if (this.tribeQuestions != null) {
            TropicraftSentence tSent = (TropicraftSentence)this.tribeQuestions.get(qIndex);
            if (!this.hasSaidFirstSentence) {
                if (tSent.phraseIndex < tSent.phraseCount) {
                    if (sentStart < System.currentTimeMillis()) {
                        sentStart = System.currentTimeMillis() + (long)tSent.getTimeout();
                        this.say(" <\u00a7a" + this.entity.name + '\u00a7' + "f" + "> " + tSent.phraseStrings.get(tSent.phraseIndex) + "");
                        ++tSent.phraseIndex;
                    }
                } else {
                    this.hasSaidFirstSentence = true;
                    tSent.phraseIndex = 0;
                }
            }
        }
    }

    public void say(String s) {
    }

    public void out(Object s) {
        System.out.println(s.toString());
    }

    public void addConversations() {
        TropicraftSentence question = new TropicraftSentence();
        question.add("Aloha!");
        this.tribeQuestions.add(question);
        question = new TropicraftSentence();
        question.add("Oaloha!");
        this.tribeQuestions.add(question);
    }

    public void onTradeInitiated(boolean b) {
        if (b) {
            this.speak.clear();
            this.speak.add(this.getContentPhrase());
            this.tribeQuestions.add(this.speak);
        } else {
            this.speak.clear();
            this.speak.add(this.getUpsetPhrase());
            this.tribeQuestions.add(this.speak);
        }
    }

    public String getUpsetPhrase() {
        return this.upsetlines[this.rand.nextInt(this.upsetlines.length)];
    }

    public String getContentPhrase() {
        return this.contentlines[this.rand.nextInt(this.contentlines.length)];
    }

    public String getGreetingPhrase() {
        return this.greetinglines[this.rand.nextInt(this.greetinglines.length)];
    }

    public void greetPlayer(float f) {
        this.speak.clear();
        this.speak.add(this.getGreetingPhrase());
        this.tribeQuestions.add(this.speak);
        this.hasGreeted = true;
    }
}

