/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.tropicraft.encyclopedia.Encyclopedia;
import net.tropicraft.encyclopedia.TropicalBook;
import net.tropicraft.gui.GuiClearButton;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTropicalBook
extends aul {
    private TropicalBook book;
    private int indexPage = -1;
    private int selectedIndex = 0;
    private TropicalBook.ContentMode contentMode = TropicalBook.ContentMode.INFO;
    private int contentPage = 0;
    private String coverBackground;
    private String pageBackground;
    private int closedTextureIndex;
    private int openTextureIndex;
    private bce itemRenderer = new bce();
    private static final int buttonNextIndexPage = 2000;
    private static final int buttonPrevIndexPage = 2001;
    private static final int buttonBookCover = 2003;
    private static final int buttonCraftingPage = 2010;
    private static final int buttonInfoPage = 2011;
    private static final int buttonNextContentPage = 2012;
    private static final int buttonPrevContentPage = 2013;

    public GuiTropicalBook(TropicalBook tropbook) {
        this.book = tropbook;
        this.coverBackground = tropbook.outsideTexture;
        this.pageBackground = tropbook.insideTexture;
        this.closedTextureIndex = ModLoader.getMinecraftInstance().o.b(tropbook.outsideTexture);
        this.openTextureIndex = ModLoader.getMinecraftInstance().o.b(tropbook.insideTexture);
    }

    public boolean f() {
        return false;
    }

    public void A_() {
        this.addButtons();
    }

    protected void a(atb guibutton) {
        switch (guibutton.f) {
            case 2003: {
                this.indexPage = 0;
                this.contentMode = TropicalBook.ContentMode.INFO;
                this.contentPage = 0;
                break;
            }
            case 2000: {
                ++this.indexPage;
                this.contentPage = 0;
                break;
            }
            case 2001: {
                --this.indexPage;
                this.contentPage = 0;
                break;
            }
            case 2010: {
                this.contentMode = TropicalBook.ContentMode.RECIPE;
                this.contentPage = 0;
                break;
            }
            case 2011: {
                this.contentMode = TropicalBook.ContentMode.INFO;
                this.contentPage = 0;
                break;
            }
            case 2012: {
                ++this.contentPage;
                break;
            }
            case 2013: {
                --this.contentPage;
                break;
            }
            default: {
                this.selectedIndex = guibutton.f;
                if (this.book.isPageVisible(this.selectedIndex) && !this.book.hasPageBeenRead(this.selectedIndex)) {
                    this.book.markPageAsRead(this.selectedIndex);
                }
                this.contentMode = TropicalBook.ContentMode.INFO;
                this.contentPage = 0;
            }
        }
    }

    private void addButtons() {
        this.i.clear();
        if (this.indexPage == -1) {
            this.i.add(new GuiClearButton(2003, 0, 0, this.g, this.h, "", 0, this.coverBackground, 0x440000));
        } else {
            int indexPosition = 0;
            for (int entry = this.indexPage * this.book.entriesPerIndexPage(); entry < (this.indexPage + 1) * this.book.entriesPerIndexPage() && entry < this.book.getPageCount(); ++entry) {
                String pageTitle = this.book.getPageTitleNotVisible(entry);
                int color = 0x440000;
                if (this.book.isPageVisible(entry)) {
                    pageTitle = this.book.getPageTitleByIndex(entry);
                    if (!this.book.hasPageBeenRead(entry)) {
                        color = 0x3333FF;
                    }
                }
                this.i.add(new GuiClearButton(entry, this.g / 2 - 129, this.h / 2 - 87 + indexPosition * 15, 90, 10, pageTitle, -1, this.pageBackground, color));
                ++indexPosition;
            }
            if (this.indexPage > 0) {
                this.i.add(new GuiClearButton(2001, this.g / 2 - 168, this.h / 2 - 20, 11, 22, "", 2, this.pageBackground, 0x440000));
            }
            if ((this.indexPage + 1) * this.book.entriesPerIndexPage() < this.book.getPageCount()) {
                this.i.add(new GuiClearButton(2000, this.g / 2 - 168, this.h / 2 - 50, 11, 22, "", 1, this.pageBackground, 0x440000));
            }
            if (this.indexPage >= 0) {
                if (this.book.hasRecipeList()) {
                    switch (this.contentMode) {
                        case INFO: {
                            List recipes = ((Encyclopedia)this.book).getRecipesForEntry(this.selectedIndex);
                            if (recipes == null || recipes.size() <= 0) break;
                            this.i.add(new GuiClearButton(2010, this.g / 2 + 158, this.h / 2 - 80, 11, 22, "", 5, this.pageBackground, 0x440000));
                            break;
                        }
                        case RECIPE: {
                            this.i.add(new GuiClearButton(2011, this.g / 2 + 158, this.h / 2 - 80, 11, 22, "", 6, this.pageBackground, 0x440000));
                            break;
                        }
                    }
                }
                if (this.contentPage > 0) {
                    this.i.add(new GuiClearButton(2013, this.g / 2 + 158, this.h / 2 - 20, 11, 22, "", 4, this.pageBackground, 0x440000));
                }
                if ((this.contentPage + 1) * this.book.entriesPerContentPage(this.contentMode) < this.book.getContentPageCount(this.selectedIndex, this.contentMode)) {
                    this.i.add(new GuiClearButton(2012, this.g / 2 + 158, this.h / 2 - 50, 11, 22, "", 3, this.pageBackground, 0x440000));
                }
            }
        }
    }

    public void addIcons() {
        int indexPosition = 0;
        for (int entry = this.indexPage * this.book.entriesPerIndexPage(); entry < (this.indexPage + 1) * this.book.entriesPerIndexPage(); ++entry) {
            if (entry >= this.book.getPageCount()) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            this.f.o.b(this.openTextureIndex);
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            GL11.glTranslatef((float)((float)this.g / 1.5f), (float)((float)this.h / 1.5f), (float)0.0f);
            this.b(-195, -121 + indexPosition * 20, 3, 190, 18, 18);
            GL11.glPopMatrix();
            if (this.book.isPageVisible(entry)) {
                arw.a();
                GL11.glPushMatrix();
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                GL11.glTranslatef((float)((float)this.g / 1.5f - 1.0f), (float)((float)this.h / 1.5f), (float)0.0f);
                this.itemRenderer.a(this.l, this.f.o, this.book.getPageItemStack(entry), -193, -120 + indexPosition * 20);
                GL11.glPopMatrix();
            }
            ++indexPosition;
        }
    }

    protected void a(int x, int y, int mousebutton) {
        if (mousebutton == 0) {
            for (int l = 0; l < this.i.size(); ++l) {
                atb guibutton = (atb)this.i.get(l);
                if (!guibutton.c(this.f, x, y)) continue;
                this.f.A.a("pageFlip", 1.0f, 1.0f);
                this.a(guibutton);
            }
        }
    }

    public void n() {
        super.n();
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == this.f.y.J.d) {
                this.f.a((aul)new avz((qx)this.f.g));
                return;
            }
            this.a(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void a(int i, int j, float f) {
        this.e();
        if (this.indexPage == -1) {
            float f1 = 1.35f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.f.o.b(this.closedTextureIndex);
            GL11.glTranslatef((float)(this.g / 2), (float)(this.h / 2), (float)0.0f);
            GL11.glScalef((float)f1, (float)f1, (float)f1);
            this.b(-64, -86, 0, 0, 128, 173);
        } else {
            float f2 = 1.35f;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.f.o.b(this.openTextureIndex);
            GL11.glTranslatef((float)(this.g / 2), (float)(this.h / 2), (float)0.0f);
            GL11.glScalef((float)f2, (float)f2, (float)f2);
            this.b(-128, -88, 0, 0, 256, 176);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.f.o.b(this.openTextureIndex);
            this.b(this.g / 2 - 162, this.h / 2 - 115, 145, 201, 111, 32);
            GL11.glPopMatrix();
            this.l.b("Table of Contents", this.g / 2 - 150, this.h / 2 - 110, 0x440000);
            if (this.book.hasIndexIcons()) {
                this.addIcons();
            }
            if (this.book.isPageVisible(this.selectedIndex)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                switch (this.contentMode) {
                    case INFO: {
                        String pageTitle = this.book.getPageTitleByIndex(this.selectedIndex);
                        this.l.b(pageTitle, this.g / 2 + 150 - this.l.a(pageTitle), this.h / 2 - 110, 0x440000);
                        this.l.a("  " + this.book.getPageDescriptionsByIndex(this.selectedIndex), this.g / 2 + 20, this.h / 2 - 80, 135, 0x440000);
                        break;
                    }
                    case RECIPE: {
                        this.l.b("Crafting", this.g / 2 + 110, this.h / 2 - 110, 0x440000);
                        try {
                            this.printRecipes();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                this.f.o.b(this.openTextureIndex);
                this.b(this.g / 2 + 20, this.h / 2 - 115, 90, 201, 142, 32);
                GL11.glPopMatrix();
                if (this.book.hasIndexIcons()) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                    GL11.glTranslatef((float)((float)this.g / 3.0f + 0.6f), (float)((float)this.h / 3.0f - 1.2f), (float)0.0f);
                    this.itemRenderer.a(this.l, this.f.o, this.book.getPageItemStack(this.selectedIndex), 15, -73);
                    GL11.glPopMatrix();
                }
            }
        }
        this.addButtons();
        super.a(i, j, f);
    }

    private void printRecipes() throws Exception {
        List recipes = ((Encyclopedia)this.book).getRecipesForEntry(this.selectedIndex);
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        int newx = this.g / 2 + 25;
        int newy = this.h / 2 - 80;
        int indexPosition = 0;
        for (int entry = this.contentPage * this.book.entriesPerContentPage(this.contentMode); entry < (this.contentPage + 1) * this.book.entriesPerContentPage(this.contentMode); ++entry) {
            int renderY;
            int renderX;
            int itemIndex;
            int col;
            int row;
            if (entry >= this.book.getContentPageCount(this.selectedIndex, this.contentMode)) {
                return;
            }
            Encyclopedia.RecipeEntry recipe = ((Encyclopedia)this.book).getFormattedRecipe((wq)recipes.get(entry));
            this.f.o.b(this.openTextureIndex);
            this.b(newx - 3, newy - 3, 0, 187, 122, 60);
            int offsetX = 18;
            int offsetY = 18;
            for (row = 0; row < recipe.height; ++row) {
                for (col = 0; col < recipe.width; ++col) {
                    itemIndex = row * recipe.width + col;
                    if (recipe.ingredients[itemIndex] == null) continue;
                    renderX = newx + offsetX * col + 1;
                    renderY = newy + offsetY * row + 1;
                    arw.a();
                    this.itemRenderer.a(this.l, this.f.o, recipe.ingredients[itemIndex], renderX, renderY);
                    arw.b();
                }
            }
            for (row = 0; row < recipe.height; ++row) {
                for (col = 0; col < recipe.width; ++col) {
                    itemIndex = row * recipe.width + col;
                    renderX = newx + offsetX * col + 1;
                    renderY = newy + offsetY * row + 1;
                    this.checkMouseHover(recipe.ingredients[itemIndex], renderX, renderY, 18);
                }
            }
            GL11.glPushMatrix();
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glTranslatef((float)((float)newx / 3.0f + 1.0f), (float)((float)newy / 3.0f - 0.75f), (float)0.0f);
            arw.a();
            this.itemRenderer.a(this.l, this.f.o, recipe.output, newx / 3 + 60, newy / 3 + 11);
            this.itemRenderer.c(this.l, this.f.o, recipe.output, newx / 3 + 60, newy / 3 + 11);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            this.checkMouseHover(recipe.output, newx + 90, newy + 20, 25);
            GL11.glPopMatrix();
            ++indexPosition;
            newy += 62;
        }
    }

    private void checkMouseHover(ur itemstack, int k, int l, int size) {
        String s;
        boolean flag;
        float scale;
        switch (this.f.y.ah) {
            case 1: {
                scale = 4.0f;
                break;
            }
            case 2: {
                scale = 2.0f;
                break;
            }
            case 3: {
                scale = 3.0f;
                break;
            }
            default: {
                scale = 2.0f;
            }
        }
        int i = (int)((float)Mouse.getEventX() / scale);
        int j = (int)((float)this.h - (float)Mouse.getEventY() / scale);
        boolean bl = flag = i >= k && j >= l && i < k + size && j < l + size;
        if (itemstack != null && flag && (s = itemstack.b().l(itemstack)).length() > 0) {
            arw.a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int l2 = this.l.a(s);
            int i2 = i - l2 - 4;
            int k2 = j;
            this.a(i2 - 3, k2 - 3, i2 + l2 + 3, k2 + 8 + 3, -1073741824, -1073741824);
            this.l.a(s, i2, k2, -1);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
    }
}

