/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.mapgen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.biomes.BiomeGenTropicraft;

public class MapGenVolcano {
    protected HashMap coordMap = new HashMap();
    public static List volcanoSpawnBiomes = Arrays.asList(new yy[]{BiomeGenTropicraft.rainforestPlains, BiomeGenTropicraft.tropics});

    public byte[] generate(yc worldObj, int i, int k, byte[] bytes) {
        s volcanoCoords = this.getVolcanoNear(worldObj, i, k);
        if (volcanoCoords == null) {
            return bytes;
        }
        int[] heightmap = new int[256];
        for (int x = 0; x < 16; ++x) {
            block1: for (int z2 = 0; z2 < 16; ++z2) {
                for (int y2 = 0; y2 < 127; ++y2) {
                    int index = (x * 16 + z2) * 128 + y2;
                    if (bytes[index] == 0 || bytes[index] == amq.E.cm) {
                        heightmap[x * 16 + z2] = y2;
                        continue block1;
                    }
                    if (y2 <= 75) continue;
                    heightmap[x * 16 + z2] = y2;
                    continue block1;
                }
            }
        }
        Random rand = new Random(worldObj.E() * (long)(i * 42 + k * 453));
        i *= 16;
        k *= 16;
        int volcCenterX = volcanoCoords.a;
        int volcCenterZ = volcanoCoords.c;
        int radius = volcanoCoords.b;
        for (int x = 0; x < 16; ++x) {
            for (int z3 = 0; z3 < 16; ++z3) {
                int index;
                int y3;
                int x2 = x + i;
                int z2 = z3 + k;
                double distance = Math.sqrt(Math.pow(x2 - volcCenterX, 2.0) + Math.pow(z2 - volcCenterZ, 2.0));
                int tY = heightmap[x * 16 + z3];
                if (!(distance < (double)radius)) continue;
                double d1 = (double)radius - distance;
                int yUp = (int)Math.pow(0.5 * d1, 2.0);
                if (yUp + tY > 100) {
                    for (y3 = 0; y3 < 127; ++y3) {
                        index = (x * 16 + z3) * 128 + y3;
                        bytes[index] = y3 == 90 && rand.nextInt(20) != 0 ? (byte)TropicraftMod.chunkBlock.cm : (y3 < 80 ? (byte)amq.G.cm : (byte)0);
                    }
                    continue;
                }
                if (tY + yUp > 95) {
                    yUp = 95 - tY;
                }
                for (y3 = 0; y3 < 127; ++y3) {
                    index = (x * 16 + z3) * 128 + y3;
                    if (y3 >= tY + yUp) continue;
                    bytes[index] = (byte)TropicraftMod.chunkBlock.cm;
                }
            }
        }
        return bytes;
    }

    protected boolean canGenVolcanoAtCoords(yc worldObj, int i, int j) {
        int numChunks = 32;
        int offsetChunks = 8;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= numChunks - 1;
        }
        if (j < 0) {
            j -= numChunks - 1;
        }
        int randX = i / numChunks;
        int randZ = j / numChunks;
        long seed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldObj.K().b() + 4291726L;
        Random rand = new Random(seed);
        randX *= numChunks;
        randZ *= numChunks;
        if (oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks))) {
            return worldObj.t().a(oldi * 16 + 8, oldj * 16 + 8, 0, volcanoSpawnBiomes);
        }
        return false;
    }

    public s getVolcanoNear(yc worldObj, int i, int j) {
        int range = 2;
        for (int x = i - range; x <= i + range; ++x) {
            for (int z2 = j - range; z2 <= j + range; ++z2) {
                if (!this.canGenVolcanoAtCoords(worldObj, x, z2)) continue;
                long seed = (long)x * 341873128712L + (long)z2 * 132897987541L + worldObj.K().b() + 4291726L;
                Random rand = new Random(seed);
                int radius = rand.nextInt(10) + 20;
                return new s(x * 16 + 8, radius, z2 * 16 + 8);
            }
        }
        return null;
    }
}

