/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.structures;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.structures.KoaBridgePiece;
import net.tropicraft.world.structures.KoaVillage;
import net.tropicraft.world.structures.KoaVillageComponent;
import net.tropicraft.world.structures.KoaVillageHut;
import net.tropicraft.world.structures.KoaVillageManager;
import net.tropicraft.world.structures.KoaVillageWell;

public class KoaVillageGenerator {
    private static final List waterBlockIDs = Arrays.asList(amq.D.cm, amq.E.cm, TropicraftMod.waterMovingTropics.cm, TropicraftMod.waterStillTropics.cm);
    private static final List sandBlockIDs = Arrays.asList(amq.H.cm, TropicraftMod.purifiedSand.cm);
    public static LinkedList bridgePieceList;
    public KoaVillage village;

    public KoaVillageGenerator(yc world) {
        this.village = new KoaVillage(world);
        bridgePieceList = new LinkedList();
    }

    private void generateSexy(yc world, Random random, int i, int j, int k, int dir) {
        int x = i;
        int y2 = j - 1;
        int z2 = k;
        amq thatchStair = TropicraftMod.thatchStairs;
        for (int a = 0; a < 6; ++a) {
            int yLoc;
            int xOffset = random.nextInt(8) - random.nextInt(8);
            int zOffset = random.nextInt(8) - random.nextInt(8);
            for (yLoc = y2 + 6; yLoc > y2 - 4 && world.a(x + xOffset, yLoc, z2 + zOffset) == 0; --yLoc) {
            }
            if (!sandBlockIDs.contains(world.a(x + xOffset, yLoc, z2 + zOffset)) || world.a(x + xOffset, yLoc + 1, z2 + zOffset) != 0 || world.a(x + xOffset, yLoc + 2, z2 + zOffset) != 0 || world.a(x + xOffset, yLoc + 3, z2 + zOffset) != 0) continue;
            this.placeWithMetadata(world, x + xOffset, yLoc + 1, z2 + zOffset, TropicraftMod.tikiTorch, 1, false);
            this.placeWithMetadata(world, x + xOffset, yLoc + 2, z2 + zOffset, TropicraftMod.tikiTorch, 1, false);
            this.placeWithMetadata(world, x + xOffset, yLoc + 3, z2 + zOffset, TropicraftMod.tikiTorch, 0, false);
        }
        switch (dir) {
            case 0: {
                this.placeWithMetadata(world, i - 1, j, k, thatchStair, 0);
                this.placeWithMetadata(world, i - 1, j, k + 1, thatchStair, 0);
                this.placeWithMetadata(world, i - 1, j, k - 1, thatchStair, 0);
                if (world.a(i - 2, j - 1, k) != 0 && world.a(i - 2, j - 1, k - 1) != 0 && world.a(i - 2, j - 1, k + 1) != 0) break;
                this.placeWithMetadata(world, i - 2, j - 1, k, thatchStair, 0);
                this.placeWithMetadata(world, i - 2, j - 1, k + 1, thatchStair, 0);
                this.placeWithMetadata(world, i - 2, j - 1, k - 1, thatchStair, 0);
                break;
            }
            case 1: {
                this.placeWithMetadata(world, i + 1, j, k, thatchStair, 1);
                this.placeWithMetadata(world, i + 1, j, k + 1, thatchStair, 1);
                this.placeWithMetadata(world, i + 1, j, k - 1, thatchStair, 1);
                if (world.a(i + 2, j - 1, k) != 0 && world.a(i + 2, j - 1, k - 1) != 0 && world.a(i + 2, j - 1, k + 1) != 0) break;
                this.placeWithMetadata(world, i + 2, j - 1, k, thatchStair, 1);
                this.placeWithMetadata(world, i + 2, j - 1, k + 1, thatchStair, 1);
                this.placeWithMetadata(world, i + 2, j - 1, k - 1, thatchStair, 1);
                break;
            }
            case 2: {
                this.placeWithMetadata(world, i, j, k - 1, thatchStair, 2);
                this.placeWithMetadata(world, i + 1, j, k - 1, thatchStair, 2);
                this.placeWithMetadata(world, i - 1, j, k - 1, thatchStair, 2);
                if (world.a(i, j - 1, k - 2) != 0 && world.a(i - 1, j - 1, k - 2) != 0 && world.a(i + 1, j - 1, k - 2) != 0) break;
                this.placeWithMetadata(world, i, j - 1, k - 2, thatchStair, 2);
                this.placeWithMetadata(world, i - 1, j - 1, k - 2, thatchStair, 2);
                this.placeWithMetadata(world, i + 1, j - 1, k - 2, thatchStair, 2);
                break;
            }
            case 3: {
                this.placeWithMetadata(world, i, j, k + 1, thatchStair, 3);
                this.placeWithMetadata(world, i + 1, j, k + 1, thatchStair, 3);
                this.placeWithMetadata(world, i - 1, j, k + 1, thatchStair, 3);
                if (world.a(i, j - 1, k - 2) != 0 && world.a(i - 1, j - 1, k - 2) != 0 && world.a(i + 1, j - 1, k - 2) != 0) break;
                this.placeWithMetadata(world, i, j - 1, k + 2, thatchStair, 3);
                this.placeWithMetadata(world, i - 1, j - 1, k + 2, thatchStair, 3);
                this.placeWithMetadata(world, i + 1, j - 1, k + 2, thatchStair, 3);
                break;
            }
        }
    }

    protected void placeWithMetadata(yc world, int i, int j, int k, amq block, int meta) {
        this.placeWithMetadata(world, i, j, k, block, meta, true);
    }

    protected void placeWithMetadata(yc world, int i, int j, int k, amq block, int meta, boolean notify) {
        if (notify) {
            world.d(i, j, k, block.cm, meta);
        } else {
            world.c(i, j, k, block.cm, meta);
        }
    }

    private boolean generateBridges(yc world, Random random, int x, int y2, int z2, int dir, int length) {
        if (this.canSimulateBridge(world, x, y2, z2, dir, length)) {
            if (length > 50) {
                length = 43;
            }
            if (length > 40) {
                length -= 3;
            }
            if (length > 25) {
                length -= 4;
            }
            if (length < 25) {
                return false;
            }
            KoaVillageManager.villageMap.put(this.village.id, this.village);
            this.generateSexy(world, random, x, y2, z2, dir);
            this.generateBridge(world, random, x, y2, z2, dir, length -= 5);
            this.generateHuts(world, random);
            int maxAdditionalBridges = random.nextInt(2) + 2;
            if (dir == 0) {
                x += length + 1;
            } else if (dir == 1) {
                x -= length + 1;
            } else {
                z2 = dir == 2 ? (z2 += length + 1) : (z2 -= length + 1);
            }
            for (int segment = 0; segment < maxAdditionalBridges; ++segment) {
                int[] pdirs = new int[]{0, 0};
                if (dir == 0 || dir == 1) {
                    pdirs[0] = 2;
                    pdirs[1] = 3;
                } else if (dir == 2 || dir == 3) {
                    pdirs[0] = 0;
                    pdirs[1] = 1;
                }
                int maxLength = -1;
                int newDir = -1;
                if (this.getMaxDistance(world, x, y2, z2, pdirs[0]) > maxLength) {
                    maxLength = this.getMaxDistance(world, x, y2, z2, pdirs[0]);
                    newDir = pdirs[0];
                }
                if (this.getMaxDistance(world, x, y2, z2, pdirs[1]) > maxLength) {
                    maxLength = this.getMaxDistance(world, x, y2, z2, pdirs[1]);
                    newDir = pdirs[1];
                }
                if (newDir == 0) {
                    --x;
                } else if (newDir == 1) {
                    ++x;
                } else {
                    z2 = newDir == 2 ? --z2 : ++z2;
                }
                length = maxLength;
                if (length > 50) {
                    length = 43;
                }
                if (length > 30) {
                    length -= 8;
                }
                if (length > 15) {
                    length -= 4;
                }
                if (length < 10 || !this.canSimulateBridge(world, x, y2, z2, newDir, length -= 3)) continue;
                this.generateBridge(world, random, x, y2, z2, newDir, length);
                this.generateHuts(world, random);
                dir = newDir;
                if (dir == 0) {
                    x += length + 1;
                    continue;
                }
                if (dir == 1) {
                    x -= length + 1;
                    continue;
                }
                if (dir == 2) {
                    z2 += length + 1;
                    continue;
                }
                z2 -= length + 1;
            }
            return true;
        }
        return false;
    }

    private void generateHuts(yc world, Random random) {
        for (KoaBridgePiece kbp : bridgePieceList) {
            KoaVillageComponent component;
            if (!kbp.canBuildHere) continue;
            kbp.canBuildHere = false;
            if (random.nextFloat() < 0.4f) {
                component = new KoaVillageWell(this.village, this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[0], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[1], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[2]);
                if (!((KoaVillageWell)component).canFitInWorld(world)) continue;
                ((KoaVillageWell)component).generate(world);
                continue;
            }
            component = new KoaVillageHut(this.village, this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[0], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[1], this.coordsOfAdjacentAir(world, kbp.x, kbp.y, kbp.z)[2]);
            if (!((KoaVillageHut)component).canFitInWorld(world)) continue;
            ((KoaVillageHut)component).generate(world);
        }
        for (s ksp : this.village.spawnPoints) {
            this.place(world, ksp.a, ksp.b, ksp.c, TropicraftMod.bambooChest);
        }
    }

    private int[] coordsOfAdjacentAir(yc world, int i, int j, int k) {
        int[] asdf = new int[4];
        if (world.a(i + 1, j, k) == 0) {
            asdf[0] = i + 1;
            asdf[1] = j;
            asdf[2] = k;
            asdf[3] = i + 1;
        } else if (world.a(i - 1, j, k) == 0) {
            asdf[0] = i - 1;
            asdf[1] = j;
            asdf[2] = k;
            asdf[3] = i - 1;
        } else if (world.a(i + 1, j, k + 1) == 0) {
            asdf[0] = i + 1;
            asdf[1] = j;
            asdf[2] = k + 1;
            asdf[3] = 0;
        } else if (world.a(i - 1, j, k - 1) == 0) {
            asdf[0] = i - 1;
            asdf[1] = j;
            asdf[2] = k - 1;
            asdf[3] = 0;
        } else if (world.a(i, j, k + 1) == 0) {
            asdf[0] = i;
            asdf[1] = j;
            asdf[2] = k + 1;
            asdf[3] = k + 1;
        } else if (world.a(i, j, k - 1) == 0) {
            asdf[0] = i;
            asdf[1] = j;
            asdf[2] = k - 1;
            asdf[3] = k - 1;
        } else if (world.a(i - 1, j, k + 1) == 0) {
            asdf[0] = i - 1;
            asdf[1] = j;
            asdf[2] = k + 1;
            asdf[3] = 0;
        } else if (world.a(i + 1, j, k - 1) == 0) {
            asdf[0] = i + 1;
            asdf[1] = j;
            asdf[2] = k - 1;
            asdf[3] = 0;
        }
        return asdf;
    }

    private void generateBridge(yc world, Random random, int i, int j, int k, int dir, int length) {
        amq bridgebl = TropicraftMod.thatchBlock;
        switch (dir) {
            case 0: {
                for (int a = 0; a < length; ++a) {
                    this.genBridgePiece(world, i + a, j, k, bridgebl);
                    this.genBridgePiece(world, i + a, j, k + 1, bridgebl, a, 0, length);
                    this.genBridgePiece(world, i + a, j, k - 1, bridgebl, a, 1, length);
                }
                break;
            }
            case 1: {
                for (int a = 0; a < length; ++a) {
                    this.genBridgePiece(world, i - a, j, k, bridgebl);
                    this.genBridgePiece(world, i - a, j, k + 1, bridgebl, a, 0, length);
                    this.genBridgePiece(world, i - a, j, k - 1, bridgebl, a, 1, length);
                }
                break;
            }
            case 2: {
                for (int a = 0; a < length; ++a) {
                    this.genBridgePiece(world, i, j, k + a, bridgebl);
                    this.genBridgePiece(world, i + 1, j, k + a, bridgebl, a, 0, length);
                    this.genBridgePiece(world, i - 1, j, k + a, bridgebl, a, 1, length);
                }
                break;
            }
            case 3: {
                for (int a = 0; a < length; ++a) {
                    this.genBridgePiece(world, i, j, k - a, bridgebl);
                    this.genBridgePiece(world, i + 1, j, k - a, bridgebl, a, 0, length);
                    this.genBridgePiece(world, i - 1, j, k - a, bridgebl, a, 1, length);
                }
                break;
            }
        }
        this.generateHuts(world, random);
    }

    private void genBridgePiece(yc world, int i, int j, int k, amq block, int count, int decide, int totalLength) {
        if (decide == 0) {
            this.place(world, i, j, k, block);
            int r2 = world.t.nextInt(1) + 14;
            bridgePieceList.add(new KoaBridgePiece(i, j, k, count % r2 == 0 && this.hasAdjacentAir(world, i, j, k) && count > 2 && count < totalLength - 4));
        } else {
            this.place(world, i, j, k, block);
            int r3 = world.t.nextInt(1) + 11;
            bridgePieceList.add(new KoaBridgePiece(i, j, k, count % r3 == 0 && this.hasAdjacentAir(world, i, j, k) && count > 2 && count < totalLength - 4));
        }
    }

    private boolean hasAdjacentAir(yc world, int i, int j, int k) {
        return world.a(i + 1, j, k) == 0 || world.a(i - 1, j, k) == 0 || world.a(i, j, k - 1) == 0 || world.a(i, j, k + 1) == 0 || world.a(i + 1, j, k + 1) == 0 || world.a(i + 1, j, k - 1) == 0 || world.a(i - 1, j, k - 1) == 0 || world.a(i - 1, j, k + 1) == 0;
    }

    private void genBridgePiece(yc world, int i, int j, int k, amq block) {
        this.place(world, i, j, k, block);
        bridgePieceList.add(new KoaBridgePiece(i, j, k, false));
    }

    private boolean canSimulateBridge(yc world, int i, int j, int k, int dir, int length) {
        switch (dir) {
            case 0: {
                for (int a = 0; a < length; ++a) {
                    if (world.a(i + a, j, k) == 0 && world.a(i + a, j, k + 1) == 0 && world.a(i + a, j, k - 1) == 0) continue;
                    return false;
                }
                break;
            }
            case 1: {
                for (int a = 0; a < length; ++a) {
                    if (world.a(i - a, j, k) == 0 && world.a(i - a, j, k + 1) == 0 && world.a(i - a, j, k - 1) == 0) continue;
                    return false;
                }
                break;
            }
            case 2: {
                for (int a = 0; a < length; ++a) {
                    if (world.a(i, j, k + a) == 0 && world.a(i + 1, j, k + a) == 0 && world.a(i - 1, j, k + a) == 0) continue;
                    return false;
                }
                break;
            }
            case 3: {
                for (int a = 0; a < length; ++a) {
                    if (world.a(i, j, k - a) == 0 && world.a(i + 1, j, k - a) == 0 && world.a(i - 1, j, k - a) == 0) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    private void place(yc world, int i, int j, int k, amq block) {
        this.place(world, i, j, k, block, true);
    }

    private void place(yc world, int i, int j, int k, amq block, boolean notify) {
        if (notify) {
            world.e(i, j, k, block.cm);
        } else {
            world.b(i, j, k, block.cm);
        }
    }

    public boolean generate(yc world, Random random, int i, int j, int k) {
        int genDirection = this.canGenerateStart(world, random, i, j - 1, k);
        return this.generate(world, random, i, j, k, genDirection);
    }

    public boolean generate(yc world, Random random, int i, int j, int k, int direction) {
        if (direction != -1 && sandBlockIDs.contains(world.a(i, j - 1, k))) {
            int idir = direction;
            int dist = this.getMaxDistance(world, i, j + 1, k, idir);
            boolean generated = this.generateBridges(world, random, i, j + 1, k, idir, dist);
            if (generated) {
                this.village.spawnEntities(world);
            }
            return generated;
        }
        return false;
    }

    private int canGenerateStart(yc world, Random random, int i, int j, int k) {
        int dir = -1;
        boolean[] adjacentWater = new boolean[]{waterBlockIDs.contains(world.a(i + 1, j, k)), waterBlockIDs.contains(world.a(i - 1, j, k)), waterBlockIDs.contains(world.a(i, j, k + 1)), waterBlockIDs.contains(world.a(i, j, k - 1))};
        int numTrue = 0;
        for (int b = 0; b < 4; ++b) {
            if (!adjacentWater[b]) continue;
            ++numTrue;
            dir = b;
        }
        if (numTrue > 1) {
            return -1;
        }
        if (numTrue == 0) {
            return -1;
        }
        return dir;
    }

    private int getMaxDistance(yc world, int i, int j, int k, int direction) {
        int max = 0;
        int id = TropicraftMod.thatchBlock.cm;
        switch (direction) {
            case 0: {
                for (int a = 1; a < 80; ++a) {
                    if (!(waterBlockIDs.contains(world.a(i + a, j - 2, k)) || world.a(i + a, j, k) != 0 && world.a(i + a, j, k) != id)) {
                        return a;
                    }
                    ++max;
                }
                break;
            }
            case 1: {
                for (int a = 1; a < 80; ++a) {
                    if (!(waterBlockIDs.contains(world.a(i - a, j - 2, k)) || world.a(i - a, j, k) != 0 && world.a(i - a, j, k) != id)) {
                        return a;
                    }
                    ++max;
                }
                break;
            }
            case 2: {
                for (int a = 1; a < 80; ++a) {
                    if (!(waterBlockIDs.contains(world.a(i, j - 2, k + a)) || world.a(i, j, k + a) != 0 && world.a(i, j, k + a) != id)) {
                        return a;
                    }
                    ++max;
                }
                break;
            }
            case 3: {
                for (int a = 1; a < 80; ++a) {
                    if (!(waterBlockIDs.contains(world.a(i, j - 2, k - a)) || world.a(i, j, k - a) != 0 && world.a(i, j, k - a) != id)) {
                        return a;
                    }
                    ++max;
                }
                break;
            }
        }
        if (max >= 79) {
            return 50;
        }
        return -1;
    }
}

