/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.structures;

import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.structures.KoaVillage;
import net.tropicraft.world.structures.KoaVillageComponent;

public class KoaVillageHut
extends KoaVillageComponent {
    private static final int bridgeBlockID = TropicraftMod.thatchBlock.cm;
    private amq thatchBlock = TropicraftMod.thatchBlock;
    private amq bambooFence = TropicraftMod.bambooFence;
    private amq palmWood = TropicraftMod.tropicalWood;
    private amq bambooBlock = TropicraftMod.bambooBlock;
    private amq thatchSlab = TropicraftMod.tropicalSingleSlab;
    private amq thatchStair = TropicraftMod.thatchStairs;
    private amq tikiTorch = TropicraftMod.tikiTorch;

    public KoaVillageHut(KoaVillage village, int x, int y2, int z2) {
        this.village = village;
        this.homeX = x;
        this.homeY = y2;
        this.homeZ = z2;
    }

    @Override
    public boolean canFitInWorld(yc world) {
        if (world.a(this.homeX + 1, this.homeY, this.homeZ) == bridgeBlockID) {
            for (int x = -7; x < 1; ++x) {
                for (int z2 = -4; z2 < 6; ++z2) {
                    if (world.a(this.homeX + x, this.homeY, this.homeZ + z2) == 0) continue;
                    return false;
                }
            }
            this.genX = this.homeX;
            this.genY = this.homeY;
            this.genZ = this.homeZ;
            this.genDirection = 2;
        } else if (world.a(this.homeX - 1, this.homeY, this.homeZ) == bridgeBlockID) {
            for (int x = 0; x < 8; ++x) {
                for (int z3 = -4; z3 < 6; ++z3) {
                    if (world.a(this.homeX + x, this.homeY, this.homeZ + z3) == 0) continue;
                    return false;
                }
            }
            this.genX = this.homeX;
            this.genY = this.homeY;
            this.genZ = this.homeZ;
            this.genDirection = 1;
        } else if (world.a(this.homeX, this.homeY, this.homeZ + 1) == bridgeBlockID) {
            for (int x = -5; x < 4; ++x) {
                for (int z4 = -6; z4 < 1; ++z4) {
                    if (world.a(this.homeX + x, this.homeY, this.homeZ + z4) == 0) continue;
                    return false;
                }
            }
            this.genX = this.homeX;
            this.genY = this.homeY;
            this.genZ = this.homeZ;
            this.genDirection = 3;
        } else if (world.a(this.homeX, this.homeY, this.homeZ - 1) == bridgeBlockID) {
            for (int x = -5; x < 4; ++x) {
                for (int z5 = 0; z5 < 6; ++z5) {
                    if (world.a(this.homeX + x, this.homeY, this.homeZ + z5) == 0) continue;
                    return false;
                }
            }
            this.genX = this.homeX;
            this.genY = this.homeY;
            this.genZ = this.homeZ;
            this.genDirection = 4;
        }
        return true;
    }

    @Override
    public void spawn(yc world) {
    }

    @Override
    public void generate(yc world) {
        if (this.genDirection == 1) {
            this.genHutOne(world, this.genX, this.genY, this.genZ);
        } else if (this.genDirection == 2) {
            this.genHutTwo(world, this.genX, this.genY, this.genZ);
        } else if (this.genDirection == 3) {
            this.genHutThree(world, this.genX, this.genY, this.genZ);
        } else if (this.genDirection == 4) {
            this.genHutFour(world, this.genX, this.genY, this.genZ);
        }
    }

    private void genHutOne(yc world, int x, int y2, int z2) {
        int b;
        int a;
        boolean setSpawn = false;
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                this.place(world, x + a, y2, z2 + b, this.thatchBlock);
            }
        }
        for (a = 0; a < 5; ++a) {
            for (b = 0; b < 8; ++b) {
                if (a == 2 && b == 2) {
                    this.village.spawnPoints.add(new s(x + a + 2, y2 + 1, z2 + b - 3));
                }
                this.place(world, x + a + 2, y2, z2 + b - 3, this.thatchBlock);
                if (a != 0 && a != 4 || b != 0 && b != 7) continue;
                this.placeDownTilGround(world, x + a + 2, y2 - 1, z2 + b - 3, this.bambooFence);
            }
        }
        for (a = 0; a < 3; ++a) {
            this.place(world, x + 3 + a, y2 + 1, z2 - 3, this.bambooBlock);
            this.place(world, x + 3 + a, y2 + 1, z2 + 4, this.bambooBlock);
            this.place(world, x + 3 + a, y2 + 3, z2 - 3, this.bambooBlock);
            this.place(world, x + 3 + a, y2 + 3, z2 + 4, this.bambooBlock);
            this.place(world, x + 3 + a, y2 + 4, z2 - 3, this.palmWood);
            this.place(world, x + 3 + a, y2 + 4, z2 + 4, this.palmWood);
            this.place(world, x + 3 + a, y2 + 5, z2 - 3, this.thatchBlock);
            this.place(world, x + 3 + a, y2 + 5, z2 + 4, this.thatchBlock);
            this.place(world, x + 3 + a, y2 + 5, z2 - 4, this.thatchSlab, 1);
            this.place(world, x + 3 + a, y2 + 5, z2 + 5, this.thatchSlab, 1);
            this.place(world, x + 3 + a, y2 + 6, z2 - 2, this.thatchSlab, 1);
            this.place(world, x + 3 + a, y2 + 6, z2 + 3, this.thatchSlab, 1);
        }
        this.placeWithMetadata(world, x + 4, y2 + 6, z2 - 2, this.thatchStair, 2);
        this.placeWithMetadata(world, x + 4, y2 + 6, z2 + 3, this.thatchStair, 3);
        for (a = 0; a < 4; ++a) {
            this.placeWithMetadata(world, x + 5, y2 + 6, z2 - 2 + a + 1, this.thatchStair, 1);
            this.placeWithMetadata(world, x + 3, y2 + 6, z2 - 2 + a + 1, this.thatchStair, 0);
        }
        this.place(world, x + 4, y2 + 7, z2 + 2, this.thatchSlab, 1);
        this.place(world, x + 4, y2 + 7, z2 - 1, this.thatchSlab, 1);
        this.place(world, x + 4, y2 + 7, z2 + 1, this.thatchSlab, 1);
        this.place(world, x + 4, y2 + 7, z2, this.thatchSlab, 1);
        for (a = 0; a < 7; ++a) {
            this.place(world, x + 6, y2 + 1, z2 - 3 + a, this.bambooBlock);
            this.place(world, x + 6, y2 + 3, z2 - 3 + a, this.bambooBlock);
            this.place(world, x + 2, y2 + 3, z2 - 3 + a, this.bambooBlock);
            this.place(world, x + 6, y2 + 4, z2 - 3 + a, this.palmWood);
            this.place(world, x + 2, y2 + 4, z2 - 3 + a, this.palmWood);
            this.place(world, x + 6, y2 + 5, z2 - 3 + a, this.thatchBlock);
            this.place(world, x + 2, y2 + 5, z2 - 3 + a, this.thatchBlock);
            if (a == 3 || a == 4) continue;
            this.place(world, x + 2, y2 + 1, z2 - 3 + a, this.bambooBlock);
        }
        this.place(world, x - 1, y2 + 1, z2 - 1, this.bambooFence);
        this.place(world, x - 1, y2 + 1, z2 + 2, this.bambooFence);
        this.place(world, x - 1, y2 + 2, z2 - 1, this.tikiTorch, 0);
        this.place(world, x - 1, y2 + 2, z2 + 2, this.tikiTorch, 0);
        this.place(world, x + 2, y2 + 2, z2 - 1, this.palmWood);
        this.place(world, x + 2, y2 + 2, z2 + 2, this.palmWood);
        for (a = 0; a < 4; ++a) {
            this.place(world, x + 2, y2 + 1 + a, z2 - 3, this.palmWood);
            this.place(world, x + 2, y2 + 1 + a, z2 + 4, this.palmWood);
            this.place(world, x + 6, y2 + 1 + a, z2 - 3, this.palmWood);
            this.place(world, x + 6, y2 + 1 + a, z2 + 4, this.palmWood);
            if (a != 3) continue;
            this.place(world, x + 2, y2 + 2 + a, z2 - 3, this.thatchBlock);
            this.place(world, x + 2, y2 + 2 + a, z2 + 4, this.thatchBlock);
            this.place(world, x + 6, y2 + 2 + a, z2 - 3, this.thatchBlock);
            this.place(world, x + 6, y2 + 2 + a, z2 + 4, this.thatchBlock);
            this.place(world, x + 2, y2 + 2 + a, z2 - 4, this.thatchSlab, 1);
            this.place(world, x + 2, y2 + 2 + a, z2 + 5, this.thatchSlab, 1);
            this.place(world, x + 6, y2 + 2 + a, z2 - 4, this.thatchSlab, 1);
            this.place(world, x + 6, y2 + 2 + a, z2 + 5, this.thatchSlab, 1);
        }
        for (a = 0; a < 10; ++a) {
            this.place(world, x + 1, y2 + 5, z2 - 4 + a, this.thatchSlab, 1);
            this.place(world, x + 7, y2 + 5, z2 - 4 + a, this.thatchSlab, 1);
        }
    }

    private void genHutTwo(yc world, int x, int y2, int z2) {
        int b;
        int a;
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                this.place(world, x - a, y2, z2 + b, this.thatchBlock);
            }
        }
        for (a = 0; a < 5; ++a) {
            for (b = 0; b < 8; ++b) {
                if (a == 2 && b == 2) {
                    this.village.spawnPoints.add(new s(x - a - 2, y2 + 1, z2 + b - 3));
                }
                this.place(world, x - a - 2, y2, z2 + b - 3, this.thatchBlock);
                if (a != 0 && a != 4 || b != 0 && b != 7) continue;
                this.placeDownTilGround(world, x - a - 2, y2 - 1, z2 + b - 3, this.bambooFence);
            }
        }
        for (a = 0; a < 3; ++a) {
            this.place(world, x - 3 - a, y2 + 1, z2 - 3, this.bambooBlock);
            this.place(world, x - 3 - a, y2 + 1, z2 + 4, this.bambooBlock);
            this.place(world, x - 3 - a, y2 + 3, z2 - 3, this.bambooBlock);
            this.place(world, x - 3 - a, y2 + 3, z2 + 4, this.bambooBlock);
            this.place(world, x - 3 - a, y2 + 4, z2 - 3, this.palmWood);
            this.place(world, x - 3 - a, y2 + 4, z2 + 4, this.palmWood);
            this.place(world, x - 3 - a, y2 + 5, z2 - 3, this.thatchBlock);
            this.place(world, x - 3 - a, y2 + 5, z2 + 4, this.thatchBlock);
            this.place(world, x - 3 - a, y2 + 5, z2 - 4, this.thatchSlab, 1);
            this.place(world, x - 3 - a, y2 + 5, z2 + 5, this.thatchSlab, 1);
            this.place(world, x - 3 - a, y2 + 6, z2 - 2, this.thatchSlab, 1);
            this.place(world, x - 3 - a, y2 + 6, z2 + 3, this.thatchSlab, 1);
        }
        this.placeWithMetadata(world, x - 4, y2 + 6, z2 - 2, this.thatchStair, 2);
        this.placeWithMetadata(world, x - 4, y2 + 6, z2 + 3, this.thatchStair, 3);
        for (a = 0; a < 4; ++a) {
            this.placeWithMetadata(world, x - 5, y2 + 6, z2 - 2 + a + 1, this.thatchStair, 0);
            this.placeWithMetadata(world, x - 3, y2 + 6, z2 - 2 + a + 1, this.thatchStair, 1);
        }
        this.place(world, x - 4, y2 + 7, z2 + 2, this.thatchSlab, 1);
        this.place(world, x - 4, y2 + 7, z2 - 1, this.thatchSlab, 1);
        this.place(world, x - 4, y2 + 7, z2 + 1, this.thatchSlab, 1);
        this.place(world, x - 4, y2 + 7, z2, this.thatchSlab, 1);
        for (a = 0; a < 7; ++a) {
            this.place(world, x - 6, y2 + 1, z2 - 3 + a, this.bambooBlock);
            this.place(world, x - 6, y2 + 3, z2 - 3 + a, this.bambooBlock);
            this.place(world, x - 2, y2 + 3, z2 - 3 + a, this.bambooBlock);
            this.place(world, x - 6, y2 + 4, z2 - 3 + a, this.palmWood);
            this.place(world, x - 2, y2 + 4, z2 - 3 + a, this.palmWood);
            this.place(world, x - 6, y2 + 5, z2 - 3 + a, this.thatchBlock);
            this.place(world, x - 2, y2 + 5, z2 - 3 + a, this.thatchBlock);
            if (a == 3 || a == 4) continue;
            this.place(world, x - 2, y2 + 1, z2 - 3 + a, this.bambooBlock);
        }
        this.place(world, x + 1, y2 + 1, z2 - 1, this.bambooFence);
        this.place(world, x + 1, y2 + 1, z2 + 2, this.bambooFence);
        this.place(world, x + 1, y2 + 2, z2 - 1, this.tikiTorch, 0);
        this.place(world, x + 1, y2 + 2, z2 + 2, this.tikiTorch, 0);
        this.place(world, x - 2, y2 + 2, z2 - 1, this.palmWood);
        this.place(world, x - 2, y2 + 2, z2 + 2, this.palmWood);
        for (a = 0; a < 4; ++a) {
            this.place(world, x - 2, y2 + 1 + a, z2 - 3, this.palmWood);
            this.place(world, x - 2, y2 + 1 + a, z2 + 4, this.palmWood);
            this.place(world, x - 6, y2 + 1 + a, z2 - 3, this.palmWood);
            this.place(world, x - 6, y2 + 1 + a, z2 + 4, this.palmWood);
            if (a != 3) continue;
            this.place(world, x - 2, y2 + 2 + a, z2 - 3, this.thatchBlock);
            this.place(world, x - 2, y2 + 2 + a, z2 + 4, this.thatchBlock);
            this.place(world, x - 6, y2 + 2 + a, z2 - 3, this.thatchBlock);
            this.place(world, x - 6, y2 + 2 + a, z2 + 4, this.thatchBlock);
            this.place(world, x - 2, y2 + 2 + a, z2 - 4, this.thatchSlab, 1);
            this.place(world, x - 2, y2 + 2 + a, z2 + 5, this.thatchSlab, 1);
            this.place(world, x - 6, y2 + 2 + a, z2 - 4, this.thatchSlab, 1);
            this.place(world, x - 6, y2 + 2 + a, z2 + 5, this.thatchSlab, 1);
        }
        for (a = 0; a < 10; ++a) {
            this.place(world, x - 1, y2 + 5, z2 - 4 + a, this.thatchSlab, 1);
            this.place(world, x - 7, y2 + 5, z2 - 4 + a, this.thatchSlab, 1);
        }
    }

    private void genHutThree(yc world, int x, int y2, int z2) {
        int b;
        int a;
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                this.place(world, x - b, y2, z2 - a, this.thatchBlock);
            }
        }
        this.place(world, x - 2, y2 + 1, z2 + 1, this.bambooFence);
        this.place(world, x + 1, y2 + 1, z2 + 1, this.bambooFence);
        this.place(world, x - 2, y2 + 2, z2 + 1, this.tikiTorch, 0);
        this.place(world, x + 1, y2 + 2, z2 + 1, this.tikiTorch, 0);
        for (a = 0; a < 8; ++a) {
            for (b = 0; b < 5; ++b) {
                if (a == 2 && b == 2) {
                    this.village.spawnPoints.add(new s(x - a + 3, y2 + 1, z2 - b - 2));
                }
                this.place(world, x - a + 3, y2, z2 - b - 2, this.thatchBlock);
                if (a != 0 && a != 7 || b != 0 && b != 4) continue;
                this.placeDownTilGround(world, x - a + 3, y2 - 1, z2 - b - 2, this.bambooFence);
            }
        }
        for (a = 0; a < 3; ++a) {
            this.place(world, x - 4, y2 + 1, z2 - a - 3, this.bambooBlock);
            this.place(world, x + 3, y2 + 1, z2 - a - 3, this.bambooBlock);
            this.place(world, x - 4, y2 + 3, z2 - a - 3, this.bambooBlock);
            this.place(world, x + 3, y2 + 3, z2 - a - 3, this.bambooBlock);
            this.place(world, x - 4, y2 + 4, z2 - a - 3, this.palmWood);
            this.place(world, x + 3, y2 + 4, z2 - a - 3, this.palmWood);
            this.place(world, x + 3, y2 + 5, z2 - a - 3, this.thatchBlock);
            this.place(world, x - 4, y2 + 5, z2 - a - 3, this.thatchBlock);
        }
        for (a = 0; a < 6; ++a) {
            this.place(world, x - 3 + a, y2 + 1, z2 - 6, this.bambooBlock);
            this.place(world, x - 3 + a, y2 + 3, z2 - 6, this.bambooBlock);
            this.place(world, x - 3 + a, y2 + 4, z2 - 6, this.palmWood);
            this.place(world, x - 3 + a, y2 + 5, z2 - 6, this.thatchBlock);
            if (a != 2 && a != 3) {
                this.place(world, x - 3 + a, y2 + 1, z2 - 2, this.bambooBlock);
            }
            this.place(world, x - 3 + a, y2 + 3, z2 - 2, this.bambooBlock);
            this.place(world, x - 3 + a, y2 + 4, z2 - 2, this.palmWood);
            this.place(world, x - 3 + a, y2 + 5, z2 - 2, this.thatchBlock);
        }
        this.place(world, x - 3 + 1, y2 + 2, z2 - 2, this.palmWood);
        this.place(world, x - 3 + 4, y2 + 2, z2 - 2, this.palmWood);
        for (a = 0; a < 5; ++a) {
            if (a < 4) {
                this.place(world, x - 4, y2 + 1 + a, z2 - 2, this.palmWood);
                this.place(world, x + 3, y2 + 1 + a, z2 - 2, this.palmWood);
                this.place(world, x - 4, y2 + 1 + a, z2 - 6, this.palmWood);
                this.place(world, x + 3, y2 + 1 + a, z2 - 6, this.palmWood);
                continue;
            }
            if (a != 4) continue;
            this.place(world, x - 4, y2 + 1 + a, z2 - 2, this.thatchBlock);
            this.place(world, x + 3, y2 + 1 + a, z2 - 2, this.thatchBlock);
            this.place(world, x - 4, y2 + 1 + a, z2 - 6, this.thatchBlock);
            this.place(world, x + 3, y2 + 1 + a, z2 - 6, this.thatchBlock);
        }
        for (a = 0; a < 7; ++a) {
            this.place(world, x - 5, y2 + 5, z2 - 1 - a, this.thatchSlab, 1);
            this.place(world, x + 4, y2 + 5, z2 - 1 - a, this.thatchSlab, 1);
        }
        for (a = 0; a < 8; ++a) {
            this.place(world, x - 4 + a, y2 + 5, z2 - 1, this.thatchSlab, 1);
            this.place(world, x - 4 + a, y2 + 5, z2 - 7, this.thatchSlab, 1);
        }
        this.placeWithMetadata(world, x - 3, y2 + 6, z2 - 4, this.thatchStair, 0);
        this.placeWithMetadata(world, x + 2, y2 + 6, z2 - 4, this.thatchStair, 1);
        for (a = 0; a < 6; ++a) {
            if (a == 0 || a == 5) {
                this.place(world, x - 3 + a, y2 + 6, z2 - 3, this.thatchSlab, 1);
                this.place(world, x - 3 + a, y2 + 6, z2 - 5, this.thatchSlab, 1);
                continue;
            }
            this.placeWithMetadata(world, x - 3 + a, y2 + 6, z2 - 3, this.thatchStair, 3);
            this.placeWithMetadata(world, x - 3 + a, y2 + 6, z2 - 5, this.thatchStair, 2);
        }
        for (a = 0; a < 4; ++a) {
            this.place(world, x - 2 + a, y2 + 7, z2 - 4, this.thatchSlab, 1);
        }
    }

    private void genHutFour(yc world, int x, int y2, int z2) {
        int b;
        int a;
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                this.place(world, x - b, y2, z2 + a, this.thatchBlock);
            }
        }
        this.place(world, x - 2, y2 + 1, z2 - 1, this.bambooFence);
        this.place(world, x + 1, y2 + 1, z2 - 1, this.bambooFence);
        this.place(world, x - 2, y2 + 2, z2 - 1, this.tikiTorch, 0);
        this.place(world, x + 1, y2 + 2, z2 - 1, this.tikiTorch, 0);
        for (a = 0; a < 8; ++a) {
            for (b = 0; b < 5; ++b) {
                if (a == 2 && b == 2) {
                    this.village.spawnPoints.add(new s(x - a + 3, y2 + 1, z2 + b + 2));
                }
                this.place(world, x - a + 3, y2, z2 + b + 2, this.thatchBlock);
                if (a != 0 && a != 7 || b != 0 && b != 4) continue;
                this.placeDownTilGround(world, x - a + 3, y2 - 1, z2 + b + 2, this.bambooFence);
            }
        }
        for (a = 0; a < 3; ++a) {
            this.place(world, x - 4, y2 + 1, z2 + a + 3, this.bambooBlock);
            this.place(world, x + 3, y2 + 1, z2 + a + 3, this.bambooBlock);
            this.place(world, x - 4, y2 + 3, z2 + a + 3, this.bambooBlock);
            this.place(world, x + 3, y2 + 3, z2 + a + 3, this.bambooBlock);
            this.place(world, x - 4, y2 + 4, z2 + a + 3, this.palmWood);
            this.place(world, x + 3, y2 + 4, z2 + a + 3, this.palmWood);
            this.place(world, x + 3, y2 + 5, z2 + a + 3, this.thatchBlock);
            this.place(world, x - 4, y2 + 5, z2 + a + 3, this.thatchBlock);
        }
        for (a = 0; a < 6; ++a) {
            this.place(world, x - 3 + a, y2 + 1, z2 + 6, this.bambooBlock);
            this.place(world, x - 3 + a, y2 + 3, z2 + 6, this.bambooBlock);
            this.place(world, x - 3 + a, y2 + 4, z2 + 6, this.palmWood);
            this.place(world, x - 3 + a, y2 + 5, z2 + 6, this.thatchBlock);
            if (a != 2 && a != 3) {
                this.place(world, x - 3 + a, y2 + 1, z2 + 2, this.bambooBlock);
            }
            this.place(world, x - 3 + a, y2 + 3, z2 + 2, this.bambooBlock);
            this.place(world, x - 3 + a, y2 + 4, z2 + 2, this.palmWood);
            this.place(world, x - 3 + a, y2 + 5, z2 + 2, this.thatchBlock);
        }
        this.place(world, x - 3 + 1, y2 + 2, z2 + 2, this.palmWood);
        this.place(world, x - 3 + 4, y2 + 2, z2 + 2, this.palmWood);
        for (a = 0; a < 5; ++a) {
            if (a < 4) {
                this.place(world, x - 4, y2 + 1 + a, z2 + 2, this.palmWood);
                this.place(world, x + 3, y2 + 1 + a, z2 + 2, this.palmWood);
                this.place(world, x - 4, y2 + 1 + a, z2 + 6, this.palmWood);
                this.place(world, x + 3, y2 + 1 + a, z2 + 6, this.palmWood);
                continue;
            }
            if (a != 4) continue;
            this.place(world, x - 4, y2 + 1 + a, z2 + 2, this.thatchBlock);
            this.place(world, x + 3, y2 + 1 + a, z2 + 2, this.thatchBlock);
            this.place(world, x - 4, y2 + 1 + a, z2 + 6, this.thatchBlock);
            this.place(world, x + 3, y2 + 1 + a, z2 + 6, this.thatchBlock);
        }
        for (a = 0; a < 7; ++a) {
            this.place(world, x - 5, y2 + 5, z2 + 1 + a, this.thatchSlab, 1);
            this.place(world, x + 4, y2 + 5, z2 + 1 + a, this.thatchSlab, 1);
        }
        for (a = 0; a < 8; ++a) {
            this.place(world, x - 4 + a, y2 + 5, z2 + 1, this.thatchSlab, 1);
            this.place(world, x - 4 + a, y2 + 5, z2 + 7, this.thatchSlab, 1);
        }
        this.placeWithMetadata(world, x - 3, y2 + 6, z2 + 4, this.thatchStair, 0);
        this.placeWithMetadata(world, x + 2, y2 + 6, z2 + 4, this.thatchStair, 1);
        for (a = 0; a < 6; ++a) {
            if (a == 0 || a == 5) {
                this.place(world, x - 3 + a, y2 + 6, z2 + 3, this.thatchSlab, 1);
                this.place(world, x - 3 + a, y2 + 6, z2 + 5, this.thatchSlab, 1);
                continue;
            }
            this.placeWithMetadata(world, x - 3 + a, y2 + 6, z2 + 3, this.thatchStair, 2);
            this.placeWithMetadata(world, x - 3 + a, y2 + 6, z2 + 5, this.thatchStair, 3);
        }
        for (a = 0; a < 4; ++a) {
            this.place(world, x - 2 + a, y2 + 7, z2 + 4, this.thatchSlab, 1);
        }
    }
}

