/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.structures;

import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.structures.KoaVillage;
import net.tropicraft.world.structures.KoaVillageComponent;

public class KoaVillageWell
extends KoaVillageComponent {
    private static final int bridgeBlockID = TropicraftMod.thatchBlock.cm;
    private amq thatchBlock = TropicraftMod.thatchBlock;
    private amq bambooFence = TropicraftMod.bambooFence;
    private amq thatchStair = TropicraftMod.thatchStairs;
    private amq thatchSlab = TropicraftMod.tropicalSingleSlab;
    private amq tikiTorch = TropicraftMod.tikiTorch;

    public KoaVillageWell(KoaVillage village, int x, int y2, int z2) {
        this.village = village;
        this.homeX = x;
        this.homeY = y2;
        this.homeZ = z2;
    }

    @Override
    public boolean canFitInWorld(yc world) {
        if (world.a(this.homeX + 1, this.homeY, this.homeZ) == bridgeBlockID || world.a(this.homeX - 1, this.homeY, this.homeZ) == bridgeBlockID) {
            if (world.a(this.homeX + 1, this.homeY, this.homeZ) == bridgeBlockID) {
                for (int x1 = -4; x1 < 1; ++x1) {
                    for (int z1 = -1; z1 < 4; ++z1) {
                        if (world.a(this.homeX + x1, this.homeY, this.homeZ + z1) == 0) continue;
                        return false;
                    }
                }
                this.genX = this.homeX;
                this.genY = this.homeY;
                this.genZ = this.homeZ;
                this.genDirection = 2;
                return true;
            }
            if (world.a(this.homeX - 1, this.homeY, this.homeZ) == bridgeBlockID) {
                for (int x1 = -1; x1 < 4; ++x1) {
                    for (int z1 = -1; z1 < 4; ++z1) {
                        if (world.a(this.homeX + x1, this.homeY, this.homeZ + z1) == 0) continue;
                        return false;
                    }
                }
                this.genX = this.homeX;
                this.genY = this.homeY;
                this.genZ = this.homeZ;
                this.genDirection = 1;
                return true;
            }
        } else if (world.a(this.homeX, this.homeY, this.homeZ + 1) == bridgeBlockID || world.a(this.homeX, this.homeY, this.homeZ - 1) == bridgeBlockID) {
            if (world.a(this.homeX, this.homeY, this.homeZ + 1) == bridgeBlockID) {
                for (int x1 = -5; x1 < 0; ++x1) {
                    for (int z1 = -4; z1 < -1; ++z1) {
                        if (world.a(this.homeX + x1, this.homeY, this.homeZ + z1) == 0) continue;
                        return false;
                    }
                }
                this.genX = this.homeX;
                this.genY = this.homeY;
                this.genZ = this.homeZ;
                this.genDirection = 3;
                return true;
            }
            if (world.a(this.homeX, this.homeY, this.homeZ - 1) == bridgeBlockID) {
                for (int x1 = -5; x1 < 0; ++x1) {
                    for (int z1 = -1; z1 < 4; ++z1) {
                        if (world.a(this.homeX + x1, this.homeY, this.homeZ + z1) == 0) continue;
                        return false;
                    }
                }
                this.genX = this.homeX;
                this.genY = this.homeY;
                this.genZ = this.homeZ;
                this.genDirection = 4;
                return true;
            }
        }
        return false;
    }

    @Override
    public void spawn(yc world) {
    }

    @Override
    public void generate(yc world) {
        if (this.genDirection == 1) {
            this.genWellOne(world, this.genX, this.genY, this.genZ);
        } else if (this.genDirection == 2) {
            this.genWellTwo(world, this.genX, this.genY, this.genZ);
        } else if (this.genDirection == 3) {
            this.genWellThree(world, this.genX, this.genY, this.genZ);
        } else if (this.genDirection == 4) {
            this.genWellFour(world, this.genX, this.genY, this.genZ);
        }
    }

    private void genWellOne(yc world, int x, int y2, int z2) {
        int a;
        for (int b = 0; b < 3; ++b) {
            this.place(world, x, y2, z2 + b, this.thatchBlock);
        }
        for (a = 0; a < 4; ++a) {
            for (int b = 0; b < 5; ++b) {
                this.place(world, x + a + 1, y2, z2 + b - 1, this.thatchBlock);
                if (a != 0 && a != 3 || b != 0 && b != 4) continue;
                this.placeDownTilGround(world, x + a + 1, y2 - 1, z2 + b - 1, this.bambooFence);
            }
        }
        this.place(world, x - 1, y2 + 1, z2 - 1, this.bambooFence);
        this.place(world, x - 1, y2 + 1, z2 + 3, this.bambooFence);
        this.place(world, x - 1, y2 + 2, z2 - 1, this.tikiTorch, 0);
        this.place(world, x - 1, y2 + 2, z2 + 3, this.tikiTorch, 0);
        for (a = 0; a < 3; ++a) {
            this.place(world, x + 1, y2 + 1 + a, z2 - 1, this.bambooFence);
            this.place(world, x + 1, y2 + 1 + a, z2 + 3, this.bambooFence);
            this.place(world, x + 4, y2 + 1 + a, z2 - 1, this.bambooFence);
            this.place(world, x + 4, y2 + 1 + a, z2 + 3, this.bambooFence);
            if (a != 2) continue;
            this.place(world, x + 1, y2 + 1 + a, z2 - 1, this.thatchSlab, 1);
            this.place(world, x + 1, y2 + 1 + a, z2 + 3, this.thatchSlab, 1);
            this.place(world, x + 4, y2 + 1 + a, z2 - 1, this.thatchSlab, 1);
            this.place(world, x + 4, y2 + 1 + a, z2 + 3, this.thatchSlab, 1);
        }
        int j3 = y2 + 3;
        int k1 = z2 - 1;
        int k2 = z2 + 3;
        this.placeWithMetadata(world, x + 2, j3, k1, this.thatchStair, 2);
        this.placeWithMetadata(world, x + 3, j3, k1, this.thatchStair, 2);
        this.placeWithMetadata(world, x + 2, j3, k2, this.thatchStair, 3);
        this.placeWithMetadata(world, x + 3, j3, k2, this.thatchStair, 3);
        for (int d = 0; d < 3; ++d) {
            this.placeWithMetadata(world, x + 4, j3, z2 + d, this.thatchStair, 1);
            this.place(world, x + 2, j3, z2 + d, this.thatchBlock);
            this.place(world, x + 3, j3, z2 + d, this.thatchBlock);
            this.place(world, x + 1, j3, z2 + d, this.thatchBlock);
        }
        this.placeWithMetadata(world, x + 1, j3, z2, this.thatchStair, 0);
        this.placeWithMetadata(world, x + 1, j3, z2 + 1, this.thatchStair, 0);
        this.placeWithMetadata(world, x + 1, j3, z2 + 2, this.thatchStair, 0);
        this.place(world, x + 2, j3 + 1, z2 + 1, this.thatchSlab, 1);
        this.place(world, x + 4, y2, z2 + 1, 0);
        this.place(world, x + 3, y2, z2 + 1, 0);
        this.place(world, x + 2, y2, z2 + 1, 0);
        this.place(world, x + 1, y2, z2 + 1, 0);
        this.placeWithMetadata(world, x + 1, y2, z2 + 1, amq.aI, 5);
        this.place(world, x, y2 - 1, z2 + 1, this.thatchBlock);
        this.placeWithMetadata(world, x + 1, y2 - 1, z2 + 1, amq.aI, 5);
    }

    private void genWellTwo(yc world, int x, int y2, int z2) {
        int a;
        for (int b = 0; b < 3; ++b) {
            this.place(world, x, y2, z2 + b, this.thatchBlock);
        }
        for (a = 0; a < 4; ++a) {
            for (int b = 0; b < 5; ++b) {
                this.place(world, x - a - 1, y2, z2 + b - 1, this.thatchBlock);
                if (a != 0 && a != 3 || b != 0 && b != 4) continue;
                this.placeDownTilGround(world, x - a - 1, y2 - 1, z2 + b - 1, this.bambooFence);
            }
        }
        this.place(world, x + 1, y2 + 1, z2 - 1, this.bambooFence);
        this.place(world, x + 1, y2 + 1, z2 + 3, this.bambooFence);
        this.place(world, x + 1, y2 + 2, z2 - 1, this.tikiTorch, 0);
        this.place(world, x + 1, y2 + 2, z2 + 3, this.tikiTorch, 0);
        for (a = 0; a < 3; ++a) {
            this.place(world, x - 1, y2 + 1 + a, z2 - 1, this.bambooFence);
            this.place(world, x - 1, y2 + 1 + a, z2 + 3, this.bambooFence);
            this.place(world, x - 4, y2 + 1 + a, z2 - 1, this.bambooFence);
            this.place(world, x - 4, y2 + 1 + a, z2 + 3, this.bambooFence);
            if (a != 2) continue;
            this.place(world, x - 1, y2 + 1 + a, z2 - 1, this.thatchSlab, 1);
            this.place(world, x - 1, y2 + 1 + a, z2 + 3, this.thatchSlab, 1);
            this.place(world, x - 4, y2 + 1 + a, z2 - 1, this.thatchSlab, 1);
            this.place(world, x - 4, y2 + 1 + a, z2 + 3, this.thatchSlab, 1);
        }
        int j3 = y2 + 3;
        int k1 = z2 - 1;
        int k2 = z2 + 3;
        this.placeWithMetadata(world, x - 2, j3, k1, this.thatchStair, 2);
        this.placeWithMetadata(world, x - 3, j3, k1, this.thatchStair, 2);
        this.placeWithMetadata(world, x - 2, j3, k2, this.thatchStair, 3);
        this.placeWithMetadata(world, x - 3, j3, k2, this.thatchStair, 3);
        for (int d = 0; d < 3; ++d) {
            this.placeWithMetadata(world, x - 4, j3, z2 + d, this.thatchStair, 0);
            this.place(world, x - 2, j3, z2 + d, this.thatchBlock);
            this.place(world, x - 3, j3, z2 + d, this.thatchBlock);
            this.place(world, x - 1, j3, z2 + d, this.thatchBlock);
        }
        this.placeWithMetadata(world, x - 1, j3, z2, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 1, j3, z2 + 1, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 1, j3, z2 + 2, this.thatchStair, 1);
        this.place(world, x - 2, j3 + 1, z2 + 1, this.thatchSlab, 1);
        this.place(world, x - 4, y2, z2 + 1, 0);
        this.place(world, x - 3, y2, z2 + 1, 0);
        this.place(world, x - 2, y2, z2 + 1, 0);
        this.place(world, x - 1, y2, z2 + 1, 0);
        this.placeWithMetadata(world, x - 1, y2, z2 + 1, amq.aI, 4);
        this.place(world, x, y2 - 1, z2 + 1, this.thatchBlock);
        this.placeWithMetadata(world, x - 1, y2 - 1, z2 + 1, amq.aI, 4);
    }

    private void genWellThree(yc world, int x, int y2, int z2) {
        int a;
        for (int b = 0; b < 3; ++b) {
            this.place(world, x - b - 2, y2, z2, this.thatchBlock);
        }
        for (a = 0; a < 5; ++a) {
            for (int b = 0; b < 4; ++b) {
                this.place(world, x - a - 1, y2, z2 - b - 1, this.thatchBlock);
                if (a != 0 && a != 4 || b != 0 && b != 3) continue;
                this.placeDownTilGround(world, x - a - 1, y2 - 1, z2 - b - 1, this.bambooFence);
            }
        }
        this.place(world, x - 1, y2 + 1, z2 + 1, this.bambooFence);
        this.place(world, x - 5, y2 + 1, z2 + 1, this.bambooFence);
        this.place(world, x - 1, y2 + 2, z2 + 1, this.tikiTorch, 0);
        this.place(world, x - 5, y2 + 2, z2 + 1, this.tikiTorch, 0);
        for (a = 0; a < 3; ++a) {
            this.place(world, x - 1, y2 + 1 + a, z2 - 1, this.bambooFence);
            this.place(world, x - 5, y2 + 1 + a, z2 - 4, this.bambooFence);
            this.place(world, x - 5, y2 + 1 + a, z2 - 1, this.bambooFence);
            this.place(world, x - 1, y2 + 1 + a, z2 - 4, this.bambooFence);
            if (a != 2) continue;
            this.place(world, x - 1, y2 + 1 + a, z2 - 1, this.thatchSlab, 1);
            this.place(world, x - 5, y2 + 1 + a, z2 - 1, this.thatchSlab, 1);
            this.place(world, x - 1, y2 + 1 + a, z2 - 4, this.thatchSlab, 1);
            this.place(world, x - 5, y2 + 1 + a, z2 - 4, this.thatchSlab, 1);
        }
        int j3 = y2 + 3;
        int k1 = z2 - 2;
        int k2 = z2 - 3;
        this.placeWithMetadata(world, x - 1, j3, k1, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 5, j3, k1, this.thatchStair, 0);
        this.placeWithMetadata(world, x - 1, j3, k2, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 5, j3, k2, this.thatchStair, 0);
        for (int d = 0; d < 3; ++d) {
            this.placeWithMetadata(world, x - 2 - d, j3, z2 - 4, this.thatchStair, 2);
            this.place(world, x - 2, j3, z2 - 3 + d, this.thatchBlock);
            this.place(world, x - 3, j3, z2 - 3 + d, this.thatchBlock);
            this.place(world, x - 4, j3, z2 - 3 + d, this.thatchBlock);
        }
        this.placeWithMetadata(world, x - 2, j3, z2 - 3 + 2, this.thatchStair, 3);
        this.placeWithMetadata(world, x - 3, j3, z2 - 3 + 2, this.thatchStair, 3);
        this.placeWithMetadata(world, x - 4, j3, z2 - 3 + 2, this.thatchStair, 3);
        this.place(world, x - 3, j3 + 1, z2 - 2, this.thatchSlab, 1);
        this.place(world, x - 3, y2, z2 - 4, 0);
        this.place(world, x - 3, y2, z2 - 3, 0);
        this.place(world, x - 3, y2, z2 - 2, 0);
        this.place(world, x - 3, y2, z2 - 1, 0);
        this.placeWithMetadata(world, x - 3, y2, z2 - 1, amq.aI, 2);
        this.place(world, x - 3, y2 - 1, z2, this.thatchBlock);
        this.placeWithMetadata(world, x - 3, y2 - 1, z2 - 1, amq.aI, 2);
    }

    private void genWellFour(yc world, int x, int y2, int z2) {
        int a;
        for (int b = 0; b < 3; ++b) {
            this.place(world, x - b - 2, y2, z2, this.thatchBlock);
        }
        for (a = 0; a < 5; ++a) {
            for (int b = 0; b < 4; ++b) {
                this.place(world, x - a - 1, y2, z2 + b + 1, this.thatchBlock);
                if (a != 0 && a != 4 || b != 0 && b != 3) continue;
                this.placeDownTilGround(world, x - a - 1, y2 - 1, z2 + b + 1, this.bambooFence);
            }
        }
        this.place(world, x - 1, y2 + 1, z2 - 1, this.bambooFence);
        this.place(world, x - 5, y2 + 1, z2 - 1, this.bambooFence);
        this.place(world, x - 1, y2 + 2, z2 - 1, this.tikiTorch, 0);
        this.place(world, x - 5, y2 + 2, z2 - 1, this.tikiTorch, 0);
        for (a = 0; a < 3; ++a) {
            this.place(world, x - 1, y2 + 1 + a, z2 + 1, this.bambooFence);
            this.place(world, x - 5, y2 + 1 + a, z2 + 4, this.bambooFence);
            this.place(world, x - 5, y2 + 1 + a, z2 + 1, this.bambooFence);
            this.place(world, x - 1, y2 + 1 + a, z2 + 4, this.bambooFence);
            if (a != 2) continue;
            this.place(world, x - 1, y2 + 1 + a, z2 + 1, this.thatchSlab, 1);
            this.place(world, x - 5, y2 + 1 + a, z2 + 1, this.thatchSlab, 1);
            this.place(world, x - 1, y2 + 1 + a, z2 + 4, this.thatchSlab, 1);
            this.place(world, x - 5, y2 + 1 + a, z2 + 4, this.thatchSlab, 1);
        }
        int j3 = y2 + 3;
        int k1 = z2 + 2;
        int k2 = z2 + 3;
        this.placeWithMetadata(world, x - 1, j3, k1, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 5, j3, k1, this.thatchStair, 0);
        this.placeWithMetadata(world, x - 1, j3, k2, this.thatchStair, 1);
        this.placeWithMetadata(world, x - 5, j3, k2, this.thatchStair, 0);
        for (int d = 0; d < 3; ++d) {
            this.placeWithMetadata(world, x - 2 - d, j3, z2 + 4, this.thatchStair, 3);
            this.place(world, x - 2, j3, z2 + 3 - d, this.thatchBlock);
            this.place(world, x - 3, j3, z2 + 3 - d, this.thatchBlock);
            this.place(world, x - 4, j3, z2 + 3 - d, this.thatchBlock);
        }
        this.placeWithMetadata(world, x - 2, j3, z2 + 3 - 2, this.thatchStair, 2);
        this.placeWithMetadata(world, x - 3, j3, z2 + 3 - 2, this.thatchStair, 2);
        this.placeWithMetadata(world, x - 4, j3, z2 + 3 - 2, this.thatchStair, 2);
        this.place(world, x - 3, j3 + 1, z2 + 2, this.thatchSlab, 1);
        this.place(world, x - 3, y2, z2 + 4, 0);
        this.place(world, x - 3, y2, z2 + 3, 0);
        this.place(world, x - 3, y2, z2 + 2, 0);
        this.place(world, x - 3, y2, z2 + 1, 0);
        this.placeWithMetadata(world, x - 3, y2, z2 + 1, amq.aI, 3);
        this.place(world, x - 3, y2 - 1, z2, this.thatchBlock);
        this.placeWithMetadata(world, x - 3, y2 - 1, z2 + 1, amq.aI, 3);
    }
}

