/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.tropicraft.mods.TropicraftMod;

public abstract class TCGenBase
extends abm {
    yc worldObj;
    Random rand;
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    List standardAllowedBlocks;

    public TCGenBase(yc world, Random random) {
        this.standardAllowedBlocks = Arrays.asList(0, amq.N.cm, amq.aa.cm, amq.aV.cm);
        this.worldObj = world;
        this.rand = random;
    }

    public boolean isLeafId(int id) {
        return id == amq.N.cm || id == TropicraftMod.tropicLeaves.cm || id == TropicraftMod.fruitTreeLeaves.cm;
    }

    public abstract boolean generate(int var1, int var2, int var3);

    public boolean a(yc world, Random rand, int i, int j, int k) {
        this.worldObj = world;
        this.rand = rand;
        return this.generate(i, j, k);
    }

    public void genCircle(int x, int y2, int z2, double outerRadius, double innerRadius, int id, int meta, boolean solid) {
        for (int i = (int)(-outerRadius - 1.0) + x; i <= (int)(outerRadius + 1.0) + x; ++i) {
            for (int k = (int)(-outerRadius - 1.0) + z2; k <= (int)(outerRadius + 1.0) + z2; ++k) {
                double d = Math.sqrt(Math.pow(i - x, 2.0) + Math.pow(k - z2, 2.0));
                if (!(d <= outerRadius) || !(d >= innerRadius) || !this.worldObj.c(i, y2, k) && !solid) continue;
                this.worldObj.c(i, y2, k, id, meta);
            }
        }
    }

    public boolean checkCircle(int i, int j, int k, double outerRadius, double innerRadius, List allowedBlockList) {
        for (int x = (int)(-outerRadius - 2.0) + i; x < (int)(outerRadius + 2.0) + i; ++x) {
            for (int z2 = (int)(-outerRadius - 2.0) + k; z2 < (int)(outerRadius + 2.0) + k; ++z2) {
                double d = Math.sqrt(Math.pow(x - i, 2.0) + Math.pow(z2 - k, 2.0));
                if (!(d <= outerRadius) || !(d >= innerRadius)) continue;
                int bId = this.worldObj.a(x, j, z2);
                if (!allowedBlockList.contains(bId)) {
                    // empty if block
                }
                return false;
            }
        }
        return true;
    }

    public boolean checkBlockLine(int[] ai, int[] ai1, List allowedBlockList) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return false;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            int bId = this.worldObj.a(ai3[0], ai3[1], ai3[2]);
            List<Integer> standardAllowedBlocks = Arrays.asList(0, amq.N.cm, amq.aa.cm, amq.aV.cm);
            if (allowedBlockList.contains(bId)) continue;
            return false;
        }
        return true;
    }

    public ArrayList placeBlockLine(int[] ai, int[] ai1, int i, int meta) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.worldObj.c(ai3[0], ai3[1], ai3[2], i, meta);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    public boolean checkBlockCircleLine(int[] ai, int[] ai1, double outerRadius, double innerRadius, List allowedBlockList) {
        ArrayList places = new ArrayList();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return false;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            if (this.checkCircle(ai3[0], ai3[1], ai3[2], outerRadius, innerRadius, allowedBlockList)) continue;
            return false;
        }
        return true;
    }

    public ArrayList checkAndPlaceBlockCircleLine(int[] ai, int[] ai1, double outerRadius, double innerRadius, int i, int meta, List allowedBlockList) {
        int k;
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (k = 0; k != l; k += byte3) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            if (this.checkCircle(ai3[0], ai3[1], ai3[2], outerRadius, innerRadius, allowedBlockList)) continue;
            return null;
        }
        l = ai2[j] + byte3;
        while (k != l) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.genCircle(ai3[0], ai3[1], ai3[2], outerRadius, innerRadius, i, meta, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
            k += byte3;
        }
        return places;
    }

    public ArrayList checkAndPlaceBlockLine(int[] ai, int[] ai1, int i, int meta, List allowedBlockList) {
        int k;
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (k = 0; k != l; k += byte3) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            int bId = this.worldObj.a(ai3[0], ai3[1], ai3[2]);
            if (allowedBlockList.contains(bId)) continue;
            return null;
        }
        l = ai2[j] + byte3;
        while (k != l) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.worldObj.c(ai3[0], ai3[1], ai3[2], i, meta);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
            k += byte3;
        }
        return places;
    }

    public ArrayList placeBlockCircleLine(int[] ai, int[] ai1, double distance, double distance2, int i, int meta) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.genCircle(ai3[0], ai3[1], ai3[2], distance, distance2, i, meta, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    public void genSphere(int x, int y2, int z2, int outerRadius, int id, int meta) {
        for (int i = x - outerRadius; i < x + outerRadius; ++i) {
            for (int j = y2 - outerRadius; j < y2 + outerRadius; ++j) {
                for (int k = z2 - outerRadius; k < z2 + outerRadius; ++k) {
                    int distance1;
                    if (!this.worldObj.c(i, j, k) || (distance1 = (int)Math.round(Math.sqrt(Math.pow(i - x, 2.0) + Math.pow(j - y2, 2.0) + Math.pow(k - z2, 2.0)))) > outerRadius) continue;
                    this.worldObj.c(i, j, k, id, meta);
                }
            }
        }
    }

    public int getTerrainHeightAt(int x, int z2) {
        for (int y2 = 256; y2 > 0; --y2) {
            int id = this.worldObj.a(x, y2, z2);
            if (id != amq.y.cm && id != amq.x.cm && id != amq.H.cm && id != amq.w.cm) continue;
            return y2 + 1;
        }
        return 0;
    }

    public double randAngle() {
        return this.rand.nextDouble() * Math.PI * 2.0;
    }
}

