/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.biomes.BiomeGenTropicraft;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenHomeTree
extends TCGenBase {
    private final int woodID;
    private final int woodMeta = 1;
    private final int leafID;
    private final int leafMeta = 6;
    private ArrayList branchList;
    private int trunkCirc;

    public WorldGenHomeTree(yc world, Random random) {
        super(world, random);
        this.woodID = TropicraftMod.tropicalWood.cm;
        this.woodMeta = 1;
        this.leafID = TropicraftMod.tropicLeaves.cm;
        this.leafMeta = 6;
        this.branchList = new ArrayList();
    }

    @Override
    public boolean generate(int i, int j, int k) {
        j = this.getTerrainHeightAt(i, k);
        if (!BiomeGenTropicraft.rainforestBiomes.contains(this.worldObj.t().a(i, k))) {
            return false;
        }
        int height = this.rand.nextInt(20) + 30;
        if (height + j + 12 > 127) {
            return false;
        }
        this.trunkCirc = this.rand.nextInt(3) + 7;
        if (this.worldObj.a(i, j - 1, k) != amq.x.cm || this.worldObj.c(i, j, k)) {
            // empty if block
        }
        int[] top = this.generateTrunk(i, j, k, this.trunkCirc, height);
        this.generateBranches(top[0], top[1], height + j);
        return false;
    }

    public int[] generateTrunk(int i, int j, int k, int circ, int height) {
        int bn = 0;
        int chanceToDisplace = 0;
        int lr = this.rand.nextBoolean() ? 1 : -1;
        int fb = this.rand.nextBoolean() ? 1 : -1;
        int tx = i;
        int tz = k;
        for (int y2 = j - 10; y2 < height + j; ++y2) {
            ++chanceToDisplace;
            this.genCircle(tx, y2, tz, circ, circ - 3, this.woodID, 1, false);
            if (y2 == height + j - 1 || (y2 - j) % 6 == 0) {
                this.genCircle(tx, y2, tz, circ, 2.0, this.woodID, 1, false);
                this.placeBlock(tx + 1, y2, tz + 1, this.woodID, 1, false);
                this.placeBlock(tx + 1, y2, tz - 1, this.woodID, 1, false);
                this.placeBlock(tx - 1, y2, tz + 1, this.woodID, 1, false);
                this.placeBlock(tx - 1, y2, tz - 1, this.woodID, 1, false);
                double angle = this.rand.nextDouble() * 3.141592 * 2.0;
                if (this.rand.nextInt(3) == 0) {
                    double length = this.rand.nextDouble() * (double)circ - 4.0;
                    int ax = (int)Math.round(length * Math.sin(angle) + (double)tx);
                    int az = (int)Math.round(length * Math.cos(angle) + (double)tz);
                    this.worldObj.b(ax, y2 + 1, az, amq.av.cm);
                    String s2 = this.rand.nextBoolean() ? "AshenHunter" : "Iguana";
                    ans spawner = (ans)this.worldObj.q(ax, y2 + 1, az);
                    if (spawner != null) {
                        spawner.a(s2);
                    }
                }
            }
            this.placeBlock(tx, y2, tz, this.woodID, 1, false);
            this.placeVine(tx + 1, y2, tz);
            this.placeVine(tx - 1, y2, tz);
            this.placeVine(tx, y2, tz + 1);
            this.placeVine(tx, y2, tz - 1);
            if (this.rand.nextInt(6) == 0) {
                // empty if block
            }
            if (y2 >= j + height - 6) {
                int branches = this.rand.nextInt(4) + 2;
                for (int b = 0; b < branches; ++b) {
                    int bl = this.rand.nextInt(10) + 15;
                    int ax = tx;
                    int az = tz;
                    double angle = this.rand.nextDouble() * 3.141592 * 2.0;
                    int tax = (int)Math.round((double)circ * Math.sin(angle) + (double)ax);
                    int taz = (int)Math.round((double)circ * Math.cos(angle) + (double)az);
                    ax = (int)Math.round((double)bl * Math.sin(angle) + (double)ax);
                    az = (int)Math.round((double)bl * Math.cos(angle) + (double)az);
                    int ay = this.rand.nextInt(4) + 4;
                    this.branchList.add(new BranchNode(tax, y2, taz, ax, y2 + ay, az));
                    ++bn;
                }
            }
            if (this.rand.nextInt(6) + 4 <= chanceToDisplace && chanceToDisplace * 9 > y2) {
                if (this.rand.nextBoolean()) {
                    tx += lr;
                    if (this.rand.nextBoolean()) {
                        tz += fb;
                    }
                } else if (this.rand.nextBoolean()) {
                    tz += fb;
                    if (this.rand.nextBoolean()) {
                        tz += lr;
                    }
                }
                chanceToDisplace = 0;
            }
            this.placeBlock(tx, y2, tz, amq.M.cm, 0, false);
        }
        this.worldObj.b(tx - 1, height + j, tz - 1, TropicraftMod.bambooChest.cm);
        anm chest = (anm)this.worldObj.q(tx - 1, height + j, tz - 1);
        if (chest != null) {
            int treasure = this.rand.nextInt(6) + 4;
            for (int lv2 = 0; lv2 < treasure; ++lv2) {
                chest.a(this.rand.nextInt(chest.k_()), this.randLoot());
            }
        }
        return new int[]{tx, tz};
    }

    public void generateBranches(int topX, int topZ, int height) {
        for (int x = 0; x < this.branchList.size(); ++x) {
            BranchNode bnode = (BranchNode)this.branchList.get(x);
            int lSize = 3;
            if (!this.checkBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1}, new int[]{bnode.x2, bnode.y2, bnode.z2}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1 + 1, bnode.y1, bnode.z1}, new int[]{bnode.x2 + 1, bnode.y2, bnode.z2}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1 - 1, bnode.y1, bnode.z1}, new int[]{bnode.x2 - 1, bnode.y2, bnode.z2}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1 + 1}, new int[]{bnode.x2, bnode.y2, bnode.z2 + 1}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1 - 1}, new int[]{bnode.x2, bnode.y2, bnode.z2 - 1}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1, bnode.y1 - 1, bnode.z1}, new int[]{bnode.x2, bnode.y2 - 1, bnode.z2}, this.standardAllowedBlocks)) continue;
            this.placeBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1}, new int[]{bnode.x2, bnode.y2, bnode.z2}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1 + 1, bnode.y1, bnode.z1}, new int[]{bnode.x2 + 1, bnode.y2, bnode.z2}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1 - 1, bnode.y1, bnode.z1}, new int[]{bnode.x2 - 1, bnode.y2, bnode.z2}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1 + 1}, new int[]{bnode.x2, bnode.y2, bnode.z2 + 1}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1 - 1}, new int[]{bnode.x2, bnode.y2, bnode.z2 - 1}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1, bnode.y1 - 1, bnode.z1}, new int[]{bnode.x2, bnode.y2 - 1, bnode.z2}, this.woodID, 1);
            if (bnode.y2 + 1 <= height) {
                this.placeBlockLine(new int[]{bnode.x1, bnode.y1 + 1, bnode.z1}, new int[]{bnode.x2, bnode.y2 + 1, bnode.z2}, TropicraftMod.tropicalWood.cm, 1);
            }
            this.genLeafCircle(bnode.x2, bnode.y2 - 1, bnode.z2, lSize + 5, lSize + 3, this.leafID, 6, true);
            this.genLeafCircle(bnode.x2, bnode.y2, bnode.z2, lSize + 6, 0, this.leafID, 6, true);
            this.genLeafCircle(bnode.x2, bnode.y2 + 1, bnode.z2, lSize + 10, 0, this.leafID, 6, true);
            this.genLeafCircle(bnode.x2, bnode.y2 + 2, bnode.z2, lSize + 9, 0, this.leafID, 6, true);
        }
        int topBranches = this.rand.nextInt(6) + 6;
        for (int lVar = 0; lVar < topBranches; ++lVar) {
            int bl = this.rand.nextInt(10) + 15;
            int ax = topX;
            int az = topZ;
            double angle = this.rand.nextDouble() * 3.141592 * 2.0;
            ax = (int)Math.round((double)bl * Math.sin(angle) + (double)ax);
            az = (int)Math.round((double)bl * Math.cos(angle) + (double)az);
            int branchHeight = height + this.rand.nextInt(4);
            int lSize = this.rand.nextInt(5) - 3;
            this.genTopBranch(ax, height, az, ax, height + this.rand.nextInt(4) + 4, az, topX, topZ);
            this.genLeafCircle(ax, branchHeight - 1, az, lSize + 5, lSize + 3, this.leafID, 6, true);
            this.genLeafCircle(ax, branchHeight, az, lSize + 6, 0, this.leafID, 6, true);
            this.genLeafCircle(ax, branchHeight + 1, az, lSize + 10, 0, this.leafID, 6, true);
            this.genLeafCircle(ax, branchHeight + 2, az, lSize + 9, 0, this.leafID, 6, true);
        }
    }

    public boolean canGenerate(int i, int j, int k, int height, int trunkCirc) {
        for (int x = i - trunkCirc + 5; x <= i + trunkCirc + 5; ++x) {
            for (int z2 = k - trunkCirc + 5; z2 <= k + trunkCirc + 5; ++z2) {
                for (int y2 = this.getTerrainHeightAt(x, z2); y2 < j + height; ++y2) {
                    int bId = this.worldObj.a(x, y2, z2);
                    if (this.standardAllowedBlocks.contains(bId)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean genTopBranch(int i, int j, int k, int sX, int sY, int sZ, int topX, int topZ) {
        int z2;
        int x;
        int branchSize = this.rand.nextInt(2) + 4;
        ArrayList lines = new ArrayList();
        for (x = i - branchSize; x < i + branchSize; ++x) {
            for (z2 = k - branchSize; z2 < k + branchSize; ++z2) {
                if (!(Math.sqrt(Math.pow(x - i, 2.0) + Math.pow(z2 - k, 2.0)) < (double)branchSize) || !(Math.sqrt(Math.pow(x - topX, 2.0) + Math.pow(z2 - topZ, 2.0)) < (double)this.trunkCirc) || this.checkBlockLine(new int[]{x, j, z2}, new int[]{sX + (i - x), sY, sZ + (k - z2)}, this.standardAllowedBlocks)) continue;
                return false;
            }
        }
        for (x = i - branchSize; x < i + branchSize; ++x) {
            for (z2 = k - branchSize; z2 < k + branchSize; ++z2) {
                if (!(Math.sqrt(Math.pow(x - i, 2.0) + Math.pow(z2 - k, 2.0)) < (double)branchSize) || !(Math.sqrt(Math.pow(x - topX, 2.0) + Math.pow(z2 - topZ, 2.0)) < (double)this.trunkCirc)) continue;
                this.placeBlockLine(new int[]{x, j, z2}, new int[]{sX + (i - x), sY, sZ + (k - z2)}, this.woodID, 1);
            }
        }
        return true;
    }

    public void genLeafCircle(int x, int y2, int z2, int outerRadius, int innerRadius, int id, int meta, boolean vines) {
        for (int i = -outerRadius - 2 + x; i < outerRadius + 2 + x; ++i) {
            for (int k = -outerRadius - 2 + z2; k < outerRadius + 2 + z2; ++k) {
                double d = Math.sqrt(Math.pow(i - x, 2.0) + Math.pow(k - z2, 2.0));
                if (!(d <= (double)outerRadius) || !(d >= (double)innerRadius)) continue;
                if (this.worldObj.a(i, y2, k) == 0 || this.worldObj.a(i, y2, k) == id) {
                    this.placeBlock(i, y2, k, id, meta, false);
                }
                if (this.rand.nextInt(20) != 0 || !vines) continue;
                this.genVines(i, y2 - 1, k);
            }
        }
    }

    public void genVines(int i, int j, int k) {
        int length = this.rand.nextInt(15) + 8;
        int dir = this.rand.nextInt(4);
        for (int y2 = j; y2 > j - length && this.worldObj.c(i, y2, k); --y2) {
            this.placeBlock(i, y2, k, amq.bx.cm, dir, false);
        }
    }

    public void placeBlock(int i, int j, int k, int id, int meta, boolean force) {
        if (!(this.worldObj.a(i, j, k) == id && this.worldObj.h(i, j, k) == meta || !force && this.worldObj.a(i, j, k) != 0)) {
            if (meta == 0) {
                this.worldObj.b(i, j, k, id);
                return;
            }
            this.worldObj.c(i, j, k, id, meta);
        }
    }

    @Override
    public void genCircle(int i, int j, int k, double distance, double distance2, int id, int meta, boolean solid) {
        for (int x = (int)(-distance - 2.0) + i; x < (int)(distance + 2.0) + i; ++x) {
            for (int z2 = (int)(-distance - 2.0) + k; z2 < (int)(distance + 2.0) + k; ++z2) {
                int cid;
                double d = Math.sqrt(Math.pow(x - i, 2.0) + Math.pow(z2 - k, 2.0));
                if (!(d <= distance) || !(d >= distance2) || (cid = this.worldObj.a(x, j, z2)) != 0 && cid != amq.E.cm && cid != amq.D.cm && !solid) continue;
                this.placeBlock(x, j, z2, id, meta, solid);
            }
        }
    }

    @Override
    public ArrayList placeBlockLine(int[] ai, int[] ai1, int i, int meta) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.placeBlock(ai3[0], ai3[1], ai3[2], i, meta, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    @Override
    public ArrayList checkAndPlaceBlockLine(int[] ai, int[] ai1, int i, int meta, List a) {
        int k;
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (k = 0; k != l; k += byte3) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            int bId = this.worldObj.a(ai3[0], ai3[1], ai3[2]);
            if (a.contains(bId)) continue;
            return null;
        }
        l = ai2[j] + byte3;
        while (k != l) {
            ai3[j] = ke.c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = ke.c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = ke.c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.placeBlock(ai3[0], ai3[1], ai3[2], i, meta, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
            k += byte3;
        }
        return places;
    }

    public void placeVine(int i, int j, int k) {
        int m = 2;
        while (true) {
            if (m > 5) {
                return;
            }
            if (amq.bx.b_(this.worldObj, i, j, k, m) && this.worldObj.a(i, j, k) == 0) break;
            ++m;
        }
        this.worldObj.c(i, j, k, amq.bx.cm, 1 << q.e[r.a[m]]);
    }

    public ur randLoot() {
        int picker = this.rand.nextInt(18);
        if (picker < 6) {
            return new ur(TropicraftMod.bambooItem, this.rand.nextInt(20) + 1);
        }
        if (picker < 8) {
            return new ur(TropicraftMod.coconutBomb, this.rand.nextInt(3) + 1);
        }
        if (picker < 10) {
            return new ur(TropicraftMod.azuriteItem, this.rand.nextInt(3) + 1);
        }
        if (picker < 12) {
            return new ur(TropicraftMod.thatchBlock, this.rand.nextInt(20) + 1);
        }
        if (picker < 14) {
            return new ur(TropicraftMod.cookedFrogLeg, this.rand.nextInt(4) + 1);
        }
        if (picker == 14) {
            return new ur(TropicraftMod.ashenMask, 1, this.rand.nextInt(7));
        }
        if (picker == 15) {
            return new ur(TropicraftMod.froxTradeWinds, 1);
        }
        if (picker == 16) {
            return new ur(TropicraftMod.froxEasternIsles, 1);
        }
        return new ur(up.n, 1);
    }

    private class BranchNode {
        public int x1;
        public int y1;
        public int z1;
        public int x2;
        public int y2;
        public int z2;

        public BranchNode(int i, int j, int k, int x, int y2, int z2) {
            this.x1 = i;
            this.y1 = j;
            this.z1 = k;
            this.x2 = x;
            this.y2 = y2;
            this.z2 = z2;
        }
    }
}

