/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.biomes.BiomeGenTropicraft;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenTallRTree
extends TCGenBase {
    private boolean gen;
    private int woodBlockId;
    private int leafBlockId;

    public WorldGenTallRTree(yc world, Random random, boolean g) {
        super(world, random);
        this.woodBlockId = TropicraftMod.tropicalWood.cm;
        this.leafBlockId = TropicraftMod.tropicLeaves.cm;
        this.gen = g;
    }

    @Override
    public boolean a(yc world, Random random, int i, int j, int k) {
        return this.generate(i, j, k);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int y2;
        int bid;
        if (!BiomeGenTropicraft.rainforestBiomes.contains(this.worldObj.a(i, k))) {
            return false;
        }
        if (this.gen) {
            j = this.getTerrainHeightAt(i, k);
        }
        if ((bid = this.worldObj.a(i, j - 1, k)) != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        bid = this.worldObj.a(i + 1, j - 1, k);
        if (bid != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        bid = this.worldObj.a(i - 1, j - 1, k);
        if (bid != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        bid = this.worldObj.a(i, j - 1, k + 1);
        if (bid != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        bid = this.worldObj.a(i, j - 1, k - 1);
        if (bid != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        int height = this.rand.nextInt(15) + 15;
        for (y2 = j; y2 < j + height + 6; ++y2) {
            for (int x = i - 1; x <= i + 1; ++x) {
                for (int z2 = k - 1; z2 <= k + 1; ++z2) {
                    int id = this.worldObj.a(x, y2, z2);
                    if (id == 0 || id == amq.aa.cm || id == this.leafBlockId) continue;
                    return false;
                }
            }
        }
        for (y2 = j; y2 < j + height; ++y2) {
            int oz2;
            int ox2;
            this.worldObj.c(i, y2, k, this.woodBlockId, 1);
            this.worldObj.c(i - 1, y2, k, this.woodBlockId, 1);
            this.worldObj.c(i + 1, y2, k, this.woodBlockId, 1);
            this.worldObj.c(i, y2, k - 1, this.woodBlockId, 1);
            this.worldObj.c(i, y2, k + 1, this.woodBlockId, 1);
            if (y2 - j > height / 2 && this.rand.nextInt(3) == 0) {
                ox2 = this.rand.nextInt(3) - 1 + i;
                oz2 = this.rand.nextInt(3) - 1 + k;
                this.genCircle(ox2, y2 + 1, oz2, 1.0, 0.0, this.leafBlockId, 3, false);
                this.genCircle(ox2, y2, oz2, 2.0, 1.0, this.leafBlockId, 3, false);
                this.checkAndPlaceBlockLine(new int[]{i, y2, k}, new int[]{ox2, y2, oz2}, this.woodBlockId, 1, Arrays.asList(0, this.leafBlockId, amq.bx.cm));
                for (int x = i - 3; x <= i + 3; ++x) {
                    for (int z3 = k - 3; z3 <= k + 3; ++z3) {
                        for (int y1 = y2 - 1; y1 <= y2 + 1; ++y1) {
                            if (this.rand.nextInt(5) != 0) continue;
                            this.genVines(x, y1, z3);
                        }
                    }
                }
            }
            if (y2 - j <= height - height / 4 || y2 - j >= height - 3 || this.rand.nextInt(3) != 0) continue;
            ox2 = i + this.rand.nextInt(9) - 4;
            oz2 = k + this.rand.nextInt(9) - 4;
            int leafSize = this.rand.nextInt(3) + 5;
            this.genCircle(ox2, y2 + 3, oz2, leafSize - 2, 0.0, this.leafBlockId, 3, false);
            this.genCircle(ox2, y2 + 2, oz2, leafSize - 1, leafSize - 3, this.leafBlockId, 3, false);
            this.genCircle(ox2, y2 + 1, oz2, leafSize, leafSize - 1, this.leafBlockId, 3, false);
            int bn = this.rand.nextInt(4) + 4;
            for (int b = 0; b < bn; ++b) {
                double randAngle = this.randAngle();
                int branchLength = this.rand.nextInt(leafSize - 4) + 3;
                int ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)ox2);
                int az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)oz2);
                this.checkAndPlaceBlockLine(new int[]{i, y2, k}, new int[]{ax, y2, az}, this.woodBlockId, 1, Arrays.asList(0, this.leafBlockId, amq.bx.cm));
            }
            for (int x = i - leafSize; x <= i + leafSize; ++x) {
                for (int z4 = k - leafSize; z4 <= k + leafSize; ++z4) {
                    for (int y1 = y2; y1 <= y2 + 3; ++y1) {
                        if (this.rand.nextInt(4) != 0) continue;
                        this.genVines(x, y1, z4);
                    }
                }
            }
        }
        int leafSize = this.rand.nextInt(5) + 9;
        this.genCircle(i, j + height, k, leafSize - 2, 0.0, this.leafBlockId, 3, false);
        this.genCircle(i, j + height - 1, k, leafSize - 1, leafSize - 4, this.leafBlockId, 3, false);
        this.genCircle(i, j + height - 2, k, leafSize, leafSize - 1, this.leafBlockId, 3, false);
        int bn = this.rand.nextInt(4) + 6;
        for (int b = 0; b < bn; ++b) {
            double randAngle = this.randAngle();
            int branchLength = this.rand.nextInt(leafSize - 6) + 3;
            int ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)i);
            int az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)k);
            this.checkAndPlaceBlockLine(new int[]{i, j + height - 1, k}, new int[]{ax, j + height + 5, az}, this.woodBlockId, 1, Arrays.asList(0, amq.N.cm, amq.bx.cm));
        }
        for (int x = i - leafSize; x <= i + leafSize; ++x) {
            for (int z5 = k - leafSize; z5 <= k + leafSize; ++z5) {
                for (int y1 = j + height + 3; y1 <= j + height + 6; ++y1) {
                    if (this.rand.nextInt(4) != 0) continue;
                    this.genVines(x, y1, z5);
                }
            }
        }
        return true;
    }

    private boolean genVines(int i, int j, int k) {
        int dir = this.rand.nextInt(4);
        int m = 2;
        while (true) {
            if (m > 5) {
                return false;
            }
            if (amq.bx.b_(this.worldObj, i, j, k, m) && this.worldObj.a(i, j, k) == 0) break;
            ++m;
        }
        this.worldObj.c(i, j, k, amq.bx.cm, 1 << q.e[r.a[m]]);
        int length = this.rand.nextInt(4) + 4;
        for (int y2 = j - 1; y2 > j - length; --y2) {
            if (this.worldObj.a(i, y2, k) != 0) {
                return true;
            }
            this.worldObj.c(i, y2, k, amq.bx.cm, 1 << q.e[r.a[m]]);
        }
        return true;
    }
}

