/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.biomes.BiomeGenTropicraft;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenTualang
extends TCGenBase {
    private int woodBlockId;
    private int leafBlockID;
    private int leafMeta;
    private int maxHeight;
    private int baseHeight;

    public WorldGenTualang(yc world, Random random, int mH, int bH) {
        super(world, random);
        this.woodBlockId = TropicraftMod.tropicalWood.cm;
        this.leafBlockID = TropicraftMod.tropicLeaves.cm;
        this.leafMeta = 3;
        this.maxHeight = mH;
        this.baseHeight = bH;
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int bId;
        int y2;
        int z2;
        int x;
        if (!BiomeGenTropicraft.rainforestBiomes.contains(this.worldObj.a(i, k))) {
            return false;
        }
        int height = this.rand.nextInt(this.maxHeight - this.baseHeight) + this.baseHeight + j;
        int branches = this.rand.nextInt(6) + 4;
        if (height + 6 > 127) {
            return false;
        }
        if (this.worldObj.a(i, j - 1, k) != amq.y.cm && this.worldObj.a(i, j - 1, k) != amq.x.cm) {
            return false;
        }
        for (x = i - 1; x <= i + 1; ++x) {
            for (z2 = k - 1; z2 <= k + 1; ++z2) {
                for (y2 = j; y2 < j + height; ++y2) {
                    bId = this.worldObj.a(x, y2, z2);
                    if (bId == 0 || this.isLeafId(bId) || bId == amq.aa.cm || bId == amq.aV.cm) continue;
                    return false;
                }
            }
        }
        for (x = i - 9; x >= i + 9; ++x) {
            for (z2 = k - 9; z2 >= k + 9; ++z2) {
                for (y2 = height; y2 < height + 6; ++y2) {
                    bId = this.worldObj.a(x, y2, z2);
                    if (bId == 0 || this.isLeafId(bId) || bId == amq.aa.cm || bId == amq.aV.cm) continue;
                    return false;
                }
            }
        }
        this.genCircle(i, j - 1, k, 1.0, 0.0, amq.y.cm, 0, true);
        this.placeBlockCircleLine(new int[]{i, j, k}, new int[]{i, height, k}, 1.0, 0.0, this.woodBlockId, 1);
        for (int lVar = 0; lVar < branches; ++lVar) {
            double randAngle = this.randAngle();
            int branchHeight = this.rand.nextInt(4) + 2 + height;
            int branchLength = this.rand.nextInt(5) + 4;
            int ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)i);
            int az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)k);
            int tax = (int)Math.round(Math.sin(randAngle) + (double)i);
            int taz = (int)Math.round(Math.cos(randAngle) + (double)k);
            this.placeBlockLine(new int[]{tax, height, taz}, new int[]{ax, branchHeight, az}, this.woodBlockId, 1);
            this.genCircle(ax, branchHeight, az, 2.0, 1.0, this.leafBlockID, this.leafMeta, false);
            this.genCircle(ax, branchHeight + 1, az, 3.0, 2.0, this.leafBlockID, this.leafMeta, false);
        }
        return true;
    }
}

