/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft;

import java.util.Random;
import net.tropicraft.blocks.BlockTempLavaFlowing;
import net.tropicraft.entities.EntityLavaBall;
import net.tropicraft.entities.EntitySmoke;
import net.tropicraft.mods.TropicraftMod;

public class VolcanoEvent {
    public static boolean erupting = false;
    public int xPos;
    public int zPos;
    public int lavaLevel;
    public int radius;
    public boolean falling;
    public Random rand;
    public yc worldObj;
    public int time;
    public boolean erupted;
    private boolean hasInitialized;

    public VolcanoEvent(yc w2, int i, int k) {
        this.xPos = i;
        this.zPos = k;
        this.radius = 0;
        this.lavaLevel = 79;
        this.worldObj = w2;
        erupting = true;
        this.falling = false;
        this.erupted = false;
        BlockTempLavaFlowing.decay = false;
        this.rand = new Random();
        this.hasInitialized = false;
        if (this.worldObj != null) {
            this.findRadius();
            this.getLavaLevel();
            this.hasInitialized = true;
        }
    }

    public VolcanoEvent(int i, int k) {
        this.xPos = i;
        this.zPos = k;
        this.radius = 0;
        this.lavaLevel = 79;
        erupting = true;
        this.falling = false;
        this.erupted = false;
        BlockTempLavaFlowing.decay = false;
        this.rand = new Random();
        this.hasInitialized = false;
    }

    public void setWorld(yc w2) {
        this.worldObj = w2;
        if (this.worldObj != null) {
            this.findRadius();
            this.getLavaLevel();
            this.hasInitialized = true;
        }
    }

    public boolean update() {
        if (!TropicraftMod.shouldVolcanoesErupt) {
            return false;
        }
        if (this.worldObj != null && !this.hasInitialized) {
            this.findRadius();
            this.getLavaLevel();
            this.hasInitialized = true;
        } else if (this.worldObj == null) {
            return true;
        }
        ++this.time;
        if (this.time % 100 == 0 && !this.falling && !this.worldObj.I) {
            this.spewSmoke();
        }
        if (this.time > 1200 && this.time % 300 == 0) {
            this.raiseFallLava();
        }
        if (!this.worldObj.I) {
            if (this.time % (this.rand.nextInt(40) + 10) == 0 && this.time > 800 && !this.falling) {
                this.throwLavaFromCaldera(this.rand.nextDouble() * 0.5 + (this.lavaLevel > 90 ? 1.25 : 0.75));
            }
            if (this.time % (this.rand.nextInt(40) + 10) == 0 && !this.falling && this.lavaLevel > 90) {
                this.throwLavaFromCaldera(this.rand.nextDouble() * 0.5 + (this.lavaLevel > 90 ? 1.25 : 0.75));
            }
        }
        if (this.lavaLevel < 84 && this.falling) {
            BlockTempLavaFlowing.decay = true;
        }
        if (this.lavaLevel == 79 && this.falling && this.time % 150 == 0) {
            this.cleanUpFromEruption();
            erupting = false;
            return false;
        }
        return true;
    }

    public void cleanUpFromEruption() {
        for (int x = this.xPos - this.radius * 2; x < this.xPos + this.radius * 2; ++x) {
            for (int z2 = this.zPos - this.radius * 2; z2 < this.zPos + this.radius * 2; ++z2) {
                for (int y2 = 64; y2 < 120; ++y2) {
                    if (this.worldObj.a(x, y2, z2) != TropicraftMod.tempLavaMoving.cm) continue;
                    this.worldObj.b(x, y2, z2, 0);
                }
            }
        }
    }

    public void getLavaLevel() {
        for (int y2 = 75; y2 < 128; ++y2) {
            if (this.worldObj.a(this.xPos, y2, this.zPos) == amq.G.cm || this.worldObj.a(this.xPos, y2, this.zPos) == TropicraftMod.tempLavaMoving.cm) continue;
            this.lavaLevel = y2 - 1;
            break;
        }
    }

    public void findRadius() {
        if (this.radius == 0) {
            for (int x = 0; x < 30; ++x) {
                if (this.worldObj.a(x + this.xPos, 10, this.zPos) == amq.G.cm) continue;
                this.radius = x;
            }
        }
    }

    public void raiseFallLava() {
        int x;
        if (this.lavaLevel >= 95) {
            this.falling = true;
        }
        if (!this.falling) {
            ++this.lavaLevel;
        }
        for (x = this.xPos - this.radius; x < this.xPos + this.radius; ++x) {
            for (int z2 = this.zPos - this.radius; z2 < this.zPos + this.radius; ++z2) {
                if (!(Math.sqrt(Math.pow(x - this.xPos, 2.0) + Math.pow(z2 - this.zPos, 2.0)) < (double)(this.radius + 3)) || this.worldObj.a(x, 0, z2) != amq.G.cm) continue;
                this.worldObj.e(x, this.lavaLevel, z2, this.falling ? 0 : (this.lavaLevel >= 95 ? TropicraftMod.tempLavaMoving.cm : amq.G.cm));
            }
        }
        if (this.lavaLevel == 90) {
            if (!this.falling) {
                this.worldObj.a((double)this.xPos, 73.0, (double)this.zPos, "random.explode", 1.0f, this.rand.nextFloat() / 4.0f + 0.825f);
                int balls = this.rand.nextInt(25) + 35;
                for (int i = 0; i < balls; ++i) {
                    this.throwLavaFromCaldera(this.rand.nextDouble() * 0.5 + 1.25);
                }
                this.erupted = true;
            } else {
                for (x = this.xPos - this.radius; x < this.xPos + this.radius; ++x) {
                    boolean ready = false;
                    for (int z3 = this.zPos - this.radius; z3 < this.zPos + this.radius; ++z3) {
                        if (this.worldObj.a(x, 0, z3) != amq.G.cm || this.rand.nextInt(20) == 0) continue;
                        this.worldObj.e(x, this.lavaLevel, z3, TropicraftMod.chunkBlock.cm);
                    }
                }
            }
        }
        if (this.falling) {
            --this.lavaLevel;
        }
    }

    public void spewSmoke() {
        System.out.println("Spewing smoke");
        int n = this.rand.nextInt(6) + 4;
        for (int i = 0; i < n; ++i) {
            this.worldObj.d((lq)new EntitySmoke(this.worldObj, this.xPos + this.rand.nextInt(10) - 5, this.lavaLevel + this.rand.nextInt(4), this.zPos + this.rand.nextInt(10) - 5));
        }
    }

    public void throwLavaFromCaldera(double force) {
        double x = this.rand.nextInt(this.radius) - this.radius / 2 + this.xPos;
        double z2 = this.rand.nextInt(this.radius) - this.radius / 2 + this.zPos;
        double motX = (this.rand.nextDouble() / 2.0 + 0.5) * (double)(this.rand.nextBoolean() ? -1 : 1) * force;
        double motZ = (this.rand.nextDouble() / 2.0 + 0.5) * (double)(this.rand.nextBoolean() ? -1 : 1) * force;
        this.throwLava(x, this.lavaLevel + 2, z2, motX, 1.0, motZ);
    }

    public void throwLava(double i, double j, double k, double xMot, double yMot, double zMot) {
        this.worldObj.d((lq)new EntityLavaBall(this.worldObj, i, j, k, xMot, yMot, zMot));
    }
}

