/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.asm;

import cpw.mods.fml.relauncher.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class GuiIngameTransformer
implements IClassTransformer {
    private String obfClassName = "atr";
    private String mcpClassName = "net.minecraft.client.gui.GuiIngame";
    private String obfMethodName = "a";
    private String mcpMethodName = "renderGameOverlay";
    private String obfMethodDesc = "(FZII)V";
    private String mcpMethodDesc = "(FZII)V";
    private String obfPointOwner = "ban";
    private String mcpPointOwner = "net/minecraft/client/renderer/EntityRenderer";
    private String obfPointName = "c";
    private String mcpPointName = "setupOverlayRendering";
    private String obfPointDesc = "()V";
    private String mcpPointDesc = "()V";

    public byte[] transform(String name, byte[] bytes) {
        if (name.equals(this.mcpClassName)) {
            return this.transformClass(true, bytes);
        }
        if (name.equals(this.obfClassName)) {
            return this.transformClass(false, bytes);
        }
        return bytes;
    }

    private byte[] transformClass(boolean mcp, byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(mcp ? this.mcpMethodName : this.obfMethodName) || !m.desc.equals(mcp ? this.mcpMethodDesc : this.obfMethodDesc)) continue;
            this.transformMethod(mcp, m);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    protected void transformMethod(boolean mcp, MethodNode method) {
        for (int index = 0; index < method.instructions.size(); ++index) {
            if (method.instructions.get(index).getType() != 5) continue;
            MethodInsnNode mdNode = (MethodInsnNode)method.instructions.get(index);
            if (!mdNode.owner.equals(mcp ? this.mcpPointOwner : this.obfPointOwner) || !mdNode.name.equals(mcp ? this.mcpPointName : this.obfPointName) || !mdNode.desc.equals(mcp ? this.mcpPointDesc : this.obfPointDesc)) continue;
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(23, 1));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 4));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "net/tropicraft/mods/TropicraftMod", "renderGameOverlay", "(FZII)V"));
            method.instructions.insert(method.instructions.get(index), toInject);
            break;
        }
    }
}

