/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.blocks.liquids;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraftforge.common.Configuration;
import net.tropicraft.blocks.liquids.LAPICommonProxy;
import net.tropicraft.blocks.liquids.LAPIPacketHandler;

@NetworkMod(channels={"LAPI"}, clientSideRequired=true, serverSideRequired=false, packetHandler=LAPIPacketHandler.class)
@Mod(modid="LAPI", name="LAPI", version="for MC v1.3.2")
public class LAPI {
    private static ArrayList LAPIBlocks = new ArrayList();
    public static Map colorMap = new HashMap();
    private static int counter = 0;
    public static int nextID = -1;
    public static boolean showBlocksInCreativeMode = true;
    public static Map terrainIDMap = new HashMap();
    private static List availableStationaryIDList = new ArrayList();
    private static List availableFlowingIDList = new ArrayList();
    private static Map liquidPairs = new HashMap();
    @SidedProxy(clientSide="net.tropicraft.blocks.liquids.LAPIClientProxy", serverSide="net.tropicraft.blocks.liquids.LAPICommonProxy")
    public static LAPICommonProxy proxy;
    private static boolean hasInit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        Configuration preInitConfig = new Configuration(event.getSuggestedConfigurationFile());
        try {
            preInitConfig.load();
            int c = 0;
            for (int a = 0; a < 8; ++a) {
                for (int b = 0; b < 5; ++b) {
                    availableStationaryIDList.add(b * 3 + 32 * a);
                    availableFlowingIDList.add(b * 3 + 32 * a + 1);
                    System.out.println("[LAPI] Placing " + (b * 3 + 32 * a) + " at " + c + " for stationary liquids");
                    System.out.println("[LAPI] Placing " + (b * 3 + 32 * a + 1) + " at " + c + " for moving liquids");
                    ++c;
                }
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"LAPI has a problem loading it's configuration", (Object[])new Object[0]);
        }
        finally {
            preInitConfig.save();
        }
    }

    @Mod.Init
    public static void init(FMLInitializationEvent event) {
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
    }

    public static final void setColorValues(int liquidID, int hexColor) {
        colorMap.put(liquidID, hexColor);
        System.out.println("[LAPI] Placing liquidID " + liquidID + " with hex color " + hexColor + " into LAPI.colorMap");
    }

    public static int getColorValue(int liquidID) {
        try {
            return (Integer)colorMap.get(liquidID);
        }
        catch (NullPointerException npe) {
            System.out.println("No values in the LAPI Color Map!");
            return 0xFFFFFF;
        }
    }

    public static int getUniqueLiquidID() {
        return proxy.getUniqueLiquidID();
    }

    public static int getUniqueStationaryID() {
        int a = (Integer)availableStationaryIDList.get(nextID);
        return a;
    }

    public static int getUniqueFlowingID() {
        int a = (Integer)availableFlowingIDList.get(nextID);
        return a;
    }

    public static int getTextureIDFromLiquidID(int liquidID, boolean isAnimatedLiquid) {
        if (!isAnimatedLiquid) {
            return liquidID;
        }
        return liquidID + 1;
    }

    public static void registerBlock(amq block, String blockName) {
        GameRegistry.registerBlock((amq)block);
        LanguageRegistry.addName((Object)block, (String)blockName);
        LAPIBlocks.add(block);
    }

    public static boolean isWater(yc world, int i, int j, int k) {
        return world.a(i, j, k) == amq.D.cm || world.a(i, j, k) == amq.E.cm;
    }

    public static ArrayList getBlockList() {
        return LAPIBlocks;
    }

    public static void registerLiquidPair(amq block1, amq block2) {
        try {
            liquidPairs.put(block1.cm, block2.cm);
            liquidPairs.put(block2.cm, block1.cm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getPairedBlockID(amq block) {
        return LAPI.getPairedBlockID(block.cm);
    }

    public static int getPairedBlockID(int blockID) {
        return (Integer)liquidPairs.get(blockID);
    }

    static {
        hasInit = false;
    }
}

