/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.structures;

import java.util.Arrays;
import java.util.List;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.structures.KoaVillage;

public abstract class KoaVillageComponent {
    protected static final List waterBlockIDs = Arrays.asList(amq.D.cm, amq.E.cm, TropicraftMod.waterMovingTropics.cm, TropicraftMod.waterStillTropics.cm);
    protected int homeX;
    protected int homeY;
    protected int homeZ;
    protected int genX;
    protected int genY;
    protected int genZ;
    protected int genDirection = -1;
    protected KoaVillage village;
    protected acn boundingBox;

    public abstract boolean canFitInWorld(yc var1);

    public abstract void generate(yc var1);

    public abstract void spawn(yc var1);

    public acn getBoundingBox() {
        return this.boundingBox;
    }

    protected void place(yc world, int x, int y2, int z2, amq b) {
        world.e(x, y2, z2, b.cm);
    }

    protected void place(yc world, int i, int j, int k, amq block, int meta) {
        this.placeWithMetadata(world, i, j, k, block, meta);
    }

    protected void placeDownTilGround(yc world, int x, int y2, int z2, amq block1) {
        while (waterBlockIDs.contains(world.a(x, y2, z2)) || world.a(x, y2, z2) == 0) {
            this.place(world, x, y2, z2, block1);
            --y2;
        }
    }

    protected void placeWithMetadata(yc world, int i, int j, int k, amq block, int meta) {
        world.d(i, j, k, block.cm, meta);
    }

    protected void place(yc world, int i, int j, int k, int l) {
        world.e(i, j, k, l);
    }

    protected void placeBlockInAdjacentAirWithRadius(yc world, int i2, int j2, int k2, int r1, int r2, amq blockgold) {
        for (int a = r1; a < r2; ++a) {
            int[] asdf = new int[3];
            if (world.a(i2 + a, j2, k2) == 0) {
                asdf[0] = i2 + a;
                asdf[1] = j2;
                asdf[2] = k2;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.a(i2 - a, j2, k2) == 0) {
                asdf[0] = i2 - a;
                asdf[1] = j2;
                asdf[2] = k2;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.a(i2 + a, j2, k2 + a) == 0) {
                asdf[0] = i2 + a;
                asdf[1] = j2;
                asdf[2] = k2 + a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.a(i2 - a, j2, k2 - a) == 0) {
                asdf[0] = i2 - a;
                asdf[1] = j2;
                asdf[2] = k2 - a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.a(i2, j2, k2 + a) == 0) {
                asdf[0] = i2;
                asdf[1] = j2;
                asdf[2] = k2 + a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.a(i2, j2, k2 - a) == 0) {
                asdf[0] = i2;
                asdf[1] = j2;
                asdf[2] = k2 - a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.a(i2 - a, j2, k2 + a) == 0) {
                asdf[0] = i2 - a;
                asdf[1] = j2;
                asdf[2] = k2 + a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.a(i2 + a, j2, k2 - a) != 0) continue;
            asdf[0] = i2 + a;
            asdf[1] = j2;
            asdf[2] = k2 - a;
            this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
        }
    }
}

