/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.teleporter;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.tropicraft.blocks.tileentities.TileEntityBambooChest;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.WorldProviderTropics;

public class TeleporterTropics
extends yq {
    private int portalBlockID;
    private int portalWallID;
    private static final List validBlockIDs = Arrays.asList(amq.H.cm, TropicraftMod.purifiedSand.cm, amq.x.cm, amq.y.cm);
    private final in world;

    public TeleporterTropics(in ws) {
        super(ws);
        this.portalBlockID = TropicraftMod.tropicraftPortal.cm;
        this.portalWallID = TropicraftMod.portalWall.cm;
        this.world = ws;
    }

    public void a(lq entity, double d, double d2, double d3, float f) {
        if (!this.b(entity, d, d2, d3, f)) {
            this.a(entity);
            this.b(entity, d, d2, d3, f);
        }
    }

    public boolean b(lq entity, double d, double d2, double d3, float f) {
        int x;
        int searchArea = 256;
        double closestPortal = -1.0;
        int foundX = 0;
        int foundY = 0;
        int foundZ = 0;
        int entityX = ke.c((double)entity.t);
        int entityZ = ke.c((double)entity.v);
        for (x = entityX - searchArea; x <= entityX + searchArea; ++x) {
            double distX = (double)x + 0.5 - entity.t;
            for (int z2 = entityZ - searchArea; z2 <= entityZ + searchArea; ++z2) {
                double distZ = (double)z2 + 0.5 - entity.v;
                for (int y2 = this.world.O() - 1; y2 >= 0; --y2) {
                    if (this.world.a(x, y2, z2) != this.portalBlockID) continue;
                    while (this.world.a(x, y2 - 1, z2) == this.portalBlockID) {
                        --y2;
                    }
                    double distY = (double)y2 + 0.5 - entity.u;
                    double distance = distX * distX + distY * distY + distZ * distZ;
                    if (!(closestPortal < 0.0) && !(distance < closestPortal)) continue;
                    closestPortal = distance;
                    foundX = x;
                    foundY = y2;
                    foundZ = z2;
                }
            }
        }
        if (closestPortal >= 0.0) {
            x = foundX;
            int y3 = foundY;
            int z3 = foundZ;
            double newLocX = (double)x + 0.5;
            double newLocY = (double)y3 + 0.5;
            double newLocZ = (double)z3 + 0.5;
            if (this.world.a(x - 1, y3, z3) == this.portalBlockID) {
                newLocX -= 0.5;
            }
            if (this.world.a(x + 1, y3, z3) == this.portalBlockID) {
                newLocX += 0.5;
            }
            if (this.world.a(x, y3, z3 - 1) == this.portalBlockID) {
                newLocZ -= 0.5;
            }
            if (this.world.a(x, y3, z3 + 1) == this.portalBlockID) {
                newLocZ += 0.5;
            }
            entity.b(newLocX, newLocY + 2.0, newLocZ, entity.z, 0.0f);
            int worldSpawnX = ke.c((double)newLocX) + (new Random().nextBoolean() ? 3 : -3);
            int worldSpawnZ = ke.c((double)newLocZ) + (new Random().nextBoolean() ? 3 : -3);
            int worldSpawnY = this.world.f(worldSpawnX, worldSpawnZ) + 3;
            this.world.K().a(worldSpawnX, worldSpawnY, worldSpawnZ);
            entity.y = 0.0;
            entity.x = 0.0;
            entity.w = 0.0;
            if (entity instanceof qx) {
                qx player = (qx)entity;
                if (this.world.u instanceof WorldProviderTropics && !player.bJ.e(TropicraftMod.encTropica.cj)) {
                    TileEntityBambooChest chest = null;
                    int chestX = ke.c((double)newLocX);
                    int chestZ = ke.c((double)newLocZ);
                    block4: for (int searchX = -3; searchX < 4; ++searchX) {
                        for (int searchZ = -3; searchZ < 4; ++searchZ) {
                            for (int searchY = -3; searchY < 4; ++searchY) {
                                if (this.world.a(chestX + searchX, worldSpawnY + searchY, chestZ + searchZ) == TropicraftMod.bambooChest.cm && (chest = (TileEntityBambooChest)this.world.q(chestX + searchX, worldSpawnY + searchY, chestZ + searchZ)) != null && chest.isUnbreakable()) break block4;
                            }
                        }
                    }
                    if (chest != null && chest.isUnbreakable()) {
                        int inv;
                        boolean hasEncyclopedia = false;
                        for (inv = 0; inv < chest.k_(); ++inv) {
                            ur stack = chest.a(inv);
                            if (stack == null || stack.b() != TropicraftMod.encTropica) continue;
                            hasEncyclopedia = true;
                        }
                        if (!hasEncyclopedia) {
                            for (inv = 0; inv < chest.k_(); ++inv) {
                                ur stack = chest.a(inv);
                                if (stack != null) continue;
                                chest.a(inv, new ur(TropicraftMod.encTropica, 1));
                                break;
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean a(lq entity) {
        int searchArea = 32;
        double closestSpot = -1.0;
        int entityX = ke.c((double)entity.t);
        int entityY = ke.c((double)entity.u);
        int entityZ = ke.c((double)entity.v);
        int foundX = entityX;
        int foundY = entityY;
        int foundZ = entityZ;
        for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
            double distX = (double)x + 0.5 - entity.t;
            block1: for (int z2 = entityZ - searchArea; z2 <= entityZ + searchArea; ++z2) {
                int y2;
                double distZ = (double)z2 + 0.5 - entity.v;
                for (y2 = this.world.O() - 1; !(y2 < 62 || this.world.a(x, y2, z2) != 0 && amq.p[this.world.a((int)x, (int)y2, (int)z2)].cB.a()); --y2) {
                }
                if (y2 > 83 || y2 < 63 || !validBlockIDs.contains(this.world.a(x, y2, z2))) continue;
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        int otherY;
                        for (otherY = this.world.O() - 1; !(otherY < 63 || this.world.a(x + xOffset, otherY, z2 + zOffset) != 0 && amq.p[this.world.a((int)(x + xOffset), (int)otherY, (int)(z2 + zOffset))].cB.a()); --otherY) {
                        }
                        if (Math.abs(y2 - otherY) >= 3 || !validBlockIDs.contains(this.world.a(x + xOffset, otherY, z2 + zOffset))) continue block1;
                    }
                }
                double distY = (double)y2 + 0.5 - entity.u;
                double distance = distX * distX + distY * distY + distZ * distZ;
                if (!(closestSpot < 0.0) && !(distance < closestSpot)) continue;
                closestSpot = distance;
                foundX = x;
                foundY = y2;
                foundZ = z2;
            }
        }
        if (closestSpot < 0.0) {
            Random r2 = new Random();
            foundX += r2.nextInt(16) - 8;
            foundZ += r2.nextInt(16) - 8;
            foundY = 63;
        }
        this.buildTeleporterAt(foundX, foundY, foundZ, entity);
        return true;
    }

    public void buildTeleporterAt(int x, int y2, int z2, lq entity) {
        int blockZ;
        int blockY;
        int blockX;
        int xOffset;
        int zOffset;
        int yOffset;
        y2 = y2 < 9 ? 9 : y2;
        this.world.r = true;
        for (yOffset = 4; yOffset >= -7; --yOffset) {
            for (zOffset = -2; zOffset <= 2; ++zOffset) {
                for (xOffset = -2; xOffset <= 2; ++xOffset) {
                    boolean isCorner;
                    blockX = x + xOffset;
                    blockY = y2 + yOffset;
                    blockZ = z2 + zOffset;
                    if (yOffset == -7) {
                        this.world.e(blockX, blockY, blockZ, this.portalWallID);
                    } else if (yOffset > 0) {
                        this.world.e(blockX, blockY, blockZ, 0);
                    } else {
                        boolean isWall;
                        boolean bl = isWall = xOffset == -2 || xOffset == 2 || zOffset == -2 || zOffset == 2;
                        if (isWall) {
                            this.world.e(blockX, blockY, blockZ, this.portalWallID);
                        } else {
                            int metadata = yOffset == -7 ? 8 : 0;
                            this.world.d(blockX, blockY, blockZ, this.portalBlockID, metadata);
                        }
                    }
                    boolean bl = isCorner = !(xOffset != -2 && xOffset != 2 || zOffset != -2 && zOffset != 2);
                    if (yOffset != 0 || !isCorner) continue;
                    this.world.d(blockX, blockY + 1, blockZ, TropicraftMod.tikiTorch.cm, 1);
                    this.world.d(blockX, blockY + 2, blockZ, TropicraftMod.tikiTorch.cm, 1);
                    this.world.d(blockX, blockY + 3, blockZ, TropicraftMod.tikiTorch.cm, 0);
                }
            }
        }
        this.world.r = false;
        if (this.world.u instanceof WorldProviderTropics) {
            this.world.d(x + 2, y2 + 1, z2, TropicraftMod.bambooChest.cm, 1);
            TileEntityBambooChest tile = (TileEntityBambooChest)this.world.q(x + 2, y2 + 1, z2);
            if (tile != null) {
                tile.setIsUnbreakable(true);
            }
        }
        for (yOffset = 5; yOffset >= -7; --yOffset) {
            for (zOffset = -2; zOffset <= 2; ++zOffset) {
                for (xOffset = -2; xOffset <= 2; ++xOffset) {
                    blockX = x + xOffset;
                    blockY = y2 + yOffset;
                    blockZ = z2 + zOffset;
                    this.world.h(blockX, blockY, blockZ, this.world.a(blockX, blockY, blockZ));
                }
            }
        }
    }
}

