/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenBentRainforestTree
extends TCGenBase {
    public WorldGenBentRainforestTree(yc world, Random random) {
        super(world, random);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        if (this.worldObj.a(i, j - 1, k) != amq.y.cm && this.worldObj.a(i, j - 1, k) != amq.x.cm) {
            return false;
        }
        int height1 = this.rand.nextInt(4) + 4 + j;
        int height2 = this.rand.nextInt(6) + 6 + height1;
        double angle1 = this.randAngle();
        double angle2 = this.randAngle();
        int length1 = this.rand.nextInt(2) + 1;
        int length2 = this.rand.nextInt(6) + 4;
        int randOffsetX1 = (int)Math.round((double)length1 * Math.sin(angle1) + (double)i);
        int randOffsetZ1 = (int)Math.round((double)length1 * Math.cos(angle1) + (double)k);
        int randOffsetX2 = (int)Math.round((double)length2 * Math.sin(angle2)) + randOffsetX1;
        int randOffsetZ2 = (int)Math.round((double)length2 * Math.cos(angle2)) + randOffsetZ1;
        this.genCircle(i, j - 1, k, 1.0, 0.0, amq.y.cm, 0, true);
        if (!this.checkBlockCircleLine(new int[]{randOffsetX1, height1, randOffsetZ1}, new int[]{randOffsetX2, height2, randOffsetZ2}, 1.3, 0.0, Arrays.asList(0, amq.aa.cm, amq.aV.cm, TropicraftMod.tropicLeaves.cm, amq.N.cm))) {
            return false;
        }
        if (this.checkAndPlaceBlockCircleLine(new int[]{i, j, k}, new int[]{randOffsetX1, height1, randOffsetZ1}, 1.3, 0.0, TropicraftMod.tropicalWood.cm, 1, Arrays.asList(0, amq.aa.cm, amq.aV.cm, TropicraftMod.tropicLeaves.cm, amq.N.cm)) == null) {
            return false;
        }
        ArrayList trunk = this.placeBlockCircleLine(new int[]{randOffsetX1, height1, randOffsetZ1}, new int[]{randOffsetX2, height2, randOffsetZ2}, 1.3, 0.0, TropicraftMod.tropicalWood.cm, 1);
        for (int lVar = 0; lVar < trunk.size(); ++lVar) {
            int[] block = (int[])trunk.get(lVar);
            if (this.rand.nextInt(3) != 0) continue;
            int branches = this.rand.nextInt(2) + 1;
            for (int lVar2 = 0; lVar2 < branches; ++lVar2) {
                this.genBranch(block);
            }
        }
        int[] top = (int[])trunk.get(trunk.size() - 1);
        this.genBranch(top);
        return true;
    }

    public boolean genBranch(int[] block) {
        double randAngle = this.randAngle();
        int branchLength = this.rand.nextInt(4) + 4;
        int branchHeight = this.rand.nextInt(3);
        int ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)block[0]);
        int az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)block[2]);
        if (this.checkAndPlaceBlockCircleLine(new int[]{ax, branchHeight + block[1], az}, new int[]{block[0], block[1], block[2]}, 1.0, 0.0, TropicraftMod.tropicalWood.cm, 1, Arrays.asList(0, amq.aa.cm, amq.aV.cm)) == null) {
            this.genSphere(ax, branchHeight + block[1], az, this.rand.nextInt(2) + 2, TropicraftMod.tropicLeaves.cm, 3);
        }
        return true;
    }
}

