/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.tropicraft.world.worldgen.WorldGenRainforest;

public class WorldGenCanopyTreeTall
extends WorldGenRainforest {
    int radius;

    public WorldGenCanopyTreeTall(int rad) {
        this.radius = rad;
    }

    public boolean a(yc world, Random rand, int i, int j, int k) {
        rand = new Random();
        int height = rand.nextInt(15);
        if (height < 12) {
            height += 10 + Math.abs(rand.nextInt(5));
        }
        int id = amq.M.cm;
        if (height + 5 > 127) {
            return false;
        }
        if (world.a(i, j - 1, k) != amq.y.cm && world.a(i, j - 1, k) != amq.x.cm) {
            return false;
        }
        for (int h = 0; h < height; ++h) {
            this.place(world, i, j + h, k, id);
            this.place(world, i + 1, j + h, k, id);
            this.place(world, i, j + h, k + 1, id);
            this.place(world, i + 1, j + h, k + 1, id);
        }
        int j1 = j + height - 1;
        for (int i1 = i - this.radius + 1; i1 < i + this.radius + 1; ++i1) {
            for (int k1 = k - this.radius + 1; k1 < k + this.radius + 1; ++k1) {
                this.place(world, i1, j1, k1, amq.N.cm);
                if (i1 <= i - this.radius + 1 || k1 <= k - this.radius + 1 || i1 >= i + this.radius || k1 >= k + this.radius) continue;
                this.place(world, i1, j1 + 1, k1, amq.N.cm);
            }
        }
        this.genLine(world, i + 2, j + height - 5 - rand.nextInt(3), k, 3.0f, 5.0f, id, 0, true);
        this.genLine(world, i, j + height - 7 - rand.nextInt(3), k, 3.0f, 5.0f, id, 1, true);
        this.genLine(world, i, j + height - height / 2 + rand.nextInt(4), k + 1, 4.0f, 3.0f, id, 2, true);
        if (rand.nextInt(2) == 0) {
            this.genLine(world, i, j + height - height / 2 - rand.nextInt(4), k - 1, 5.0f, 4.0f, id, 3, true);
        }
        if (height > 18) {
            this.genLine(world, i + 2, j + height - 10 - rand.nextInt(3), k, 3.0f, 5.0f, id, 0, true);
            this.genLine(world, i, j + height - 7 - rand.nextInt(3), k, 3.0f, 5.0f, id, rand.nextInt(2) + 1, true);
        }
        for (int d = 0; d < 20; ++d) {
            for (int e = height; e < height + j; ++e) {
                if (!rand.nextBoolean()) continue;
                this.genVines(world, rand, i + d, e + j, k + d);
            }
        }
        return true;
    }

    public void genLine(yc world, int i, int j, int k, float rise, float run, int id, int dir, boolean shouldNodes) {
        float slope = rise / run;
        ArrayList<s> nodes = new ArrayList<s>();
        switch (dir) {
            case 0: {
                if (run > rise) {
                    int[] ypoints = new int[(int)run];
                    int r2 = 0;
                    while ((float)r2 < run) {
                        ypoints[r2] = (int)((float)r2 * slope);
                        ++r2;
                    }
                    double y2 = 0.0;
                    int prevY = j;
                    int x = i;
                    while ((float)x < (float)i + run) {
                        y2 = j + ypoints[x - i];
                        if ((float)x == (float)i + run - 1.0f) {
                            nodes.add(new s(x, (int)y2, k));
                        }
                        this.place(world, x, (int)y2, k, id);
                        ++x;
                    }
                } else if (rise > run) {
                    int[] xpoints = new int[(int)rise];
                    int r3 = 0;
                    while ((float)r3 < rise) {
                        xpoints[r3] = (int)((float)r3 / slope);
                        ++r3;
                    }
                    double x = 0.0;
                    int y3 = j;
                    while ((float)y3 < (float)j + rise) {
                        x = xpoints[y3 - j] + i;
                        if ((float)y3 == (float)j + rise - 1.0f) {
                            nodes.add(new s((int)x, y3, k));
                        }
                        this.place(world, (int)x, y3, k, id);
                        ++y3;
                    }
                } else {
                    int x = i;
                    while ((float)x < run + (float)i) {
                        this.place(world, x, j + (x - i), k, id);
                        ++x;
                    }
                }
                break;
            }
            case 1: {
                if (run > rise) {
                    int[] ypoints = new int[(int)run];
                    int r4 = 0;
                    while ((float)r4 < run) {
                        ypoints[r4] = (int)((float)r4 * slope);
                        ++r4;
                    }
                    double y4 = 0.0;
                    int prevY = j;
                    int x = i;
                    while ((float)x > (float)i - run) {
                        y4 = j + ypoints[i - x];
                        if ((float)x == (float)i - run + 1.0f) {
                            nodes.add(new s(x, (int)y4, k));
                        }
                        this.place(world, x, (int)y4, k, id);
                        --x;
                    }
                } else if (rise > run) {
                    int[] xpoints = new int[(int)rise];
                    int r5 = 0;
                    while ((float)r5 < rise) {
                        xpoints[r5] = (int)((float)r5 / slope);
                        ++r5;
                    }
                    double x = 0.0;
                    int y5 = j;
                    while ((float)y5 < (float)j + rise) {
                        x = i - xpoints[y5 - j];
                        if ((float)y5 == (float)j + rise - 1.0f) {
                            nodes.add(new s((int)x, y5, k));
                        }
                        this.place(world, (int)x, y5, k, id);
                        ++y5;
                    }
                } else {
                    int x = i;
                    while ((float)x < run + (float)i) {
                        this.place(world, x, j + (x - i), k, id);
                        ++x;
                    }
                }
                break;
            }
            case 2: {
                if (run > rise) {
                    int[] ypoints = new int[(int)run];
                    int r6 = 0;
                    while ((float)r6 < run) {
                        ypoints[r6] = (int)((float)r6 * slope);
                        ++r6;
                    }
                    double y6 = 0.0;
                    int prevY = j;
                    int z2 = k;
                    while ((float)z2 < (float)k + run) {
                        y6 = j + ypoints[z2 - k];
                        if ((float)z2 == (float)k + run - 1.0f) {
                            nodes.add(new s(i, (int)y6, z2));
                        }
                        this.place(world, i, (int)y6, z2, id);
                        ++z2;
                    }
                } else if (rise > run) {
                    int[] zpoints = new int[(int)rise];
                    int r7 = 0;
                    while ((float)r7 < rise) {
                        zpoints[r7] = (int)((float)r7 / slope);
                        ++r7;
                    }
                    double z3 = 0.0;
                    int y7 = j;
                    while ((float)y7 < (float)j + rise) {
                        z3 = zpoints[y7 - j] + k;
                        if ((float)y7 == (float)j + rise - 1.0f) {
                            nodes.add(new s(i, y7, (int)z3));
                        }
                        this.place(world, i, y7, (int)z3, id);
                        ++y7;
                    }
                } else {
                    int z4 = k;
                    while ((float)z4 < run + (float)k) {
                        this.place(world, i, j + (z4 - k), z4, id);
                        ++z4;
                    }
                }
                break;
            }
            case 3: {
                if (run > rise) {
                    int[] ypoints = new int[(int)run];
                    int r8 = 0;
                    while ((float)r8 < run) {
                        ypoints[r8] = (int)((float)r8 * slope);
                        ++r8;
                    }
                    double y8 = 0.0;
                    int prevY = j;
                    int z5 = k;
                    while ((float)z5 > (float)k - run) {
                        y8 = j + ypoints[k - z5];
                        if ((float)z5 == (float)k - run + 1.0f) {
                            nodes.add(new s(i, (int)y8, z5));
                        }
                        this.place(world, i, (int)y8, z5, id);
                        --z5;
                    }
                } else if (rise > run) {
                    int[] zpoints = new int[(int)rise];
                    int r9 = 0;
                    while ((float)r9 < rise) {
                        zpoints[r9] = (int)((float)r9 / slope);
                        ++r9;
                    }
                    double z6 = 0.0;
                    int y9 = j;
                    while ((float)y9 < (float)j + rise) {
                        z6 = k - zpoints[y9 - j];
                        if ((float)y9 == (float)j + rise - 1.0f) {
                            nodes.add(new s(i, y9, (int)z6));
                        }
                        this.place(world, i, y9, (int)z6, id);
                        ++y9;
                    }
                } else {
                    int z7 = k;
                    while ((float)z7 < run + (float)k) {
                        this.place(world, i, j + (z7 - k), z7, id);
                        ++z7;
                    }
                }
                break;
            }
        }
        if (shouldNodes) {
            this.genNodes(world, this.genBranches(world, nodes));
        }
    }

    private ArrayList genBranches(yc world, ArrayList nodes) {
        int id = amq.M.cm;
        Random rand = new Random();
        ArrayList<s> newnodes = new ArrayList<s>();
        for (s node : nodes) {
            int rise = rand.nextInt(5);
            int run = rand.nextInt(6);
            int dir = rand.nextInt(4);
            if (rise == run) {
                ++run;
            }
            this.genLine(world, node.a, node.b, node.c, rise, run, id, dir, false);
            switch (dir) {
                case 0: {
                    newnodes.add(new s(node.a + run, node.b + rise, node.c));
                    break;
                }
                case 1: {
                    newnodes.add(new s(node.a - run, node.b + rise, node.c));
                    break;
                }
                case 2: {
                    newnodes.add(new s(node.a, node.b + rise, node.c + run));
                    break;
                }
                case 3: {
                    newnodes.add(new s(node.a, node.b + rise, node.c - run));
                    break;
                }
            }
        }
        return newnodes;
    }

    private void genNodes(yc world, ArrayList nodes) {
        int id = amq.N.cm;
        for (s node : nodes) {
            for (int i1 = node.a - this.radius + 1; i1 < node.a + this.radius + 1; ++i1) {
                for (int k1 = node.c - this.radius + 1; k1 < node.c + this.radius + 1; ++k1) {
                    this.placeWithMetadata(world, i1, node.b, k1, id, 8);
                    if (i1 <= node.a - this.radius + 1 || k1 <= node.c - this.radius + 1 || i1 >= node.a + this.radius || k1 >= node.c + this.radius) continue;
                    this.placeWithMetadata(world, i1, node.b + 1, k1, id, 8);
                }
            }
        }
    }
}

