/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.biomes.BiomeGenTropicraft;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenMedRTree
extends TCGenBase {
    private boolean gen = false;
    private int woodBlockId;
    private int leafBlockId;

    public WorldGenMedRTree(yc world, Random random, boolean flag) {
        super(world, random);
        this.woodBlockId = TropicraftMod.tropicalWood.cm;
        this.leafBlockId = TropicraftMod.tropicLeaves.cm;
        this.gen = flag;
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int bid;
        yy biome = this.worldObj.a(i, k);
        if (this.gen && BiomeGenTropicraft.rainforestBiomes.contains(biome)) {
            return false;
        }
        if (this.gen) {
            j = this.getTerrainHeightAt(i, k);
        }
        if ((bid = this.worldObj.a(i, j - 1, k)) != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        bid = this.worldObj.a(i + 1, j - 1, k);
        if (bid != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        bid = this.worldObj.a(i - 1, j - 1, k);
        if (bid != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        bid = this.worldObj.a(i, j - 1, k + 1);
        if (bid != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        bid = this.worldObj.a(i, j - 1, k - 1);
        if (bid != amq.y.cm && bid != amq.x.cm) {
            return false;
        }
        int tMod = 1;
        int height = this.rand.nextInt(8) + 10;
        int bs1 = height - this.rand.nextInt(3) - 2;
        int xm = 0;
        int zm = 0;
        if (this.rand.nextBoolean()) {
            int n = xm = this.rand.nextBoolean() ? -1 : 1;
            if (this.rand.nextBoolean()) {
                zm = this.rand.nextBoolean() ? -1 : 1;
            }
        } else {
            int n = zm = this.rand.nextBoolean() ? -1 : 1;
            if (this.rand.nextBoolean()) {
                xm = this.rand.nextBoolean() ? -1 : 1;
            }
        }
        int xb = xm;
        int zb2 = zm;
        if (xb == 0) {
            xb = 1;
        }
        if (zb2 == 0) {
            zb2 = 1;
        }
        int tbx = i;
        int tbz = k;
        for (int y2 = j; y2 <= j + height; ++y2) {
            int id;
            if (y2 - j > tMod) {
                tbx += xm;
                tbz += zm;
                tMod *= 2;
            }
            if ((id = this.worldObj.a(tbz, y2, tbz)) == 0 || id == amq.aa.cm || id == this.leafBlockId) continue;
            return false;
        }
        int tx = i;
        int tz = k;
        for (int y3 = j; y3 <= j + height; ++y3) {
            int ty;
            int ttx;
            int az;
            int ax;
            int branchLength;
            int b;
            int branches;
            int leafSize;
            int oz2;
            int ox2;
            if (y3 - j > tMod) {
                tx += xm;
                tz += zm;
                tMod *= 2;
            }
            this.worldObj.c(tx, y3, tz, this.woodBlockId, 1);
            this.worldObj.c(tx - 1, y3, tz, this.woodBlockId, 1);
            this.worldObj.c(tx + 1, y3, tz, this.woodBlockId, 1);
            this.worldObj.c(tx, y3, tz - 1, this.woodBlockId, 1);
            this.worldObj.c(tx, y3, tz + 1, this.woodBlockId, 1);
            if (y3 - j == bs1) {
                ox2 = tx + this.rand.nextInt(4) - 3;
                oz2 = tz + this.rand.nextInt(4) - 3;
                leafSize = this.rand.nextInt(4) + 4;
                this.genCircle(ox2, y3 + 2, oz2, leafSize, 0.0, this.leafBlockId, 3, false);
                this.genCircle(ox2, y3 + 1, oz2, leafSize + 1, leafSize - 1, this.leafBlockId, 3, false);
                branches = this.rand.nextInt(4) + 4;
                for (b = 0; b < branches; ++b) {
                    double randAngle = this.randAngle();
                    branchLength = this.rand.nextInt(leafSize - 2) + 2;
                    ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)ox2);
                    az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)oz2);
                    this.checkAndPlaceBlockLine(new int[]{tx, y3, tz}, new int[]{ax, y3 + 1, az}, this.woodBlockId, 1, Arrays.asList(0, amq.N.cm, amq.bx.cm));
                }
                for (ttx = ox2 - leafSize; ttx < ox2 + leafSize; ++ttx) {
                    for (int ttz = oz2 - leafSize; ttz < oz2 + leafSize; ++ttz) {
                        for (ty = y3; ty <= y3 + 2; ++ty) {
                            if (this.rand.nextInt(3) != 0) continue;
                            this.genVines(ttx, ty, ttz);
                        }
                    }
                }
            }
            if (y3 - j != height) continue;
            ox2 = tx + this.rand.nextInt(4) - 3;
            oz2 = tz + this.rand.nextInt(4) - 3;
            leafSize = this.rand.nextInt(4) + 4;
            this.genCircle(ox2, y3 + 2, oz2, leafSize, 0.0, this.leafBlockId, 3, false);
            this.genCircle(ox2, y3 + 1, oz2, leafSize + 1, leafSize - 1, this.leafBlockId, 3, false);
            branches = this.rand.nextInt(4) + 5;
            for (b = 0; b < branches; ++b) {
                double randAngle = this.randAngle();
                branchLength = this.rand.nextInt(leafSize - 2) + 2;
                ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)ox2);
                az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)oz2);
                this.checkAndPlaceBlockLine(new int[]{tx, y3, tz}, new int[]{ax, y3 + 1, az}, this.woodBlockId, 1, Arrays.asList(0, amq.N.cm, amq.bx.cm));
            }
            for (ttx = ox2 - leafSize; ttx < ox2 + leafSize; ++ttx) {
                for (int ttz = oz2 - leafSize; ttz < oz2 + leafSize; ++ttz) {
                    for (ty = y3; ty <= y3 + 2; ++ty) {
                        if (this.rand.nextInt(3) != 0) continue;
                        this.genVines(ttx, ty, ttz);
                    }
                }
            }
        }
        return true;
    }

    private boolean genVines(int i, int j, int k) {
        int dir = this.rand.nextInt(4);
        int m = 2;
        while (true) {
            if (m > 5) {
                return false;
            }
            if (amq.bx.b_(this.worldObj, i, j, k, m) && this.worldObj.a(i, j, k) == 0) break;
            ++m;
        }
        this.worldObj.c(i, j, k, amq.bx.cm, 1 << q.e[r.a[m]]);
        int length = this.rand.nextInt(4) + 4;
        for (int y2 = j - 1; y2 > j - length; --y2) {
            if (this.worldObj.a(i, y2, k) != 0) {
                return true;
            }
            this.worldObj.c(i, y2, k, amq.bx.cm, 1 << q.e[r.a[m]]);
        }
        return true;
    }
}

