/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.tropicraft.mods.TropicraftMod;
import net.tropicraft.world.biomes.BiomeGenTropicraft;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenTallRainforestTree
extends TCGenBase {
    public int woodBlockId;
    public int leafBlockID;

    public WorldGenTallRainforestTree(yc world, Random random) {
        super(world, random);
        this.woodBlockId = TropicraftMod.tropicalWood.cm;
        this.leafBlockID = TropicraftMod.tropicLeaves.cm;
    }

    @Override
    public boolean generate(int i, int j, int k) {
        if (!BiomeGenTropicraft.rainforestBiomes.contains(this.worldObj.a(i, k))) {
            return false;
        }
        int height = this.rand.nextInt(15) + 25 + j;
        if (height + 5 > 127) {
            return false;
        }
        if (this.worldObj.a(i, j - 1, k) != amq.y.cm && this.worldObj.a(i, j - 1, k) != amq.x.cm) {
            return false;
        }
        for (int x = i - 1; x <= i + 1; ++x) {
            for (int z2 = k - 1; z2 <= k + 1; ++z2) {
                for (int y2 = j; y2 < j + height; ++y2) {
                    int bId = this.worldObj.a(x, y2, z2);
                    if (bId == 0 || this.isLeafId(bId) || bId == amq.aa.cm || bId == amq.aV.cm) continue;
                    return false;
                }
            }
        }
        this.genCircle(i, j - 1, k, 1.0, 0.0, amq.y.cm, 0, true);
        this.placeBlockCircleLine(new int[]{i, j, k}, new int[]{i, height, k}, 1.3, 0.0, this.woodBlockId, 1);
        this.genSphere(i, height, k, 4, this.leafBlockID, 3);
        this.genSphere(i - 3, height, k, 4, this.leafBlockID, 3);
        this.genSphere(i + 3, height, k, 4, this.leafBlockID, 3);
        this.genSphere(i, height, k + 3, 4, this.leafBlockID, 3);
        this.genSphere(i, height, k - 3, 4, this.leafBlockID, 3);
        return true;
    }
}

