/*
 * Decompiled with CFR 0.152.
 */
package tropicraft;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import tropicraft.QuestEventHooksTropicraft;
import tropicraft.TropicraftZipFilesCopier;
import tropicraft.ai.WorldDirector;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.commands.CommandRegistry;
import tropicraft.config.ConfigHandler;
import tropicraft.config.TropicraftConfig;
import tropicraft.crafting.CraftingTropicraft;
import tropicraft.drinks.MixerRecipes;
import tropicraft.economy.ItemValueEntries;
import tropicraft.encyclopedia.Encyclopedia;
import tropicraft.items.TropicraftItems;
import tropicraft.packets.TropicraftConnectionHandler;
import tropicraft.packets.TropicraftPacketHandler;
import tropicraft.proxies.CommonProxy;
import tropicraft.questsystem.PlayerQuestManager;
import tropicraft.registry.TCBlockRegistry;
import tropicraft.registry.TCEntityRegistry;
import tropicraft.world.TCWorldGenerator;
import tropicraft.world.TropicraftWorldUtils;
import tropicraft.world.structures.ComponentKoaVillage;
import tropicraft.world.structures.StructureKoaVillageStart;

@NetworkMod(channels={"Volcano", "SnareTrap", "QuestData", "PagesData"}, clientSideRequired=true, serverSideRequired=false, packetHandler=TropicraftPacketHandler.class, connectionHandler=TropicraftConnectionHandler.class)
@Mod(modid="tropicraftmod", name="TropicraftMod", version="v5.1.1 for MC 1.6.4")
public class Tropicraft {
    @Mod.Instance(value="tropicraftmod")
    public static Tropicraft instance;
    public static String modID;
    public Configuration config;
    public static String[] COCONUT_BOMB_WHITELIST;
    @SidedProxy(clientSide="tropicraft.proxies.ClientProxy", serverSide="tropicraft.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static List<String> coconutBombWhitelistedUsers;
    @SideOnly(value=Side.CLIENT)
    public static Encyclopedia encyclopedia;
    public static Logger logger;

    @ForgeSubscribe
    public void tropicsWaterBucketDrop(FillBucketEvent fbe) {
        World world = fbe.world;
        if (!world.field_72995_K) {
            Block block = Block.field_71973_m[world.func_72798_a(fbe.target.field_72311_b, fbe.target.field_72312_c, fbe.target.field_72309_d)];
            if (block.field_71990_ca == TropicraftBlocks.tropicsWaterStationary.field_71990_ca) {
                fbe.result = new ItemStack(TropicraftItems.bucketTropicsWater.field_77779_bT, 1, 0);
                world.func_94571_i(fbe.target.field_72311_b, fbe.target.field_72312_c, fbe.target.field_72309_d);
            }
            if (fbe.result != null && fbe.result.func_77973_b().field_77779_bT == TropicraftItems.bucketTropicsWater.field_77779_bT) {
                fbe.setResult(Event.Result.ALLOW);
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        CommandRegistry.init(event);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        PlayerQuestManager.i.saveAndUnload();
        WorldDirector.writeAllPlayerNBT();
    }

    public static void dbg(Object obj) {
        if (TropicraftConfig.debugConsole) {
            System.out.println(obj);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        try {
            ConfigHandler.initConfig(event);
            proxy.loadSounds();
            TropicraftZipFilesCopier.init();
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"Tropicraft has a problem loading it's configuration", (Object[])new Object[0]);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        logger.setParent(FMLLog.getLogger());
        logger.info("Starting to load TropicraftMod!");
        TropicraftBlocks.init();
        TropicraftItems.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TCWorldGenerator());
        MixerRecipes.addMixerRecipes();
        proxy.registerBooks();
        ItemValueEntries.initEconomy();
        TCEntityRegistry.init();
        TropicraftWorldUtils.initializeDimension();
        MapGenStructureIO.func_143031_a(ComponentKoaVillage.class, (String)"tropicraftmod:KoaVillageComponent");
        MapGenStructureIO.func_143034_b(StructureKoaVillageStart.class, (String)"tropicraftmod:KoaVillageStart");
        proxy.initTickers();
        proxy.registerBlockRenderIds();
        proxy.initTCRenderRegistry();
        proxy.registerTESRs();
        proxy.registerItemRenderers();
        proxy.registerBlockRenderHandlers();
        CraftingTropicraft.addRecipes();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new QuestEventHooksTropicraft());
        logger.info("Finished loading TropicraftMod!");
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent evt) {
        TCBlockRegistry.init();
    }

    static {
        modID = "tropicraftmod";
        COCONUT_BOMB_WHITELIST = null;
        logger = Logger.getLogger("TropicraftMod");
    }
}

