/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.encyclopedia;

import CoroAI.util.EnumOSHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumOS;

public abstract class TropicalBook {
    private File dataFile;
    public static File file = null;
    private HashMap<String, Byte> visiblePages = new HashMap();
    private HashMap<String, String> pageTitles = new HashMap();
    private HashMap<String, String> pageDescriptions = new HashMap();
    private List<String> sortedPages = new ArrayList<String>();
    public String outsideTexture;
    public String insideTexture;

    public TropicalBook(String savedDataFile, String contentsFile, String outsideTex, String insideTex) {
        this.outsideTexture = outsideTex;
        this.insideTexture = insideTex;
        this.dataFile = new File(TropicalBook.getAppDir("minecraft"), savedDataFile);
        try {
            if (this.dataFile.canRead()) {
                FileInputStream dataInput = new FileInputStream(this.dataFile);
                NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)dataInput);
                for (Object o : data.func_74758_c()) {
                    String tagName = ((NBTBase)o).func_74740_e();
                    Byte b = data.func_74771_c(tagName);
                    this.visiblePages.put(tagName, b);
                }
                ((InputStream)dataInput).close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        BufferedReader contents = new BufferedReader(new InputStreamReader(TropicalBook.class.getResourceAsStream(contentsFile)));
        try {
            String line;
            while ((line = contents.readLine()) != null) {
                if (!line.contains("=")) continue;
                String[] split = line.split("=", 2);
                String name = split[0].trim();
                String entry = split[1].trim();
                if (name.toLowerCase().endsWith(".title")) {
                    this.pageTitles.put(name.substring(0, name.length() - ".title".length()), entry);
                    this.sortedPages.add(name.substring(0, name.length() - ".title".length()));
                    continue;
                }
                if (!name.toLowerCase().endsWith(".desc")) continue;
                this.pageDescriptions.put(name.substring(0, name.length() - ".desc".length()), entry);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TropicalBook.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static File getAppDir(String par0Str) {
        File var2;
        String var1 = System.getProperty("user.home", ".");
        switch (EnumOSHelper.field_90049_a[TropicalBook.getOs().ordinal()]) {
            case 1: 
            case 2: {
                var2 = new File(var1, '.' + par0Str + '/');
                break;
            }
            case 3: {
                String var3 = System.getenv("APPDATA");
                if (var3 != null) {
                    var2 = new File(var3, "." + par0Str + '/');
                    break;
                }
                var2 = new File(var1, '.' + par0Str + '/');
                break;
            }
            case 4: {
                var2 = new File(var1, "Library/Application Support/" + par0Str);
                break;
            }
            default: {
                var2 = new File(var1, par0Str + '/');
            }
        }
        if (!var2.exists() && !var2.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + var2);
        }
        return var2;
    }

    public static EnumOS getOs() {
        String var0 = System.getProperty("os.name").toLowerCase();
        return var0.contains("win") ? EnumOS.WINDOWS : (var0.contains("mac") ? EnumOS.MACOS : (var0.contains("solaris") ? EnumOS.SOLARIS : (var0.contains("sunos") ? EnumOS.SOLARIS : (var0.contains("linux") ? EnumOS.LINUX : (var0.contains("unix") ? EnumOS.LINUX : EnumOS.UNKNOWN)))));
    }

    protected void saveData() {
        try {
            this.dataFile.createNewFile();
            if (this.dataFile.canWrite()) {
                FileOutputStream dataOutput = new FileOutputStream(this.dataFile);
                NBTTagCompound data = new NBTTagCompound();
                for (String s : this.visiblePages.keySet()) {
                    data.func_74774_a(s, this.visiblePages.get(s).byteValue());
                }
                CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)dataOutput);
                ((OutputStream)dataOutput).close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TropicalBook.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean hasRecipeList() {
        return false;
    }

    public boolean isPageVisible(String entry) {
        return this.visiblePages.containsKey(entry) && this.visiblePages.get(entry) > 0;
    }

    public boolean isPageVisible(int i) {
        return this.isPageVisible(this.getPageName(i));
    }

    public boolean hasPageBeenRead(String entry) {
        return this.visiblePages.containsKey(entry) && this.visiblePages.get(entry) > 1;
    }

    public boolean hasPageBeenRead(int i) {
        return this.hasPageBeenRead(this.getPageName(i));
    }

    public void markPageAsNewlyVisible(String entry) {
        this.visiblePages.put(entry, (byte)1);
        this.saveData();
    }

    public void markPageAsNewlyVisible(int i) {
        this.markPageAsNewlyVisible(this.getPageName(i));
    }

    public void markPageAsRead(String entry) {
        this.visiblePages.put(entry, (byte)2);
        this.saveData();
    }

    public void markPageAsRead(int i) {
        this.markPageAsRead(this.getPageName(i));
    }

    public boolean pageExists(String name) {
        return this.pageTitles.containsKey(name);
    }

    public abstract void updatePagesFromInventory(InventoryPlayer var1);

    public int getPageCount() {
        return this.sortedPages.size();
    }

    public int getContentPageCount(int page, ContentMode mode) {
        return 1;
    }

    public int entriesPerIndexPage() {
        return 12;
    }

    public int entriesPerContentPage(ContentMode mode) {
        return 1;
    }

    public boolean hasIndexIcons() {
        return false;
    }

    public ItemStack getPageItemStack(int page) {
        return null;
    }

    protected String getPageName(int i) {
        if (i >= 0 && i < this.sortedPages.size()) {
            return this.sortedPages.get(i);
        }
        return null;
    }

    public String getPageTitleNotVisible(int i) {
        return "Page not found";
    }

    private String getPageTitleByName(String name) {
        if (this.pageExists(name)) {
            return this.pageTitles.get(name);
        }
        return null;
    }

    public String getPageTitleByIndex(int i) {
        return this.getPageTitleByName(this.getPageName(i));
    }

    private String getPageDescriptionByName(String name) {
        if (this.pageExists(name)) {
            return this.pageDescriptions.get(name);
        }
        return null;
    }

    public String getPageDescriptionsByIndex(int i) {
        return this.getPageDescriptionByName(this.getPageName(i));
    }

    protected List<String> getSortedPages() {
        return this.sortedPages;
    }

    public static enum ContentMode {
        INFO,
        RECIPE;

    }
}

