/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.entities.ai.jobs.v3;

import CoroAI.PFQueue;
import CoroAI.componentAI.jobSystem.JobBase;
import CoroAI.componentAI.jobSystem.JobManager;
import CoroAI.entity.EnumJobState;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import tropicraft.entities.hostile.land.tribes.ashen.LostMask;

public class JobHuntAshen
extends JobBase {
    public long huntRange = 24L;
    public long keepDistantRange = 14L;
    public boolean xRay = false;
    public boolean useMelee = false;
    public int useMeleeCountdown = 0;
    public int useMeleeCountdownMax = 80;
    public Vec3 targetLastPos = null;
    public int targetNoMoveTicks = 0;
    public int targetNoMoveTicksMax = 4;
    public int panicTicks = 0;

    public JobHuntAshen(JobManager jm) {
        super(jm);
    }

    public boolean shouldExecute() {
        return true;
    }

    public boolean shouldContinue() {
        return this.ai.entityToAttack == null || this.ai.entityToAttack.func_70032_d((Entity)this.ent) > (float)this.huntRange;
    }

    public void onLowHealth() {
        if (this.ai.lastFleeEnt == null) {
            return;
        }
        super.onLowHealth();
        if (this.hitAndRunDelay == 0 && this.ent.func_70032_d(this.ai.lastFleeEnt) > 3.0f) {
            this.hitAndRunDelay = this.entInt.getCooldownRanged() + 1;
            this.ai.entityToAttack = this.ai.lastFleeEnt;
            if (this.ai.entityToAttack != null) {
                this.ent.func_70625_a(this.ai.entityToAttack, 180.0f, 180.0f);
                if (this.ai.useInv) {
                    this.ai.entInv.attackRanged(this.ai.entityToAttack, this.ent.func_70032_d(this.ai.lastFleeEnt));
                } else {
                    this.entInt.attackRanged(this.ai.entityToAttack, this.ent.func_70032_d(this.ai.lastFleeEnt));
                }
            }
        }
    }

    public boolean shouldTickCloseCombat() {
        if (!this.useMelee) {
            return false;
        }
        return super.shouldTickCloseCombat();
    }

    public boolean hookHit(DamageSource ds, int damage) {
        if (this.ent.func_70096_w().func_75679_c(16) != -1) {
            this.panicTicks = 40;
            LostMask mask = new LostMask(this.ent.field_70170_p, this.ent.func_70096_w().func_75679_c(16), this.ent.field_70165_t, this.ent.field_70163_u + 1.0, this.ent.field_70161_v, this.ent.field_70177_z);
            this.ent.func_70096_w().func_75692_b(16, (Object)-1);
            this.ent.field_70170_p.func_72838_d((Entity)mask);
        }
        return true;
    }

    public void setJobItems() {
    }

    public boolean checkDangers() {
        boolean returnVal = false;
        if (this.ent.func_70096_w().func_75679_c(16) == -1) {
            this.ai.entityToAttack = null;
            this.ent.func_70096_w().func_75692_b(17, (Object)1);
            returnVal = true;
        } else if (this.ai.entityToAttack != null) {
            this.ent.func_70096_w().func_75692_b(17, (Object)2);
        } else {
            this.ent.func_70096_w().func_75692_b(17, (Object)0);
        }
        if (!returnVal && !this.useMelee && this.ai.entityToAttack != null && this.ai.entityToAttack.func_70032_d((Entity)this.ai.ent) < (float)(this.keepDistantRange - 2L)) {
            returnVal = true;
        }
        if (!returnVal) {
            return this.checkHealth();
        }
        return true;
    }

    public boolean avoid(boolean actOnTrue) {
        int range = 25;
        boolean seesMask = false;
        LostMask clEnt = null;
        float closest = 9999.0f;
        if (this.panicTicks > 0) {
            --this.panicTicks;
        }
        if (this.ent.field_70170_p.func_72820_D() % 5L == 0L) {
            if (this.panicTicks <= 0) {
                List list = this.ent.field_70170_p.func_72872_a(LostMask.class, this.ent.field_70121_D.func_72314_b((double)range, (double)(range / 2), (double)range));
                for (int j = 0; j < list.size(); ++j) {
                    LostMask entity1 = (LostMask)((Object)list.get(j));
                    if (entity1.field_70128_L) continue;
                    seesMask = true;
                    float dist = this.ent.func_70032_d((Entity)entity1);
                    if (!(dist < closest)) continue;
                    closest = dist;
                    clEnt = entity1;
                }
            }
            if (seesMask) {
                if ((double)closest < 2.0) {
                    this.ent.func_70096_w().func_75692_b(16, (Object)clEnt.func_70096_w().func_75679_c(17));
                    clEnt.func_70106_y();
                } else if (this.ent.field_70170_p.func_72820_D() % 10L == 0L) {
                    PFQueue.getPath((Entity)this.ent, clEnt, (float)((float)range + 16.0f));
                }
                return true;
            }
            return super.avoid(actOnTrue);
        }
        return true;
    }

    public void tick() {
        super.tick();
        this.jobHunter();
    }

    protected void jobHunter() {
        this.dontStrayFromHome = false;
        this.ai.maxDistanceFromHome = 48.0;
        if (this.ai.entityToAttack != null && this.targetLastPos != null) {
            if (this.ent.field_70170_p.func_72820_D() % 10L == 0L) {
                this.targetNoMoveTicks = this.ai.entityToAttack.func_70011_f(this.targetLastPos.field_72450_a, this.targetLastPos.field_72448_b, this.targetLastPos.field_72449_c) < 0.5 ? ++this.targetNoMoveTicks : 0;
            }
            if (this.targetNoMoveTicks >= this.targetNoMoveTicksMax) {
                this.useMeleeCountdown = this.useMeleeCountdownMax;
            }
        } else {
            this.useMeleeCountdown = 0;
        }
        if (this.useMeleeCountdown > 0) {
            --this.useMeleeCountdown;
            this.useMelee = true;
        } else {
            this.useMelee = false;
        }
        this.setJobState(EnumJobState.IDLE);
        if (this.ent.func_110143_aJ() > this.ent.func_110143_aJ() * 0.9f && (this.ai.entityToAttack == null || this.ai.rand.nextInt(20) == 0)) {
            boolean found = false;
            Entity clEnt = null;
            float closest = 9999.0f;
            List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, this.ent.field_70121_D.func_72314_b((double)this.huntRange, (double)(this.huntRange / 2L), (double)this.huntRange));
            for (int j = 0; j < list.size(); ++j) {
                float dist;
                Entity entity1 = (Entity)list.get(j);
                if (!this.isEnemy(entity1) || !this.xRay && !((EntityLivingBase)entity1).func_70685_l((Entity)this.ent) || !this.sanityCheck(entity1) || !((dist = this.ent.func_70032_d(entity1)) < closest)) continue;
                closest = dist;
                clEnt = entity1;
            }
            if (clEnt != null) {
                if (this.ai.entityToAttack != clEnt) {
                    this.ai.setTarget(clEnt);
                } else {
                    this.ai.setTarget(clEnt);
                }
            }
        } else if (this.ai.entityToAttack != null) {
            if (!this.useMelee && this.ai.entityToAttack.func_70032_d((Entity)this.ent) < (float)this.keepDistantRange) {
                this.ent.func_70661_as().func_75499_g();
            }
            if (this.ent.func_70661_as().func_75500_f() && (this.ent.func_70032_d(this.ai.entityToAttack) > (float)(this.keepDistantRange + 1L) || this.useMelee)) {
                PFQueue.getPath((Entity)this.ent, (Entity)this.ai.entityToAttack, (float)this.ai.maxPFRange);
            } else if (!this.useMelee && !this.ai.fleeing && this.ai.entityToAttack.func_70032_d((Entity)this.ent) < (float)this.keepDistantRange) {
                this.ent.func_70661_as().func_75499_g();
            }
        }
        if (this.ent.field_70170_p.func_72820_D() % 10L == 0L && this.ai.entityToAttack != null) {
            this.targetLastPos = Vec3.func_72443_a((double)this.ai.entityToAttack.field_70165_t, (double)this.ai.entityToAttack.field_70163_u, (double)this.ai.entityToAttack.field_70161_v);
        }
        this.ent.field_70735_aL = this.ent.func_110143_aJ();
    }

    public boolean sanityCheckHelp(Entity caller, Entity target) {
        if (this.ent.func_110143_aJ() < 10.0f) {
            return false;
        }
        if (this.dontStrayFromHome && target.func_70011_f((double)this.ai.homeX, (double)this.ai.homeY, (double)this.ai.homeZ) > this.ai.maxDistanceFromHome * 1.5) {
            return false;
        }
        return this.ai.rand.nextInt(2) == 0;
    }

    public boolean sanityCheck(Entity target) {
        if (this.ent.func_110143_aJ() < 6.0f) {
            return false;
        }
        return !this.dontStrayFromHome || !(target.func_70011_f((double)this.ai.homeX, (double)this.ai.homeY, (double)this.ai.homeZ) > this.ai.maxDistanceFromHome);
    }
}

