/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.packets;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import tropicraft.TickHandlerClient;
import tropicraft.Tropicraft;
import tropicraft.ai.WorldDirector;

public class TropicraftPacketHandler
implements IPacketHandler {
    @SideOnly(value=Side.CLIENT)
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        if (packet.field_73630_a.equals("SnareTrap")) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
            try {
                boolean clearFirst = dis.readBoolean();
                boolean adding = dis.readBoolean();
                int length = dis.readShort();
                Set<String> upsideDownUsernames = Tropicraft.proxy.getUpsideDownUsernames();
                if (clearFirst) {
                    upsideDownUsernames.clear();
                }
                for (int i = 0; i < length; ++i) {
                    String username = dis.readUTF();
                    if (adding) {
                        upsideDownUsernames.add(username);
                        continue;
                    }
                    upsideDownUsernames.remove(username);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if ("QuestData".equals(packet.field_73630_a)) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
            try {
                NBTTagCompound nbt = Packet.func_73283_d((DataInput)dis);
                TickHandlerClient.playerQuests.syncFromServer(nbt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if ("PagesData".equals(packet.field_73630_a)) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
            try {
                TickHandlerClient.pagesCollected = Packet.func_73283_d((DataInput)dis);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Packet getSnareTrapPacket(boolean clearFirst, boolean adding, Set<String> usernames) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeBoolean(clearFirst);
            dos.writeBoolean(adding);
            dos.writeShort(usernames.size());
            for (String username : usernames) {
                dos.writeUTF(username);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload pkt = new Packet250CustomPayload();
        pkt.field_73630_a = "SnareTrap";
        pkt.field_73629_c = bos.toByteArray();
        pkt.field_73628_b = bos.size();
        pkt.field_73287_r = true;
        return pkt;
    }

    public static void syncPagesData(String username) {
        NBTTagCompound nbt;
        Tropicraft.dbg("syncing pagesData to " + username);
        if (MinecraftServer.func_71276_C() != null && (nbt = WorldDirector.getPlayerNBT(username).func_74775_l("pagesData")) != null) {
            try {
                byte[] data = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(8 * data.length + 16);
                DataOutputStream dos = new DataOutputStream(bos);
                TropicraftPacketHandler.writeNBTTagCompound(nbt, dos, data);
                Packet250CustomPayload pkt = new Packet250CustomPayload();
                pkt.field_73630_a = "PagesData";
                pkt.field_73629_c = bos.toByteArray();
                pkt.field_73628_b = bos.size();
                MinecraftServer.func_71276_C().func_71203_ab().func_72361_f((String)username).field_71135_a.func_72567_b((Packet)pkt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, DataOutputStream par1DataOutputStream, byte[] data) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            par1DataOutputStream.writeShort((short)data.length);
            par1DataOutputStream.write(data);
        }
    }
}

