/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.structures;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.structures.KoaVillage;

public abstract class KoaVillageComponent {
    protected static final List<Integer> waterBlockIDs = Arrays.asList(Block.field_71942_A.field_71990_ca, Block.field_71943_B.field_71990_ca, TropicraftBlocks.tropicsWaterFlowing.field_71990_ca, TropicraftBlocks.tropicsWaterStationary.field_71990_ca);
    protected int homeX;
    protected int homeY;
    protected int homeZ;
    protected int genX;
    protected int genY;
    protected int genZ;
    protected int genDirection = -1;
    protected KoaVillage village;
    protected StructureBoundingBox boundingBox;

    public abstract boolean canFitInWorld(World var1);

    public abstract void generate(World var1);

    public abstract void spawn(World var1);

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    protected void place(World world, int x, int y, int z, Block b) {
        world.func_94575_c(x, y, z, b.field_71990_ca);
    }

    protected void place(World world, int i, int j, int k, Block block, int meta) {
        this.placeWithMetadata(world, i, j, k, block, meta);
    }

    protected void placeDownTilGround(World world, int x, int y, int z, Block block1) {
        while (waterBlockIDs.contains(world.func_72798_a(x, y, z)) || world.func_72798_a(x, y, z) == 0 && y > 0) {
            this.place(world, x, y, z, block1);
            --y;
        }
    }

    protected void placeWithMetadata(World world, int i, int j, int k, Block block, int meta) {
        world.func_72832_d(i, j, k, block.field_71990_ca, meta, 3);
    }

    protected void place(World world, int i, int j, int k, int l) {
        world.func_94575_c(i, j, k, l);
    }

    protected void placeBlockInAdjacentAirWithRadius(World world, int i2, int j2, int k2, int r1, int r2, Block blockgold) {
        for (int a = r1; a < r2; ++a) {
            int[] asdf = new int[3];
            if (world.func_72798_a(i2 + a, j2, k2) == 0) {
                asdf[0] = i2 + a;
                asdf[1] = j2;
                asdf[2] = k2;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.func_72798_a(i2 - a, j2, k2) == 0) {
                asdf[0] = i2 - a;
                asdf[1] = j2;
                asdf[2] = k2;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.func_72798_a(i2 + a, j2, k2 + a) == 0) {
                asdf[0] = i2 + a;
                asdf[1] = j2;
                asdf[2] = k2 + a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.func_72798_a(i2 - a, j2, k2 - a) == 0) {
                asdf[0] = i2 - a;
                asdf[1] = j2;
                asdf[2] = k2 - a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.func_72798_a(i2, j2, k2 + a) == 0) {
                asdf[0] = i2;
                asdf[1] = j2;
                asdf[2] = k2 + a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.func_72798_a(i2, j2, k2 - a) == 0) {
                asdf[0] = i2;
                asdf[1] = j2;
                asdf[2] = k2 - a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.func_72798_a(i2 - a, j2, k2 + a) == 0) {
                asdf[0] = i2 - a;
                asdf[1] = j2;
                asdf[2] = k2 + a;
                this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
            }
            if (world.func_72798_a(i2 + a, j2, k2 - a) != 0) continue;
            asdf[0] = i2 + a;
            asdf[1] = j2;
            asdf[2] = k2 - a;
            this.place(world, asdf[0], asdf[1], asdf[2], blockgold);
        }
    }
}

