/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.entities.ai.jobs;

import CoroAI.c_CoroAIUtil;
import CoroAI.entity.EnumJobState;
import CoroAI.entity.JobBase;
import CoroAI.entity.JobManager;
import CoroAI.entity.c_PlayerProxy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.blocks.tileentities.TileEntityPurchasePlate;
import tropicraft.economy.ItemEntry;
import tropicraft.economy.ItemValueEntries;
import tropicraft.economy.ItemValues;

public class JobTrade
extends JobBase {
    public float tradeDistTrigger;
    public int tradeLastItemOffer;
    public ChunkCoordinates tradeBlockPos;
    public ChunkCoordinates frameBlockPos;
    public TileEntityPurchasePlate tradePlate;
    public EntityPlayer activeTrader;
    public ArrayList<ItemStack> offeredItems = new ArrayList();
    public int idTradeBlock;

    public JobTrade(JobManager jm) {
        super(jm);
    }

    public boolean interact(EntityPlayer ent) {
        ItemStack is;
        if (this.offeredItems == null) {
            this.offeredItems = new ArrayList();
        }
        if ((is = ent.func_71045_bC()) != null && ItemValues.getItemEntry(is) != null) {
            ent.field_71071_by.field_70462_a[ent.field_71071_by.field_70461_c] = null;
            this.offeredItems.add(is);
            if (this.tradePlate != null) {
                this.tradePlate.credit = this.getOfferedItemsValue();
                MinecraftServer.func_71276_C().func_71203_ab().func_72384_a(this.tradePlate.func_70319_e());
            }
        }
        return false;
    }

    public void convertOfferingsToCurrency(int newCredit) {
        int leftToConvert;
        this.offeredItems.clear();
        for (leftToConvert = newCredit; leftToConvert > ItemValueEntries.currency.func_77976_d(); leftToConvert -= ItemValueEntries.currency.func_77976_d()) {
            this.offeredItems.add(new ItemStack(ItemValueEntries.currency.func_77973_b(), ItemValueEntries.currency.func_77976_d()));
        }
        if (leftToConvert > 0) {
            this.offeredItems.add(new ItemStack(ItemValueEntries.currency.func_77973_b(), leftToConvert));
        }
    }

    public int getOfferedItemsValue() {
        int value = 0;
        try {
            for (int i = 0; i < this.offeredItems.size(); ++i) {
                value += ItemValues.getItemEntry(this.offeredItems.get(i)).getTotalValue(this.offeredItems.get(i));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public int returnCredit() {
        int value = 0;
        try {
            for (int i = 0; i < this.offeredItems.size(); ++i) {
                this.activeTrader.field_71071_by.func_70441_a(this.offeredItems.get(i));
            }
            this.offeredItems.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public void tick() {
        if (this.ent != null && this.ent.func_110143_aJ() == 20.0f) {
            this.ent.setHealth(80);
        }
        this.idTradeBlock = TropicraftBlocks.tradeBlock.field_71990_ca;
        this.ent.maxDistanceFromHome = 0.5;
        this.tradeDistTrigger = 4.0f;
        if (this.tradeBlockPos == null) {
            TileEntity tile;
            this.tradeBlockPos = this.tickFind(this.idTradeBlock, 7);
            if (this.tradeBlockPos != null && (tile = this.ent.field_70170_p.func_72796_p(this.tradeBlockPos.field_71574_a, this.tradeBlockPos.field_71572_b, this.tradeBlockPos.field_71573_c)) != null) {
                this.tradePlate = (TileEntityPurchasePlate)tile;
            }
        } else if (this.frameBlockPos == null) {
            List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, this.ent.field_70121_D.func_72314_b(6.0, 3.0, 6.0));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity1 = (Entity)list.get(j);
                if (!(entity1 instanceof EntityItemFrame) || ((EntityItemFrame)entity1).func_82335_i() != null) continue;
                ((EntityItemFrame)entity1).func_82334_a(ItemValues.itemsBuyable.get((int)this.ent.field_70170_p.field_73012_v.nextInt((int)ItemValues.itemsBuyable.size())).item);
            }
        }
        if (this.activeTrader == null) {
            this.activeTrader = this.ent.field_70170_p.func_72890_a((Entity)this.ent, (double)this.tradeDistTrigger);
            if (this.activeTrader != null) {
                this.tradeStart();
            }
        } else if ((double)this.ent.func_70032_d((Entity)this.activeTrader) > (double)this.tradeDistTrigger * 1.5) {
            this.tradeReset();
        } else {
            this.tradeTick();
        }
    }

    public void tradeStart() {
        if (this.tradePlate != null) {
            this.tradePlate.tradeState = 1;
            this.tradePlate.credit = this.getOfferedItemsValue();
        }
    }

    public void tradeConfirmCallback() {
        int credit = this.getOfferedItemsValue();
        ItemEntry ie = ItemValues.itemsBuyable.get(this.tradePlate.itemIndex);
        int cost = ie.value;
        if (credit >= cost) {
            this.convertOfferingsToCurrency(credit -= cost);
            ItemStack is = ie.item.func_77946_l();
            this.activeTrader.field_71071_by.func_70441_a(is);
        }
        this.tradeSuccess();
    }

    public void tradeSuccess() {
        if (this.tradePlate != null) {
            this.tradePlate.tradeState = 1;
            this.tradePlate.credit = this.getOfferedItemsValue();
        }
    }

    public void tradeReset() {
        if (this.offeredItems != null) {
            this.returnCredit();
        }
        this.activeTrader = null;
        if (this.tradePlate != null) {
            this.tradePlate.tradeState = 0;
            this.tradePlate.credit = 0;
            this.tradePlate.activeTrader = null;
        }
        System.out.println("trade reset");
    }

    public void tradeTick() {
        TileEntity tEnt = null;
        if (this.tradeBlockPos != null) {
            tEnt = this.ent.field_70170_p.func_72796_p(this.tradeBlockPos.field_71574_a, this.tradeBlockPos.field_71572_b, this.tradeBlockPos.field_71573_c);
        }
        if (this.tradeBlockPos != null && tEnt == null) {
            this.tradeBlockPos = null;
        } else if (tEnt instanceof TileEntityPurchasePlate) {
            ((TileEntityPurchasePlate)tEnt).activeTrader = this.activeTrader;
        }
    }

    public void setJobItems() {
        c_CoroAIUtil.setItems_JobTrade((c_PlayerProxy)this.ent);
    }

    public ChunkCoordinates tickFind(int id, int range) {
        int randZ;
        int randY;
        int randX = (int)this.ent.field_70165_t + this.ent.field_70146_Z.nextInt(range) - range / 2;
        int foundID = this.ent.field_70170_p.func_72798_a(randX, randY = (int)this.ent.field_70163_u + this.ent.field_70146_Z.nextInt(range) - range / 2, randZ = (int)this.ent.field_70161_v + this.ent.field_70146_Z.nextInt(range) - range / 2);
        if (foundID == id) {
            System.out.println("found trade block");
            return new ChunkCoordinates(randX, randY, randZ);
        }
        return null;
    }

    public boolean shouldExecute() {
        return this.isAreaSecure();
    }

    public boolean shouldContinue() {
        return !this.isAreaSecure();
    }

    public boolean isAreaSecure() {
        if (this.tradeBlockPos != null) {
            List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, AxisAlignedBB.func_72330_a((double)this.tradeBlockPos.field_71574_a, (double)this.tradeBlockPos.field_71572_b, (double)this.tradeBlockPos.field_71573_c, (double)this.tradeBlockPos.field_71574_a, (double)this.tradeBlockPos.field_71572_b, (double)this.tradeBlockPos.field_71573_c).func_72314_b(6.0, 3.0, 6.0));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity1 = (Entity)list.get(j);
                if (!this.ent.isEnemy(entity1)) continue;
                return false;
            }
        }
        return true;
    }

    public void onIdleTick() {
        if (this.ent.func_70661_as().func_75500_f()) {
            if (this.activeTrader != null) {
                this.ent.func_70625_a((Entity)this.activeTrader, 15.0f, 15.0f);
            } else if (this.tradeBlockPos != null) {
                this.ent.faceCoord(this.tradeBlockPos.field_71574_a, this.tradeBlockPos.field_71572_b, this.tradeBlockPos.field_71573_c, 15.0f, 15.0f);
            }
            if (this.ent.func_70011_f((double)this.ent.homeX, (double)this.ent.homeY, (double)this.ent.homeZ) > this.ent.maxDistanceFromHome) {
                int randsize = 4;
                this.ent.walkTo((Entity)this.ent, this.ent.homeX, this.ent.homeY, this.ent.homeZ, (float)this.ent.maxPFRange, 600);
            } else if (this.ent.field_70170_p.field_73012_v.nextInt(10) == 0) {
                int randsize = 2;
                this.ent.walkTo((Entity)this.ent, this.ent.homeX + this.ent.field_70146_Z.nextInt(randsize) - randsize / 2, this.ent.homeY + 0, this.ent.homeZ + this.ent.field_70146_Z.nextInt(randsize) - randsize / 2, (float)this.ent.maxPFRange, 600);
            }
        }
    }

    protected void jobTrading() {
        EntityPlayer entP = this.ent.field_70170_p.func_72890_a((Entity)this.ent, 16.0);
        int pX = (int)(entP.field_70165_t - 0.5);
        int pY = (int)entP.field_70163_u;
        int pZ = (int)(entP.field_70161_v - 0.5);
        if (this.ent.func_70032_d((Entity)entP) > this.tradeDistTrigger) {
            this.tradeTimeout = 600;
            this.ent.swapJob(this.jm.priJob);
        }
        if (this.state == EnumJobState.IDLE) {
            this.ent.walkTo((Entity)this.ent, pX, pY, pZ, (float)this.ent.maxPFRange, 600);
            this.setJobState(EnumJobState.W1);
        } else if (this.state == EnumJobState.W1) {
            if (this.ent.func_70032_d((Entity)entP) <= 2.0f) {
                this.ent.setPathExToEntity(null);
                this.ent.func_70625_a((Entity)entP, 30.0f, 30.0f);
                int itemSlot = this.getRandomTradeItemSlot();
                this.ent.setCurrentSlot(itemSlot);
                this.setJobState(EnumJobState.W2);
            } else if (this.walkingTimeout > 0 && !this.ent.func_70781_l()) {
                // empty if block
            }
        } else if (this.state == EnumJobState.W2) {
            if (this.ent.inventory.field_70461_c == 0) {
                this.ent.setCurrentSlot(this.getRandomTradeItemSlot());
            }
            if (entP.func_71045_bC() != null && this.tradeLastItemOffer != entP.func_71045_bC().field_77993_c) {
                Item tryItem = entP.func_71045_bC().func_77973_b();
                this.tradeLastItemOffer = entP.func_71045_bC().field_77993_c;
            }
            this.ent.func_70625_a((Entity)entP, 10.0f, 10.0f);
        }
    }

    protected int getRandomTradeItemSlot() {
        this.ent.activeTradeItemSlot = this.ent.slot_Trade - this.ent.field_70146_Z.nextInt(3);
        return this.ent.activeTradeItemSlot;
    }

    public void koaTrade(EntityPlayer ep) {
        ItemStack itemPlayer = ep.func_71045_bC();
        ItemStack itemKoa = this.ent.getCurrentEquippedItem();
        if (itemKoa == null || itemPlayer == null) {
            return;
        }
        if (itemPlayer.func_77985_e() && itemPlayer.field_77994_a > 0) {
            --itemPlayer.field_77994_a;
        }
        if (itemPlayer.field_77994_a <= 0 || !itemPlayer.func_77985_e()) {
            ep.field_71071_by.field_70462_a[ep.field_71071_by.field_70461_c] = null;
        }
        ep.field_71071_by.func_70441_a(itemKoa);
        this.ent.inventory.func_70441_a(itemPlayer);
        this.ent.swapJob(this.ent.job.priJob);
        this.tradeTimeout = 12000;
    }
}

