/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.entities.placeable;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tropicraft.Tropicraft;
import tropicraft.entities.projectiles.EntityDartHelper;
import tropicraft.items.TropicraftItems;
import tropicraft.packets.TropicraftPacketHandler;

public class EntitySnareTrap
extends Entity
implements IEntityAdditionalSpawnData {
    private static final int FULL_ID = 16;
    private static final int USERNAME_ID = 17;
    private static final int ENTITY_HEIGHT_ID = 18;
    public static final int MIN_HEIGHT = 3;
    public static final int MAX_HEIGHT = 6;
    public static final int SCAN_INTERVAL = 5;
    public EntityLivingBase caughtEntity;
    private EntityAITasks caughtEntityAITasks;
    private float caughtEntityMoveSpeed;
    public int hookBlockId;
    public int bottomBlockId;
    public int trapPosX;
    public int trapPosY;
    public int trapPosZ;
    public int trapHeight;
    public ForgeDirection trapDirection;
    private boolean prevFull;
    private int scanCoolDown = 5;

    public EntitySnareTrap(World par1World) {
        super(par1World);
        this.field_70158_ak = true;
        this.field_70156_m = true;
    }

    public EntitySnareTrap(World world, int x, int y, int z, int height, ForgeDirection dir) {
        this(world);
        this.trapPosX = x;
        this.trapPosY = y;
        this.trapPosZ = z;
        this.trapHeight = height;
        this.trapDirection = dir;
        this.func_70105_a(0.6f, (float)height - 0.5f);
        this.func_70012_b((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        this.hookBlockId = this.field_70170_p.func_72798_a(x - dir.offsetX, y + height - 1, z - dir.offsetZ);
        this.bottomBlockId = this.field_70170_p.func_72798_a(x, y - 1, z);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            boolean newFull = this.getFull();
            if (this.prevFull != newFull) {
                this.prevFull = newFull;
                if (newFull) {
                    this.func_70105_a(0.6f, (float)this.trapHeight - this.getEntityHeight() - 0.5f);
                } else {
                    this.func_70105_a(0.6f, (float)this.trapHeight - 0.5f);
                }
                this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            }
            EntityPlayer player = Tropicraft.proxy.getClientPlayer();
            if (this.getUsername().equals(player.field_71092_bJ)) {
                player.func_70012_b((double)this.trapPosX + 0.5, (double)this.trapPosY, (double)this.trapPosZ + 0.5, player.field_70177_z, player.field_70125_A);
            }
            return;
        }
        if (this.caughtEntity == null) {
            --this.scanCoolDown;
            if (this.scanCoolDown == 0) {
                this.scanCoolDown = 5;
                List ents = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(5.0, 5.0, 5.0));
                for (Object obj : ents) {
                    Entity ent = (Entity)obj;
                    if (!(ent instanceof EntityLiving) || !((EntityLiving)ent).func_70089_S() || !(ent.field_70165_t >= (double)this.trapPosX) || !(ent.field_70165_t <= (double)(this.trapPosX + 1)) || !(ent.field_70161_v >= (double)this.trapPosZ) || !(ent.field_70161_v <= (double)(this.trapPosZ + 1)) || !(Math.abs((double)this.trapPosY - ent.field_70163_u) < 0.01)) continue;
                    boolean alreadyTrapped = false;
                    for (Object trapObj : ents) {
                        if (!(trapObj instanceof EntitySnareTrap)) continue;
                        EntitySnareTrap trap = (EntitySnareTrap)((Object)trapObj);
                        if (trap.caughtEntity != ent) continue;
                        alreadyTrapped = true;
                        break;
                    }
                    if (alreadyTrapped) continue;
                    this.catchEntity((EntityLivingBase)((EntityLiving)ent));
                }
            }
        } else if (!this.caughtEntity.func_70089_S()) {
            this.releaseEntity();
        } else {
            this.caughtEntity.func_70012_b((double)this.trapPosX + 0.5, (double)this.trapPosY, (double)this.trapPosZ + 0.5, this.caughtEntity.field_70177_z, this.caughtEntity.field_70125_A);
            this.caughtEntity.field_70159_w = 0.0;
            this.caughtEntity.field_70181_x = 0.0;
            this.caughtEntity.field_70179_y = 0.0;
        }
        if (this.field_70170_p.func_72798_a(this.trapPosX - this.trapDirection.offsetX, this.trapPosY + this.trapHeight - 1, this.trapPosZ - this.trapDirection.offsetZ) != this.hookBlockId || this.field_70170_p.func_72798_a(this.trapPosX, this.trapPosY - 1, this.trapPosZ) != this.bottomBlockId) {
            if (this.caughtEntity != null) {
                this.releaseEntity();
            }
            this.func_70025_b(TropicraftItems.snareTrap.field_77779_bT, 1);
            this.func_70106_y();
        }
    }

    public void catchEntity(EntityLivingBase ent) {
        this.caughtEntity = ent;
        this.setFull(true);
        this.setEntityHeight(ent.field_70131_O + ent.field_70129_M);
        this.field_70170_p.func_72956_a((Entity)this, "random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f));
        this.func_70105_a(0.6f, (float)this.trapHeight - ent.field_70131_O - ent.field_70129_M - 0.5f);
        this.func_70012_b((double)this.trapPosX + 0.5, (float)this.trapPosY + ent.field_70131_O + ent.field_70129_M, (double)this.trapPosZ + 0.5, 0.0f, 0.0f);
        if (ent instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ent;
            this.setUsername(player.field_71092_bJ);
            PacketDispatcher.sendPacketToAllPlayers((Packet)TropicraftPacketHandler.getSnareTrapPacket(false, true, Collections.singleton(player.field_71092_bJ)));
            Tropicraft.proxy.getUpsideDownUsernames().add(player.field_71092_bJ);
        } else if (ent instanceof EntityLiving) {
            this.caughtEntityMoveSpeed = EntityDartHelper.getEntityMoveSpeed(ent);
            this.caughtEntityAITasks = EntityDartHelper.getEntityAITasks((EntityLiving)ent);
            EntityDartHelper.setEntityAITasks(ent, null);
            EntityDartHelper.setEntityMoveSpeed(ent, 0.0f);
            EntityDartHelper.setIsEntityJumping(ent, false);
            if (ent instanceof EntityCreature) {
                EntityDartHelper.setEntityToAttack((EntityCreature)ent, null);
            }
            if (ent instanceof EntityCreeper) {
                EntityDartHelper.setCreeperIgnitionTime((EntityCreeper)ent, 0);
            }
        }
    }

    public void releaseEntity() {
        this.scanCoolDown = 5;
        this.setFull(false);
        this.setUsername("");
        this.func_70105_a(0.6f, (float)this.trapHeight - 0.5f);
        this.func_70012_b((double)this.trapPosX + 0.5, this.trapPosY, (double)this.trapPosZ + 0.5, 0.0f, 0.0f);
        if (this.caughtEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.caughtEntity;
            PacketDispatcher.sendPacketToAllPlayers((Packet)TropicraftPacketHandler.getSnareTrapPacket(false, false, Collections.singleton(player.field_71092_bJ)));
            Tropicraft.proxy.getUpsideDownUsernames().remove(player.field_71092_bJ);
        } else {
            EntityDartHelper.setEntityMoveSpeed(this.caughtEntity, this.caughtEntityMoveSpeed);
            EntityDartHelper.setEntityAITasks(this.caughtEntity, this.caughtEntityAITasks);
            this.caughtEntityAITasks = null;
        }
        this.caughtEntity = null;
    }

    public boolean func_70097_a(DamageSource source, float dmg) {
        Entity sourceEnt;
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        this.field_70170_p.func_72956_a((Entity)this, "note.harp", 1.0f, 2.0f - this.field_70146_Z.nextFloat() / 2.0f);
        if (this.caughtEntity != null && source.func_76346_g() == this.caughtEntity && this.field_70146_Z.nextFloat() > 0.1f) {
            return false;
        }
        if (this.caughtEntity != null) {
            this.releaseEntity();
        }
        if (!((sourceEnt = source.func_76346_g()) instanceof EntityPlayer) || !((EntityPlayer)sourceEnt).field_71075_bZ.field_75098_d) {
            this.func_70025_b(TropicraftItems.snareTrap.field_77779_bT, 1);
        }
        this.func_70106_y();
        return true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)"");
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void setEntityHeight(float height) {
        this.field_70180_af.func_75692_b(18, (Object)((int)(height * 100.0f)));
    }

    public float getEntityHeight() {
        return (float)this.field_70180_af.func_75679_c(18) / 100.0f;
    }

    public void setUsername(String username) {
        this.field_70180_af.func_75692_b(17, (Object)username);
    }

    public String getUsername() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setFull(boolean full) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(full ? 1 : 0)));
    }

    public boolean getFull() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.trapHeight = var1.func_74762_e("Height");
        this.trapDirection = ForgeDirection.getOrientation((int)var1.func_74771_c("Direction"));
        this.trapPosX = var1.func_74762_e("XPos");
        this.trapPosY = var1.func_74762_e("YPos");
        this.trapPosZ = var1.func_74762_e("ZPos");
        this.hookBlockId = var1.func_74765_d("HookBlockID");
        this.bottomBlockId = var1.func_74765_d("BottomBlockID");
    }

    protected void func_70014_b(NBTTagCompound var1) {
        var1.func_74768_a("Height", this.trapHeight);
        var1.func_74774_a("Direction", (byte)this.trapDirection.ordinal());
        var1.func_74768_a("XPos", this.trapPosX);
        var1.func_74768_a("YPos", this.trapPosY);
        var1.func_74768_a("ZPos", this.trapPosZ);
        var1.func_74777_a("HookBlockID", (short)this.hookBlockId);
        var1.func_74777_a("BottomBlockID", (short)this.bottomBlockId);
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.trapPosX);
        data.writeInt(this.trapPosY);
        data.writeInt(this.trapPosZ);
        data.writeInt(this.trapHeight);
        data.writeByte(this.trapDirection.ordinal());
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.trapPosX = data.readInt();
        this.trapPosY = data.readInt();
        this.trapPosZ = data.readInt();
        this.trapHeight = data.readInt();
        this.trapDirection = ForgeDirection.getOrientation((int)data.readByte());
        this.func_70105_a(0.6f, (float)this.trapHeight - 0.5f);
        this.func_70012_b((double)this.trapPosX + 0.5, this.trapPosY, (double)this.trapPosZ + 0.5, 0.0f, 0.0f);
    }
}

