/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.volleyball;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import tropicraft.volleyball.Game;

public class Court {
    public double minX;
    public double minZ;
    public double maxX;
    public double maxZ;
    public double y;
    public double xLength;
    public double zLength;
    private Game currentGame = new Game(this);
    private static final double borderWeight = 1.2;
    private AxisAlignedBB team1Bounds;
    private AxisAlignedBB team2Bounds;

    public void initTeamBounds() {
        if (this.xLength >= this.zLength) {
            this.team1Bounds = AxisAlignedBB.func_72330_a((double)this.minX, (double)(this.y - 1.0), (double)this.minZ, (double)((double)MathHelper.func_76128_c((double)((this.maxX - this.minX) / 2.0)) + this.minX), (double)(this.y + 5.0), (double)this.maxZ);
            this.team2Bounds = AxisAlignedBB.func_72330_a((double)((double)(MathHelper.func_76128_c((double)((this.maxX - this.minX) / 2.0)) + 1) + this.minX), (double)(this.y - 1.0), (double)this.minZ, (double)this.maxX, (double)(this.y + 5.0), (double)this.maxZ);
        } else {
            this.team1Bounds = AxisAlignedBB.func_72330_a((double)this.minX, (double)(this.y - 1.0), (double)this.minZ, (double)this.maxX, (double)(this.y + 5.0), (double)((double)MathHelper.func_76128_c((double)((this.maxZ - this.minZ) / 2.0)) + this.minZ));
            this.team2Bounds = AxisAlignedBB.func_72330_a((double)this.minX, (double)(this.y - 1.0), (double)((double)(MathHelper.func_76128_c((double)((this.maxZ - this.minZ) / 2.0)) + 1) + this.minX), (double)this.maxX, (double)(this.y + 5.0), (double)this.maxZ);
        }
    }

    public Game getCurrentGame() {
        return this.currentGame;
    }

    public boolean isValidSize() {
        return true;
    }

    public int maxPlayersPerTeam() {
        int areaOfSide = (int)(this.xLength > this.zLength ? (double)(MathHelper.func_76128_c((double)(this.xLength / 2.0)) - 1) * (this.zLength - 2.0) : (double)(MathHelper.func_76128_c((double)(this.zLength / 2.0)) - 1) * (this.xLength - 2.0));
        return MathHelper.func_76128_c((double)(areaOfSide / 2));
    }

    public int getSideOfCourt(EntityPlayer player) {
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        if (this.team1Bounds == null || this.team2Bounds == null) {
            this.initTeamBounds();
        }
        System.out.printf("%f %f %f %f %f %f\n", this.team1Bounds.field_72340_a, this.team1Bounds.field_72339_c, this.team1Bounds.field_72336_d, this.team1Bounds.field_72334_f, this.team1Bounds.field_72338_b, this.team1Bounds.field_72337_e);
        System.out.printf("%f %f %f\n", player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (x >= this.team1Bounds.field_72340_a && z >= this.team1Bounds.field_72339_c && x <= this.team1Bounds.field_72336_d && z <= this.team1Bounds.field_72334_f && y >= this.team1Bounds.field_72338_b && y <= this.team1Bounds.field_72337_e) {
            return 1;
        }
        return 2;
    }

    private boolean isPlayerInCourtBounds(EntityPlayer player) {
        return player.field_70165_t >= this.minX - 1.2 && player.field_70165_t <= this.minX + 1.2 && player.field_70161_v >= this.minZ - 1.2 && player.field_70161_v <= this.maxZ + 1.2;
    }

    public void saveGame(NBTTagCompound nbt) {
        this.currentGame.saveGame(nbt);
    }

    public void loadGame(NBTTagCompound nbt) {
        this.currentGame = new Game(this);
        this.currentGame.loadGame(nbt);
    }

    public void onClick(EntityPlayer player) {
        System.out.println("yas" + this.currentGame.hasPlayerJoined(player));
        if (!this.currentGame.hasPlayerJoined(player)) {
            this.currentGame.joinGame(player);
        } else {
            this.currentGame.startGame();
        }
    }
}

