/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.teleporter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.PortalPosition;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.blocks.tileentities.TileEntityBambooChest;
import tropicraft.items.TropicraftItems;
import tropicraft.world.WorldProviderTropicraft;

public class TeleporterTropics
extends Teleporter {
    private int portalBlockID;
    private int portalWallID;
    private static final List<Integer> validBlockIDs = Arrays.asList(Block.field_71939_E.field_71990_ca, TropicraftBlocks.purifiedSand.field_71990_ca, Block.field_71980_u.field_71990_ca, Block.field_71979_v.field_71990_ca);
    private WorldServer world;
    private final LongHashMap field_85191_c;
    private final List field_85190_d;

    public TeleporterTropics(WorldServer world) {
        super(world);
        this.portalBlockID = TropicraftBlocks.portal.field_71990_ca;
        this.portalWallID = TropicraftBlocks.portalWall.field_71990_ca;
        this.field_85191_c = new LongHashMap();
        this.field_85190_d = new ArrayList();
        this.world = world;
    }

    public void func_77185_a(Entity entity, double d, double d2, double d3, float f) {
        long startTime = System.currentTimeMillis();
        if (!this.func_77184_b(entity, d, d2, d3, f)) {
            this.func_85188_a(entity);
            this.func_77184_b(entity, d, d2, d3, f);
        }
        long finishTime = System.currentTimeMillis();
        System.out.printf("It took %f seconds for TeleporterTropics.placeInPortal to complete", Float.valueOf((float)(finishTime - startTime) / 1000.0f));
    }

    public boolean func_77184_b(Entity entity, double d, double d2, double d3, float f) {
        int searchArea = 128;
        double closestPortal = -1.0;
        int foundX = 0;
        int foundY = 0;
        int foundZ = 0;
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        boolean notInCache = true;
        long j1 = ChunkCoordIntPair.func_77272_a((int)entityX, (int)entityZ);
        entityX = 512 * Math.round(entityX / 512);
        entityZ = 512 * Math.round(entityZ / 512);
        if (this.field_85191_c.func_76161_b(j1)) {
            if (this.field_85191_c.func_76161_b(j1)) {
                PortalPosition portalposition = (PortalPosition)this.field_85191_c.func_76164_a(j1);
                d3 = 0.0;
                foundX = portalposition.field_71574_a;
                foundY = portalposition.field_71572_b;
                foundZ = portalposition.field_71573_c;
                portalposition.field_85087_d = this.world.func_82737_E();
                notInCache = false;
            }
        } else {
            for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
                double distX = (double)x + 0.5 - entity.field_70165_t;
                for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                    double distZ = (double)z + 0.5 - entity.field_70161_v;
                    for (int y = this.world.func_72800_K() - 1; y >= 0; --y) {
                        if (this.world.func_72798_a(x, y, z) != this.portalBlockID) continue;
                        while (this.world.func_72798_a(x, y - 1, z) == this.portalBlockID) {
                            --y;
                        }
                        double distY = (double)y + 0.5 - entity.field_70163_u;
                        double distance = distX * distX + distY * distY + distZ * distZ;
                        if (!(closestPortal < 0.0) && !(distance < closestPortal)) continue;
                        closestPortal = distance;
                        foundX = x;
                        foundY = y;
                        foundZ = z;
                    }
                }
            }
        }
        if (closestPortal >= 0.0) {
            if (notInCache) {
                this.field_85191_c.func_76163_a(j1, (Object)new PortalPosition((Teleporter)this, foundX, foundY, foundZ, this.world.func_82737_E()));
                this.field_85190_d.add(j1);
            }
            int x = foundX;
            int y = foundY;
            int z = foundZ;
            double newLocX = (double)x + 0.5;
            double newLocY = (double)y + 0.5;
            double newLocZ = (double)z + 0.5;
            if (this.world.func_72798_a(x - 1, y, z) == this.portalBlockID) {
                newLocX -= 0.5;
            }
            if (this.world.func_72798_a(x + 1, y, z) == this.portalBlockID) {
                newLocX += 0.5;
            }
            if (this.world.func_72798_a(x, y, z - 1) == this.portalBlockID) {
                newLocZ -= 0.5;
            }
            if (this.world.func_72798_a(x, y, z + 1) == this.portalBlockID) {
                newLocZ += 0.5;
            }
            entity.func_70012_b(newLocX, newLocY + 2.0, newLocZ, entity.field_70177_z, 0.0f);
            int worldSpawnX = MathHelper.func_76128_c((double)newLocX) + (new Random().nextBoolean() ? 3 : -3);
            int worldSpawnZ = MathHelper.func_76128_c((double)newLocZ) + (new Random().nextBoolean() ? 3 : -3);
            int worldSpawnY = this.world.func_72976_f(worldSpawnX, worldSpawnZ) + 3;
            this.world.func_72912_H().func_76081_a(worldSpawnX, worldSpawnY, worldSpawnZ);
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (this.world.field_73011_w instanceof WorldProviderTropicraft && !player.field_71071_by.func_70450_e(TropicraftItems.encTropica.field_77779_bT)) {
                    TileEntityBambooChest chest = null;
                    int chestX = MathHelper.func_76128_c((double)newLocX);
                    int chestZ = MathHelper.func_76128_c((double)newLocZ);
                    block4: for (int searchX = -3; searchX < 4; ++searchX) {
                        for (int searchZ = -3; searchZ < 4; ++searchZ) {
                            for (int searchY = -3; searchY < 4; ++searchY) {
                                if (this.world.func_72798_a(chestX + searchX, worldSpawnY + searchY, chestZ + searchZ) == TropicraftBlocks.bambooChest.field_71990_ca && (chest = (TileEntityBambooChest)this.world.func_72796_p(chestX + searchX, worldSpawnY + searchY, chestZ + searchZ)) != null && chest.isUnbreakable()) break block4;
                            }
                        }
                    }
                    if (chest != null && chest.isUnbreakable()) {
                        int inv;
                        boolean hasEncyclopedia = false;
                        for (inv = 0; inv < chest.func_70302_i_(); ++inv) {
                            ItemStack stack = chest.func_70301_a(inv);
                            if (stack == null || stack.func_77973_b() != TropicraftItems.encTropica) continue;
                            hasEncyclopedia = true;
                        }
                        if (!hasEncyclopedia) {
                            for (inv = 0; inv < chest.func_70302_i_(); ++inv) {
                                ItemStack stack = chest.func_70301_a(inv);
                                if (stack != null) continue;
                                chest.func_70299_a(inv, new ItemStack(TropicraftItems.encTropica, 1));
                                break;
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        int searchArea = 32;
        double closestSpot = -1.0;
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        int foundX = entityX;
        int foundY = entityY;
        int foundZ = entityZ;
        for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
            double distX = (double)x + 0.5 - entity.field_70165_t;
            block1: for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                int y;
                double distZ = (double)z + 0.5 - entity.field_70161_v;
                for (y = this.world.func_72800_K() - 1; !(y < 62 || this.world.func_72798_a(x, y, z) != 0 && Block.field_71973_m[this.world.func_72798_a((int)x, (int)y, (int)z)].field_72018_cp.func_76220_a()); --y) {
                }
                if (y > 83 || y < 63 || !validBlockIDs.contains(this.world.func_72798_a(x, y, z))) continue;
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        int otherY;
                        for (otherY = this.world.func_72800_K() - 1; !(otherY < 63 || this.world.func_72798_a(x + xOffset, otherY, z + zOffset) != 0 && Block.field_71973_m[this.world.func_72798_a((int)(x + xOffset), (int)otherY, (int)(z + zOffset))].field_72018_cp.func_76220_a()); --otherY) {
                        }
                        if (Math.abs(y - otherY) >= 3 || !validBlockIDs.contains(this.world.func_72798_a(x + xOffset, otherY, z + zOffset))) continue block1;
                    }
                }
                double distY = (double)y + 0.5 - entity.field_70163_u;
                double distance = distX * distX + distY * distY + distZ * distZ;
                if (!(closestSpot < 0.0) && !(distance < closestSpot)) continue;
                closestSpot = distance;
                foundX = x;
                foundY = y;
                foundZ = z;
            }
        }
        if (closestSpot < 0.0) {
            Random r = new Random();
            foundX += r.nextInt(16) - 8;
            foundZ += r.nextInt(16) - 8;
            foundY = 63;
        }
        this.buildTeleporterAt(foundX, foundY, foundZ, entity);
        return true;
    }

    public void buildTeleporterAt(int x, int y, int z, Entity entity) {
        int blockZ;
        int blockY;
        int blockX;
        int xOffset;
        int zOffset;
        int yOffset;
        y = y < 9 ? 9 : y;
        for (yOffset = 4; yOffset >= -7; --yOffset) {
            for (zOffset = -2; zOffset <= 2; ++zOffset) {
                for (xOffset = -2; xOffset <= 2; ++xOffset) {
                    boolean isCorner;
                    blockX = x + xOffset;
                    blockY = y + yOffset;
                    blockZ = z + zOffset;
                    if (yOffset == -7) {
                        this.world.func_94575_c(blockX, blockY, blockZ, this.portalWallID);
                    } else if (yOffset > 0) {
                        this.world.func_94575_c(blockX, blockY, blockZ, 0);
                    } else {
                        boolean isWall;
                        boolean bl = isWall = xOffset == -2 || xOffset == 2 || zOffset == -2 || zOffset == 2;
                        if (isWall) {
                            this.world.func_94575_c(blockX, blockY, blockZ, this.portalWallID);
                        } else {
                            int metadata = yOffset == -6 ? 8 : 0;
                            this.world.func_72832_d(blockX, blockY, blockZ, this.portalBlockID, metadata, 3);
                        }
                    }
                    boolean bl = isCorner = !(xOffset != -2 && xOffset != 2 || zOffset != -2 && zOffset != 2);
                    if (yOffset != 0 || !isCorner) continue;
                    System.out.println("I found waldo!" + blockX + " " + blockY + " " + blockZ + " Dimension=" + this.world.field_73011_w.field_76574_g);
                    this.world.func_72832_d(blockX, blockY + 1, blockZ, TropicraftBlocks.tikiTorch.field_71990_ca, 1, 3);
                    this.world.func_72832_d(blockX, blockY + 2, blockZ, TropicraftBlocks.tikiTorch.field_71990_ca, 1, 3);
                    this.world.func_72832_d(blockX, blockY + 3, blockZ, TropicraftBlocks.tikiTorch.field_71990_ca, 0, 3);
                }
            }
        }
        if (this.world.field_73011_w instanceof WorldProviderTropicraft) {
            this.world.func_72832_d(x + 2, y + 1, z, TropicraftBlocks.bambooChest.field_71990_ca, 1, 3);
            TileEntityBambooChest tile = (TileEntityBambooChest)this.world.func_72796_p(x + 2, y + 1, z);
            if (tile != null) {
                tile.setIsUnbreakable(true);
            }
        }
        for (yOffset = 5; yOffset >= -7; --yOffset) {
            for (zOffset = -2; zOffset <= 2; ++zOffset) {
                for (xOffset = -2; xOffset <= 2; ++xOffset) {
                    blockX = x + xOffset;
                    blockY = y + yOffset;
                    blockZ = z + zOffset;
                    this.world.func_72898_h(blockX, blockY, blockZ, this.world.func_72798_a(blockX, blockY, blockZ));
                }
            }
        }
    }

    public void func_85189_a(long par1) {
        if (par1 % 100L == 0L) {
            Iterator iterator = this.field_85190_d.iterator();
            long j = par1 - 600L;
            while (iterator.hasNext()) {
                Long olong = (Long)iterator.next();
                PortalPosition portalposition = (PortalPosition)this.field_85191_c.func_76164_a(olong.longValue());
                if (portalposition != null && portalposition.field_85087_d >= j) continue;
                iterator.remove();
                this.field_85191_c.func_76159_d(olong.longValue());
            }
        }
    }
}

