/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.entities.hostile.land;

import CoroAI.componentAI.jobSystem.JobBase;
import CoroAI.componentAI.jobSystem.JobHunt;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import tropicraft.entities.hostile.EntityLand;
import tropicraft.items.TropicraftItems;

public class TreeFrog
extends EntityLand
implements IEntityAdditionalSpawnData {
    public int type = 0;
    public int jumpDelay = 0;
    public int jumpDelayMax = 10;
    public boolean wasOnGround = false;
    public double leapVecX;
    public double leapVecZ;

    public TreeFrog(World par1World) {
        super(par1World);
        this.func_70105_a(0.8f, 0.8f);
        this.agent.jobMan.clearJobs();
        this.agent.jobMan.addPrimaryJob((JobBase)new JobHunt(this.agent.jobMan){

            public void onTickCloseCombat() {
            }
        });
        this.agent.shouldAvoid = false;
        this.field_70144_Y = 0.8f;
        this.field_70728_aV = 5;
    }

    public TreeFrog(World par1World, int parType) {
        this(par1World);
        this.type = parType;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
    }

    @Override
    public void attackMelee(Entity ent, float dist) {
        ent.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
        if (ent.field_70170_p.field_73012_v.nextInt(3) == 0) {
            if (ent instanceof EntityLivingBase) {
                ((EntityLivingBase)ent).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60));
            }
            this.field_70170_p.func_72956_a(ent, "frogspit", 1.0f, 1.0f);
        }
    }

    protected void func_70628_a(boolean par1, int par2) {
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + par2);
        for (int k = 0; k < j; ++k) {
        }
        this.func_70025_b(TropicraftItems.frogLeg.field_77779_bT, 1);
    }

    @Override
    public void func_70619_bc() {
        super.func_70619_bc();
        this.getAIAgent().shouldPathfollow = false;
        this.getAIAgent().shouldFixBadYPathing = true;
        this.getAIAgent().checkPathfindLock();
        double curSpeed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.field_70122_E) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        Random rand = new Random();
        if (!this.func_70661_as().func_75500_f() || this.getAIAgent().entityToAttack != null) {
            if (this.field_70122_E || this.func_70090_H()) {
                if (this.jumpDelay > 0) {
                    --this.jumpDelay;
                }
                if (this.jumpDelay <= 0) {
                    this.jumpDelay = rand.nextInt(4);
                    this.func_70661_as().func_75501_e();
                    this.func_70664_aZ();
                    this.field_70181_x += -0.01 + rand.nextDouble() * 0.1;
                    double speed = 0.4;
                    if (this.func_70661_as().func_75505_d() != null) {
                        try {
                            if (this.func_70661_as().func_75505_d().func_75873_e() > this.func_70661_as().func_75505_d().func_75874_d()) {
                                this.func_70661_as().func_75499_g();
                                return;
                            }
                            Vec3 pos = this.func_70661_as().func_75505_d().func_75878_a((Entity)this);
                            this.leapVecX = pos.field_72450_a - this.field_70165_t;
                            this.leapVecZ = pos.field_72449_c - this.field_70161_v;
                            speed = 0.2;
                        }
                        catch (Exception ex) {
                            return;
                        }
                    } else if (this.getAIAgent().entityToAttack != null) {
                        this.leapVecX = this.getAIAgent().entityToAttack.field_70165_t - this.field_70165_t;
                        this.leapVecZ = this.getAIAgent().entityToAttack.field_70161_v - this.field_70161_v;
                    }
                    if (this.leapVecX != 0.0) {
                        double dist2 = Math.sqrt(this.leapVecX * this.leapVecX + this.leapVecZ * this.leapVecZ);
                        this.field_70159_w += this.leapVecX / dist2 * speed;
                        this.field_70179_y += this.leapVecZ / dist2 * speed;
                    }
                }
            } else if (this.leapVecX != 0.0 && curSpeed < 0.02) {
                double speed = 0.1;
                if (this.func_70090_H()) {
                    speed = 0.2;
                }
                double dist2 = Math.sqrt(this.leapVecX * this.leapVecX + this.leapVecZ * this.leapVecZ);
                this.field_70159_w += this.leapVecX / dist2 * speed;
                this.field_70179_y += this.leapVecZ / dist2 * speed;
            }
            if (this.func_70090_H()) {
                this.field_70181_x += 0.07;
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    @Override
    public void func_70636_d() {
        this.field_70143_R = 0.0f;
        this.func_70050_g(400);
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public void moveTowards(Entity ent, Entity targ, float speed) {
        double vecX = targ.field_70165_t - ent.field_70165_t;
        double vecY = targ.field_70163_u - ent.field_70163_u;
        double vecZ = targ.field_70161_v - ent.field_70161_v;
        double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        ent.field_70159_w += vecX / dist2 * (double)speed;
        ent.field_70181_x += vecY / dist2 * (double)speed;
        ent.field_70179_y += vecZ / dist2 * (double)speed;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.type);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.type = data.readInt();
    }
}

