/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.entities.passive.water;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeInstance;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tropicraft.items.TropicraftItems;

public class EntityAmphibian
extends EntityCreature {
    public boolean desireToReturn = true;
    public boolean returnToLand = false;
    public boolean reachedTarget = false;
    public float important1 = 0.0f;
    protected float randomMotionSpeed = 0.0f;
    protected float important2 = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    protected float randomMotionVecX = 0.0f;
    protected float randomMotionVecY = 0.0f;
    protected float randomMotionVecZ = 0.0f;
    public int targetHeight = 61;
    protected int growthRate;
    protected int fickleness;
    protected float landSpeed;
    public static final UUID uuid = UUID.randomUUID();
    public static AttributeModifier speedBoostReturnToLand = new AttributeModifier(uuid, "Speed boost return to land", 0.25, 0).func_111168_a(false);
    public float moveSpeed;

    public EntityAmphibian(World world) {
        super(world);
        this.setAmphibianAge(1.0f);
        this.growthRate = 12000;
        this.fickleness = 1200;
        this.landSpeed = 0.25f;
    }

    public EntityAmphibian(World world, float placeHolder) {
        super(world);
        this.growthRate = 12000;
        this.fickleness = 1200;
        this.setAmphibianAge(placeHolder);
        this.landSpeed = 0.25f;
        this.setMoveSpeed(this.landSpeed);
    }

    public void setSpeedReturnToLandAdditive(float speed) {
        speedBoostReturnToLand = new AttributeModifier(uuid, "Speed boost return to land", (double)speed, 0).func_111168_a(false);
    }

    public void setSpeedNormalBase(float var) {
        this.moveSpeed = var;
    }

    public void applyEntityAttributesMine() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.moveSpeed);
    }

    public void attrRemoveSpeeds() {
        AttributeInstance attributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        attributeinstance.func_111124_b(speedBoostReturnToLand);
    }

    public void attrSetReturnToLand() {
        this.attrRemoveSpeeds();
        AttributeInstance attributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        attributeinstance.func_111121_a(speedBoostReturnToLand);
    }

    public void attrSetSpeedNormal() {
        this.attrRemoveSpeeds();
    }

    public void setAmphibianAge(float age) {
        this.field_70180_af.func_75692_b(16, (Object)new Integer((int)(age * 10000.0f)));
    }

    public float getAmphibianAge() {
        return (float)this.field_70180_af.func_75679_c(16) / 10000.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setSpeedReturnToLandAdditive(0.5f);
        this.setSpeedNormalBase(1.0f);
        this.applyEntityAttributesMine();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    protected boolean func_70650_aV() {
        return false;
    }

    protected double getDistanceToBase(int i) {
        if (i == 5) {
            return i;
        }
        if (this.field_70170_p.func_72798_a((int)this.field_70165_t, 62 - i, (int)this.field_70161_v) == Block.field_71943_B.field_71990_ca) {
            return this.getDistanceToBase(i + 1);
        }
        return i;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Integer(10000));
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("Age", this.getAmphibianAge());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setAmphibianAge(nbttagcompound.func_74760_g("Age"));
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        this.func_70099_a(new ItemStack(TropicraftItems.shells.field_77779_bT, 1, 5), 1.0f);
    }

    protected void getTargetHeight() {
        if (this.func_70026_G()) {
            int range = (int)this.getDistanceToBase(0);
            if (range > 1) {
                this.targetHeight = (int)this.field_70163_u;
            }
            this.targetHeight = 63 - this.field_70146_Z.nextInt(range + 1);
            if (this.targetHeight == 63) {
                --this.targetHeight;
            }
            this.reachedTarget = false;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % this.growthRate == 0) {
            this.setAmphibianAge(this.getAmphibianAge() + 0.05f);
        }
        if (this.field_70146_Z.nextInt(this.fickleness / 2) == 0 && this.returnToLand) {
            this.returnToLand = false;
        }
        if (this.func_70090_H() && this.returnToLand) {
            this.attrSetReturnToLand();
        } else if (!this.func_70090_H()) {
            this.attrSetSpeedNormal();
        } else if (this.func_70090_H() && !this.returnToLand) {
            if (this.field_70146_Z.nextInt(this.fickleness) == 0) {
                this.returnToLand = true;
            }
            this.important1 += this.important2;
            if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
                float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70760_ar = this.field_70761_aq = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
                this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / 3.1415927410125732);
            }
            float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / 3.1415927410125732);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            if (this.important1 > 6.283185f) {
                this.important1 -= 6.283185f;
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.important2 = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
            }
            if (this.important1 < 3.141593f) {
                float f = this.important1 / 3.141593f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                }
            } else {
                this.randomMotionSpeed *= 0.95f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / 3.141593f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
        }
    }

    public float func_70783_a(int i, int j, int k) {
        int block = this.field_70170_p.func_72798_a(i, j - 1, k);
        if (this.returnToLand) {
            switch (block) {
                case 2: {
                    return 10.0f;
                }
                case 12: {
                    return 20.0f;
                }
            }
        } else if (block == Block.field_71943_B.field_71990_ca) {
            return 20.0f;
        }
        return 0.0f;
    }

    protected void func_70626_be() {
        if (this.returnToLand || !this.returnToLand && !this.func_70090_H()) {
            super.func_70626_be();
        }
        if (!this.returnToLand) {
            if (this.field_70146_Z.nextInt(70) == 0 || !this.field_70171_ac || this.randomMotionVecX == 0.0f && this.randomMotionVecY == 0.0f && this.randomMotionVecZ == 0.0f) {
                float f = this.field_70146_Z.nextFloat() * 3.141593f * 2.0f;
                this.randomMotionVecX = MathHelper.func_76134_b((float)f) * 0.15f;
                this.randomMotionVecZ = MathHelper.func_76126_a((float)f) * 0.15f;
            }
            if (this.func_70090_H()) {
                if (this.field_70163_u <= (double)this.targetHeight + 0.15 && this.field_70163_u >= (double)this.targetHeight - 0.15 || this.reachedTarget) {
                    this.reachedTarget = true;
                    this.randomMotionVecY = 0.0f;
                    if (this.field_70146_Z.nextInt(300) == 0) {
                        this.getTargetHeight();
                    }
                } else if (this.field_70163_u > (double)this.targetHeight && !this.reachedTarget) {
                    this.randomMotionVecY = -0.15f;
                } else if (this.field_70163_u < (double)this.targetHeight && !this.reachedTarget) {
                    this.randomMotionVecY = 0.15f;
                }
            }
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70601_bi() {
        return !this.field_70170_p.func_72829_c(this.field_70121_D);
    }

    public int func_70627_aG() {
        return 120;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    protected int func_70693_a(EntityPlayer entityplayer) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public float getMoveSpeed() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
    }

    public void setMoveSpeed(float var) {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)var);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(23, (Object)((int)(var * 1000.0f)));
        }
    }
}

