/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.structures;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.structures.KoaVillageGenerator;

public class ComponentKoaVillage
extends StructureComponent {
    private static final int SEA_LEVEL = 63;
    private boolean hasGenerated = false;
    private int xSize = 256;
    private int ySize = 48;
    private int zSize = 256;
    private KoaVillageGenerator village;
    private static final List<Integer> waterBlocks = new LinkedList<Integer>();
    private static final List<Integer> sandBlocks = new LinkedList<Integer>();

    public ComponentKoaVillage() {
    }

    public ComponentKoaVillage(WorldChunkManager worldchunkmanager, Random random, int x, int z, World world) {
        super(0);
        this.village = new KoaVillageGenerator(world);
        this.field_74885_f = 0;
        this.field_74887_e = StructureBoundingBox.func_78889_a((int)x, (int)0, (int)z, (int)0, (int)0, (int)0, (int)this.xSize, (int)this.ySize, (int)this.zSize, (int)this.field_74885_f);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox structureboundingbox) {
        if (this.hasBeenGenerated()) {
            return false;
        }
        this.village = new KoaVillageGenerator(world);
        this.field_74887_e.func_78886_a(0, 63 - this.field_74887_e.field_78895_b - 1, 0);
        for (int scanU = 16; scanU < 48 && !this.hasBeenGenerated(); ++scanU) {
            for (int scanV = 64; scanV < this.xSize - 64 && !this.hasBeenGenerated(); ++scanV) {
                int x1 = scanU;
                int z1 = scanV;
                int x2 = scanV;
                int z2 = scanU;
                int x3 = this.xSize - scanU - 1;
                int z3 = this.zSize - scanV - 1;
                int x4 = this.xSize - scanV - 1;
                int z4 = this.zSize - scanU - 1;
                if (sandBlocks.contains(this.func_74866_a(world, x1, 0, z1, this.field_74887_e)) && waterBlocks.contains(this.func_74866_a(world, x1 + 1, 0, z1, this.field_74887_e)) && this.func_74866_a(world, x1 - 1, 1, z1, this.field_74887_e) == 0) {
                    this.setHasGenerated();
                    this.village.generate(world, random, x1 + this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, z1 + this.field_74887_e.field_78896_c, 0);
                }
                if (sandBlocks.contains(this.func_74866_a(world, x2, 0, z2, this.field_74887_e)) && waterBlocks.contains(this.func_74866_a(world, x2, 0, z2 + 1, this.field_74887_e)) && this.func_74866_a(world, x2, 1, z2 - 1, this.field_74887_e) == 0) {
                    this.setHasGenerated();
                    this.village.generate(world, random, x2 + this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, z2 + this.field_74887_e.field_78896_c, 2);
                }
                if (sandBlocks.contains(this.func_74866_a(world, x3, 0, z3, this.field_74887_e)) && waterBlocks.contains(this.func_74866_a(world, x3 - 1, 0, z3, this.field_74887_e)) && this.func_74866_a(world, x3 + 1, 1, z3, this.field_74887_e) == 0) {
                    this.setHasGenerated();
                    this.village.generate(world, random, x3 + this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, z3 + this.field_74887_e.field_78896_c, 1);
                }
                if (!sandBlocks.contains(this.func_74866_a(world, x4, 0, z4, this.field_74887_e)) || !waterBlocks.contains(this.func_74866_a(world, x4, 0, z4 - 1, this.field_74887_e)) || this.func_74866_a(world, x4, 0, z4 + 1, this.field_74887_e) != 0) continue;
                this.setHasGenerated();
                this.village.generate(world, random, x4 + this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, z4 + this.field_74887_e.field_78896_c, 3);
            }
        }
        return true;
    }

    private void setHasGenerated() {
        this.hasGenerated = true;
    }

    public boolean hasBeenGenerated() {
        return this.hasGenerated;
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        this.hasGenerated = nbt.func_74767_n("hasGenerated");
    }

    protected void func_143011_b(NBTTagCompound nbt) {
        nbt.func_74757_a("hasGenerated", this.hasGenerated);
    }

    static {
        waterBlocks.add(Block.field_71942_A.field_71990_ca);
        waterBlocks.add(Block.field_71943_B.field_71990_ca);
        waterBlocks.add(TropicraftBlocks.tropicsWaterFlowing.field_71990_ca);
        waterBlocks.add(TropicraftBlocks.tropicsWaterStationary.field_71990_ca);
        sandBlocks.add(Block.field_71939_E.field_71990_ca);
        sandBlocks.add(TropicraftBlocks.purifiedSand.field_71990_ca);
    }
}

