/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.biomes.BiomeGenTropicraft;
import tropicraft.world.worldgen.TCGenBase;

public class WorldGenTallRTree
extends TCGenBase {
    private boolean gen;
    private int woodBlockId;
    private int woodMetadata;
    private int leafBlockId;

    public WorldGenTallRTree(World world, Random random, boolean g) {
        super(world, random, true);
        this.woodBlockId = TropicraftBlocks.treeWood.field_71990_ca;
        this.woodMetadata = 1;
        this.leafBlockId = TropicraftBlocks.tropicsLeaves.field_71990_ca;
        this.gen = g;
    }

    public WorldGenTallRTree(World world, Random random, boolean g, boolean rainforestOnly) {
        super(world, random, rainforestOnly);
        this.woodBlockId = TropicraftBlocks.treeWood.field_71990_ca;
        this.woodMetadata = 1;
        this.leafBlockId = TropicraftBlocks.tropicsLeaves.field_71990_ca;
        this.gen = g;
    }

    @Override
    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        return this.generate(i, j, k);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int y;
        int bid;
        if (this.isRainforestOnly && !BiomeGenTropicraft.rainforestBiomes.contains(this.worldObj.func_72807_a(i, k))) {
            return false;
        }
        if (this.gen) {
            j = this.getTerrainHeightAt(i, k);
        }
        if ((bid = this.worldObj.func_72798_a(i, j - 1, k)) != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        bid = this.worldObj.func_72798_a(i + 1, j - 1, k);
        if (bid != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        bid = this.worldObj.func_72798_a(i - 1, j - 1, k);
        if (bid != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        bid = this.worldObj.func_72798_a(i, j - 1, k + 1);
        if (bid != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        bid = this.worldObj.func_72798_a(i, j - 1, k - 1);
        if (bid != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        int height = this.rand.nextInt(15) + 15;
        for (y = j; y < j + height + 6; ++y) {
            for (int x = i - 1; x <= i + 1; ++x) {
                for (int z = k - 1; z <= k + 1; ++z) {
                    int id = this.worldObj.func_72798_a(x, y, z);
                    if (id == 0 || id == Block.field_71962_X.field_71990_ca || id == this.leafBlockId) continue;
                    return false;
                }
            }
        }
        for (y = j; y < j + height; ++y) {
            int oz;
            int ox;
            this.worldObj.func_72832_d(i, y, k, this.woodBlockId, this.woodMetadata, 3);
            this.worldObj.func_72832_d(i - 1, y, k, this.woodBlockId, this.woodMetadata, 3);
            this.worldObj.func_72832_d(i + 1, y, k, this.woodBlockId, this.woodMetadata, 3);
            this.worldObj.func_72832_d(i, y, k - 1, this.woodBlockId, this.woodMetadata, 3);
            this.worldObj.func_72832_d(i, y, k + 1, this.woodBlockId, this.woodMetadata, 3);
            if (y - j > height / 2 && this.rand.nextInt(3) == 0) {
                ox = this.rand.nextInt(3) - 1 + i;
                oz = this.rand.nextInt(3) - 1 + k;
                this.genCircle(ox, y + 1, oz, 1.0, 0.0, this.leafBlockId, 3, false);
                this.genCircle(ox, y, oz, 2.0, 1.0, this.leafBlockId, 3, false);
                this.checkAndPlaceBlockLine(new int[]{i, y, k}, new int[]{ox, y, oz}, this.woodBlockId, 1, Arrays.asList(0, this.leafBlockId, Block.field_71998_bu.field_71990_ca));
                for (int x = i - 3; x <= i + 3; ++x) {
                    for (int z = k - 3; z <= k + 3; ++z) {
                        for (int y1 = y - 1; y1 <= y + 1; ++y1) {
                            if (this.rand.nextInt(5) != 0) continue;
                            this.genVines(x, y1, z);
                        }
                    }
                }
            }
            if (y - j <= height - height / 4 || y - j >= height - 3 || this.rand.nextInt(3) != 0) continue;
            ox = i + this.rand.nextInt(9) - 4;
            oz = k + this.rand.nextInt(9) - 4;
            int leafSize = this.rand.nextInt(3) + 5;
            this.genCircle(ox, y + 3, oz, leafSize - 2, 0.0, this.leafBlockId, 3, false);
            this.genCircle(ox, y + 2, oz, leafSize - 1, leafSize - 3, this.leafBlockId, 3, false);
            this.genCircle(ox, y + 1, oz, leafSize, leafSize - 1, this.leafBlockId, 3, false);
            int bn = this.rand.nextInt(4) + 4;
            for (int b = 0; b < bn; ++b) {
                double randAngle = this.randAngle();
                int branchLength = this.rand.nextInt(leafSize - 4) + 3;
                int ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)ox);
                int az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)oz);
                this.checkAndPlaceBlockLine(new int[]{i, y, k}, new int[]{ax, y, az}, this.woodBlockId, 1, Arrays.asList(0, this.leafBlockId, Block.field_71998_bu.field_71990_ca));
            }
            for (int x = i - leafSize; x <= i + leafSize; ++x) {
                for (int z = k - leafSize; z <= k + leafSize; ++z) {
                    for (int y1 = y; y1 <= y + 3; ++y1) {
                        if (this.rand.nextInt(4) != 0) continue;
                        this.genVines(x, y1, z);
                    }
                }
            }
        }
        int leafSize = this.rand.nextInt(5) + 9;
        this.genCircle(i, j + height, k, leafSize - 2, 0.0, this.leafBlockId, 3, false);
        this.genCircle(i, j + height - 1, k, leafSize - 1, leafSize - 4, this.leafBlockId, 3, false);
        this.genCircle(i, j + height - 2, k, leafSize, leafSize - 1, this.leafBlockId, 3, false);
        int bn = this.rand.nextInt(4) + 6;
        for (int b = 0; b < bn; ++b) {
            double randAngle = this.randAngle();
            int branchLength = this.rand.nextInt(leafSize - 6) + 3;
            int ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)i);
            int az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)k);
            this.checkAndPlaceBlockLine(new int[]{i, j + height - 1, k}, new int[]{ax, j + height + 5, az}, this.woodBlockId, 1, Arrays.asList(0, Block.field_71952_K.field_71990_ca, Block.field_71998_bu.field_71990_ca));
        }
        for (int x = i - leafSize; x <= i + leafSize; ++x) {
            for (int z = k - leafSize; z <= k + leafSize; ++z) {
                for (int y1 = j + height + 3; y1 <= j + height + 6; ++y1) {
                    if (this.rand.nextInt(4) != 0) continue;
                    this.genVines(x, y1, z);
                }
            }
        }
        return true;
    }

    private boolean genVines(int i, int j, int k) {
        int m = 2;
        while (true) {
            if (m > 5) {
                return false;
            }
            if (Block.field_71998_bu.func_71850_a_(this.worldObj, i, j, k, m) && this.worldObj.func_72798_a(i, j, k) == 0) break;
            ++m;
        }
        this.worldObj.func_72832_d(i, j, k, Block.field_71998_bu.field_71990_ca, 1 << Direction.field_71579_d[Facing.field_71588_a[m]], 3);
        int length = this.rand.nextInt(4) + 4;
        for (int y = j - 1; y > j - length; --y) {
            if (this.worldObj.func_72798_a(i, y, k) != 0) {
                return true;
            }
            this.worldObj.func_72832_d(i, y, k, Block.field_71998_bu.field_71990_ca, 1 << Direction.field_71579_d[Facing.field_71588_a[m]], 3);
        }
        return true;
    }
}

