/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.registry;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.items.TropicraftItems;

public class TCBlockRegistry {
    public static final Fluid TROPICS_WATER = new Fluid("tropics_water").setBlockID(TropicraftBlocks.tropicsWaterStationary.field_71990_ca).setUnlocalizedName(TropicraftBlocks.tropicsWaterStationary.func_71917_a());

    public static void init() {
        TCBlockRegistry.oreDictInit();
        TCBlockRegistry.liquidDictInit();
    }

    private static void oreDictInit() {
        TCBlockRegistry.registerOre("ores", new ItemStack(TropicraftBlocks.tropiOres, 1, Short.MAX_VALUE));
        TCBlockRegistry.registerOre("bambooBundle", TropicraftBlocks.bambooBundle);
        TCBlockRegistry.registerOre("coral", new ItemStack(TropicraftBlocks.coral, 1, Short.MAX_VALUE));
        TCBlockRegistry.registerOre("chunk_o_head", TropicraftBlocks.chunkOHead);
        TCBlockRegistry.registerOre("fruit_leaves", new ItemStack(TropicraftBlocks.fruitLeaves, 1, Short.MAX_VALUE));
        TCBlockRegistry.registerOre("flowers", new ItemStack(TropicraftBlocks.tropicsFlowers, 1, Short.MAX_VALUE));
        TCBlockRegistry.registerOre("saplings", new ItemStack(TropicraftBlocks.saplings, 1, Short.MAX_VALUE));
        TCBlockRegistry.registerOre("logs", new ItemStack(TropicraftBlocks.treeWood, 1, Short.MAX_VALUE));
        TCBlockRegistry.registerOre("purified_sand", TropicraftBlocks.purifiedSand);
    }

    private static void registerOre(String name, ItemStack stack) {
        OreDictionary.registerOre((String)("tropicraftmod" + name), (ItemStack)stack);
    }

    private static void registerOre(String name, Block block) {
        OreDictionary.registerOre((String)("tropicraftmod" + name), (Block)block);
    }

    private static void liquidDictInit() {
        FluidRegistry.registerFluid((Fluid)TROPICS_WATER);
        FluidContainerRegistry.registerFluidContainer((Fluid)TROPICS_WATER, (ItemStack)new ItemStack(TropicraftItems.bucketTropicsWater), (ItemStack)new ItemStack(Item.field_77788_aw));
    }
}

