/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;
import tropicraft.ModRenderIds;
import tropicraft.blocks.BlockTropicraftImpl;
import tropicraft.items.TropicraftItems;

public class BlockCoffeePlant
extends BlockTropicraftImpl {
    public static final int MAX_HEIGHT = 3;
    public static final int GROWTH_RATE_FERTILE = 10;
    public static final int GROWTH_RATE_INFERTILE = 20;
    public static final int RIPENING_RATE_FERTILE = 12;
    public static final int RIPENING_RATE_INFERTILE = 25;
    @SideOnly(value=Side.CLIENT)
    public Icon[] leafIcons;
    @SideOnly(value=Side.CLIENT)
    public Icon stemIcon;

    public BlockCoffeePlant(int i) {
        super(i, Material.field_76254_j, "coffeeplant");
        this.func_71907_b(true);
        this.func_71896_v();
    }

    public Icon func_71858_a(int side, int meta) {
        return this.leafIcons[meta &= 7];
    }

    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        if (side == 1 && world.func_72798_a(x, y, z) == this.field_71990_ca) {
            return false;
        }
        if (side == 0 && world.func_72798_a(x, y, z) == this.field_71990_ca) {
            return false;
        }
        return super.func_71877_c(world, x, y, z, side);
    }

    public boolean func_71926_d() {
        return false;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    private void tryToGrowUpwards(World world, int x, int y, int z, Random random) {
        if (world.func_72799_c(x, y + 1, z)) {
            int height = 1;
            while (world.func_72798_a(x, y - height, z) == this.field_71990_ca) {
                ++height;
            }
            if (height < 3 && random.nextInt(this.isFertile(world, x, y - height, z) ? 10 : 20) == 0) {
                world.func_72832_d(x, y + 1, z, this.field_71990_ca, 0, 2);
            }
        }
    }

    private void tryToRipen(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z) & 7;
        if (meta == 7) {
            world.func_72921_c(x, y, z, 6, 2);
            return;
        }
        if (meta == 6) {
            return;
        }
        if (world.func_72957_l(x, y + 1, z) < 9) {
            return;
        }
        if (random.nextInt(this.isFertile(world, x, y - 1, z) ? 12 : 25) != 0) {
            return;
        }
        world.func_72921_c(x, y, z, meta + 1, 2);
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        this.tryToGrowUpwards(world, x, y, z, random);
        this.tryToRipen(world, x, y, z, random);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float offsetX, float offsetY, float offsetZ) {
        if ((world.func_72805_g(x, y, z) & 7) != 6) {
            return false;
        }
        world.func_72832_d(x, y, z, this.field_71990_ca, 0, 3);
        ItemStack stack = new ItemStack(TropicraftItems.coffeeBean, 1, 2);
        this.func_71929_a(world, x, y, z, stack);
        return true;
    }

    public int func_71885_a(int par1, Random random, int par3) {
        return TropicraftItems.coffeeBean.field_77779_bT;
    }

    public int func_71899_b(int meta) {
        return 2;
    }

    public int func_71922_a(World par1World, int par2, int par3, int par4) {
        return TropicraftItems.coffeeBean.field_77779_bT;
    }

    public int func_71873_h(World par1World, int par2, int par3, int par4) {
        return 0;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return meta == 6 ? 1 : 0;
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborId) {
        if (!this.func_71854_d(world, x, y, z)) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_72832_d(x, y, z, 0, 0, 2);
        }
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        Block soil = field_71973_m[world.func_72798_a(x, y - 1, z)];
        return !(world.func_72883_k(x, y, z) < 8 && !world.func_72937_j(x, y, z) || soil == null || soil.field_71990_ca != this.field_71990_ca && !soil.canSustainPlant(world, x, y - 1, z, ForgeDirection.UP, (IPlantable)TropicraftItems.coffeeBean));
    }

    public int func_71857_b() {
        return ModRenderIds.coffeePlantRenderId;
    }

    @Override
    public void func_94332_a(IconRegister iconRegistry) {
        this.leafIcons = new Icon[]{iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + "0"), iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + "1"), iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + "2"), iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + "3"), iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + "4"), iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + "5"), iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + "6")};
        this.stemIcon = iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + "stem");
    }
}

