/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import tropicraft.world.worldgen.WorldGenRainforest;

public class WorldGenCanopyTreeTall
extends WorldGenRainforest {
    int radius;

    public WorldGenCanopyTreeTall(int rad) {
        this.radius = rad;
    }

    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        rand = new Random();
        int height = rand.nextInt(15);
        if (height < 12) {
            height += 10 + Math.abs(rand.nextInt(5));
        }
        int id = Block.field_71951_J.field_71990_ca;
        if (height + 5 > 127) {
            return false;
        }
        if (world.func_72798_a(i, j - 1, k) != Block.field_71979_v.field_71990_ca && world.func_72798_a(i, j - 1, k) != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        for (int h = 0; h < height; ++h) {
            this.place(world, i, j + h, k, id);
            this.place(world, i + 1, j + h, k, id);
            this.place(world, i, j + h, k + 1, id);
            this.place(world, i + 1, j + h, k + 1, id);
        }
        int j1 = j + height - 1;
        for (int i1 = i - this.radius + 1; i1 < i + this.radius + 1; ++i1) {
            for (int k1 = k - this.radius + 1; k1 < k + this.radius + 1; ++k1) {
                this.place(world, i1, j1, k1, Block.field_71952_K.field_71990_ca);
                if (i1 <= i - this.radius + 1 || k1 <= k - this.radius + 1 || i1 >= i + this.radius || k1 >= k + this.radius) continue;
                this.place(world, i1, j1 + 1, k1, Block.field_71952_K.field_71990_ca);
            }
        }
        this.genLine(world, i + 2, j + height - 5 - rand.nextInt(3), k, 3.0f, 5.0f, id, 0, true);
        this.genLine(world, i, j + height - 7 - rand.nextInt(3), k, 3.0f, 5.0f, id, 1, true);
        this.genLine(world, i, j + height - height / 2 + rand.nextInt(4), k + 1, 4.0f, 3.0f, id, 2, true);
        if (rand.nextInt(2) == 0) {
            this.genLine(world, i, j + height - height / 2 - rand.nextInt(4), k - 1, 5.0f, 4.0f, id, 3, true);
        }
        if (height > 18) {
            this.genLine(world, i + 2, j + height - 10 - rand.nextInt(3), k, 3.0f, 5.0f, id, 0, true);
            this.genLine(world, i, j + height - 7 - rand.nextInt(3), k, 3.0f, 5.0f, id, rand.nextInt(2) + 1, true);
        }
        for (int d = 0; d < 20; ++d) {
            for (int e = height; e < height + j; ++e) {
                if (!rand.nextBoolean()) continue;
                this.genVines(world, rand, i + d, e + j, k + d);
            }
        }
        return true;
    }

    public void genLine(World world, int i, int j, int k, float rise, float run, int id, int dir, boolean shouldNodes) {
        float slope = rise / run;
        ArrayList<ChunkCoordinates> nodes = new ArrayList<ChunkCoordinates>();
        switch (dir) {
            case 0: {
                if (run > rise) {
                    int[] ypoints = new int[(int)run];
                    int r = 0;
                    while ((float)r < run) {
                        ypoints[r] = (int)((float)r * slope);
                        ++r;
                    }
                    double y = 0.0;
                    int prevY = j;
                    int x = i;
                    while ((float)x < (float)i + run) {
                        y = j + ypoints[x - i];
                        if ((float)x == (float)i + run - 1.0f) {
                            nodes.add(new ChunkCoordinates(x, (int)y, k));
                        }
                        this.place(world, x, (int)y, k, id);
                        ++x;
                    }
                } else if (rise > run) {
                    int[] xpoints = new int[(int)rise];
                    int r = 0;
                    while ((float)r < rise) {
                        xpoints[r] = (int)((float)r / slope);
                        ++r;
                    }
                    double x = 0.0;
                    int y = j;
                    while ((float)y < (float)j + rise) {
                        x = xpoints[y - j] + i;
                        if ((float)y == (float)j + rise - 1.0f) {
                            nodes.add(new ChunkCoordinates((int)x, y, k));
                        }
                        this.place(world, (int)x, y, k, id);
                        ++y;
                    }
                } else {
                    int x = i;
                    while ((float)x < run + (float)i) {
                        this.place(world, x, j + (x - i), k, id);
                        ++x;
                    }
                }
                break;
            }
            case 1: {
                if (run > rise) {
                    int[] ypoints = new int[(int)run];
                    int r = 0;
                    while ((float)r < run) {
                        ypoints[r] = (int)((float)r * slope);
                        ++r;
                    }
                    double y = 0.0;
                    int prevY = j;
                    int x = i;
                    while ((float)x > (float)i - run) {
                        y = j + ypoints[i - x];
                        if ((float)x == (float)i - run + 1.0f) {
                            nodes.add(new ChunkCoordinates(x, (int)y, k));
                        }
                        this.place(world, x, (int)y, k, id);
                        --x;
                    }
                } else if (rise > run) {
                    int[] xpoints = new int[(int)rise];
                    int r = 0;
                    while ((float)r < rise) {
                        xpoints[r] = (int)((float)r / slope);
                        ++r;
                    }
                    double x = 0.0;
                    int y = j;
                    while ((float)y < (float)j + rise) {
                        x = i - xpoints[y - j];
                        if ((float)y == (float)j + rise - 1.0f) {
                            nodes.add(new ChunkCoordinates((int)x, y, k));
                        }
                        this.place(world, (int)x, y, k, id);
                        ++y;
                    }
                } else {
                    int x = i;
                    while ((float)x < run + (float)i) {
                        this.place(world, x, j + (x - i), k, id);
                        ++x;
                    }
                }
                break;
            }
            case 2: {
                if (run > rise) {
                    int[] ypoints = new int[(int)run];
                    int r = 0;
                    while ((float)r < run) {
                        ypoints[r] = (int)((float)r * slope);
                        ++r;
                    }
                    double y = 0.0;
                    int prevY = j;
                    int z = k;
                    while ((float)z < (float)k + run) {
                        y = j + ypoints[z - k];
                        if ((float)z == (float)k + run - 1.0f) {
                            nodes.add(new ChunkCoordinates(i, (int)y, z));
                        }
                        this.place(world, i, (int)y, z, id);
                        ++z;
                    }
                } else if (rise > run) {
                    int[] zpoints = new int[(int)rise];
                    int r = 0;
                    while ((float)r < rise) {
                        zpoints[r] = (int)((float)r / slope);
                        ++r;
                    }
                    double z = 0.0;
                    int y = j;
                    while ((float)y < (float)j + rise) {
                        z = zpoints[y - j] + k;
                        if ((float)y == (float)j + rise - 1.0f) {
                            nodes.add(new ChunkCoordinates(i, y, (int)z));
                        }
                        this.place(world, i, y, (int)z, id);
                        ++y;
                    }
                } else {
                    int z = k;
                    while ((float)z < run + (float)k) {
                        this.place(world, i, j + (z - k), z, id);
                        ++z;
                    }
                }
                break;
            }
            case 3: {
                if (run > rise) {
                    int[] ypoints = new int[(int)run];
                    int r = 0;
                    while ((float)r < run) {
                        ypoints[r] = (int)((float)r * slope);
                        ++r;
                    }
                    double y = 0.0;
                    int prevY = j;
                    int z = k;
                    while ((float)z > (float)k - run) {
                        y = j + ypoints[k - z];
                        if ((float)z == (float)k - run + 1.0f) {
                            nodes.add(new ChunkCoordinates(i, (int)y, z));
                        }
                        this.place(world, i, (int)y, z, id);
                        --z;
                    }
                } else if (rise > run) {
                    int[] zpoints = new int[(int)rise];
                    int r = 0;
                    while ((float)r < rise) {
                        zpoints[r] = (int)((float)r / slope);
                        ++r;
                    }
                    double z = 0.0;
                    int y = j;
                    while ((float)y < (float)j + rise) {
                        z = k - zpoints[y - j];
                        if ((float)y == (float)j + rise - 1.0f) {
                            nodes.add(new ChunkCoordinates(i, y, (int)z));
                        }
                        this.place(world, i, y, (int)z, id);
                        ++y;
                    }
                } else {
                    int z = k;
                    while ((float)z < run + (float)k) {
                        this.place(world, i, j + (z - k), z, id);
                        ++z;
                    }
                }
                break;
            }
        }
        if (shouldNodes) {
            this.genNodes(world, this.genBranches(world, nodes));
        }
    }

    private ArrayList<ChunkCoordinates> genBranches(World world, ArrayList<ChunkCoordinates> nodes) {
        int id = Block.field_71951_J.field_71990_ca;
        Random rand = new Random();
        ArrayList<ChunkCoordinates> newnodes = new ArrayList<ChunkCoordinates>();
        for (ChunkCoordinates node : nodes) {
            int rise = rand.nextInt(5);
            int run = rand.nextInt(6);
            int dir = rand.nextInt(4);
            if (rise == run) {
                ++run;
            }
            this.genLine(world, node.field_71574_a, node.field_71572_b, node.field_71573_c, rise, run, id, dir, false);
            switch (dir) {
                case 0: {
                    newnodes.add(new ChunkCoordinates(node.field_71574_a + run, node.field_71572_b + rise, node.field_71573_c));
                    break;
                }
                case 1: {
                    newnodes.add(new ChunkCoordinates(node.field_71574_a - run, node.field_71572_b + rise, node.field_71573_c));
                    break;
                }
                case 2: {
                    newnodes.add(new ChunkCoordinates(node.field_71574_a, node.field_71572_b + rise, node.field_71573_c + run));
                    break;
                }
                case 3: {
                    newnodes.add(new ChunkCoordinates(node.field_71574_a, node.field_71572_b + rise, node.field_71573_c - run));
                    break;
                }
            }
        }
        return newnodes;
    }

    private void genNodes(World world, ArrayList<ChunkCoordinates> nodes) {
        int id = Block.field_71952_K.field_71990_ca;
        for (ChunkCoordinates node : nodes) {
            for (int i1 = node.field_71574_a - this.radius + 1; i1 < node.field_71574_a + this.radius + 1; ++i1) {
                for (int k1 = node.field_71573_c - this.radius + 1; k1 < node.field_71573_c + this.radius + 1; ++k1) {
                    this.placeWithMetadata(world, i1, node.field_71572_b, k1, id, 8);
                    if (i1 <= node.field_71574_a - this.radius + 1 || k1 <= node.field_71573_c - this.radius + 1 || i1 >= node.field_71574_a + this.radius || k1 >= node.field_71573_c + this.radius) continue;
                    this.placeWithMetadata(world, i1, node.field_71572_b + 1, k1, id, 8);
                }
            }
        }
    }
}

