/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.blocks.tileentities;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import tropicraft.drinks.Ingredient;
import tropicraft.drinks.MixerRecipeRegistry;
import tropicraft.items.ItemCocktail;
import tropicraft.items.TropicraftItems;

public class TileEntityEIHMixer
extends TileEntity {
    public int ticks;
    public static final int TICKS_TO_MIX = 80;
    public ItemStack[] ingredients = new ItemStack[2];
    public boolean mixing = false;
    public ItemStack result;

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.ticks = nbt.func_74762_e("MixTicks");
        this.mixing = nbt.func_74767_n("Mixing");
        this.ingredients[0] = nbt.func_74764_b("Ingredient1") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Ingredient1")) : null;
        this.ingredients[1] = nbt.func_74764_b("Ingredient2") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Ingredient2")) : null;
        this.result = nbt.func_74764_b("Result") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Result")) : null;
    }

    public void func_70310_b(NBTTagCompound nbt) {
        NBTTagCompound var4;
        super.func_70310_b(nbt);
        nbt.func_74768_a("MixTicks", this.ticks);
        nbt.func_74757_a("Mixing", this.mixing);
        if (this.ingredients[0] != null) {
            var4 = new NBTTagCompound();
            this.ingredients[0].func_77955_b(var4);
            nbt.func_74766_a("Ingredient1", var4);
        }
        if (this.ingredients[1] != null) {
            var4 = new NBTTagCompound();
            this.ingredients[1].func_77955_b(var4);
            nbt.func_74766_a("Ingredient2", var4);
        }
        if (this.result != null) {
            var4 = new NBTTagCompound();
            this.result.func_77955_b(var4);
            nbt.func_74766_a("Result", var4);
        }
    }

    public void func_70316_g() {
        if (this.ticks < 80 && this.mixing) {
            ++this.ticks;
            if (this.ticks == 80) {
                this.finishMixing();
            }
        }
    }

    public boolean isDoneMixing() {
        return this.result != null;
    }

    public ItemStack[] getIngredients() {
        return this.ingredients;
    }

    public Ingredient[] listAllIngredients() {
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        if (this.ingredients[0] == null || this.ingredients[1] == null) {
            return null;
        }
        is.addAll(TileEntityEIHMixer.listIngredients(this.ingredients[0]));
        is.addAll(TileEntityEIHMixer.listIngredients(this.ingredients[1]));
        Collections.sort(is);
        return is.toArray(new Ingredient[is.size()]);
    }

    public static Ingredient findMatchingIngredient(ItemStack stack) {
        for (Ingredient ingredient : Ingredient.ingredientsList) {
            if (ingredient == null || !ItemStack.func_77989_b((ItemStack)ingredient.getIngredient(), (ItemStack)stack)) continue;
            return ingredient;
        }
        return null;
    }

    public static List<Ingredient> listIngredients(ItemStack stack) {
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        if (stack.field_77993_c == TropicraftItems.cocktail.field_77779_bT) {
            for (Ingredient ingredient : ItemCocktail.getIngredients(stack)) {
                is.add(ingredient);
            }
        } else {
            Ingredient i = TileEntityEIHMixer.findMatchingIngredient(stack);
            is.add(i);
        }
        return is;
    }

    public void startMixing() {
        this.ticks = 0;
        this.mixing = true;
        this.sync();
    }

    public void emptyMixer() {
        EntityItem item;
        if (this.ingredients[0] != null) {
            item = new EntityItem(this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, this.ingredients[0]);
            this.field_70331_k.func_72838_d((Entity)item);
            this.ingredients[0] = null;
        }
        if (this.ingredients[1] != null) {
            item = new EntityItem(this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, this.ingredients[1]);
            this.field_70331_k.func_72838_d((Entity)item);
            this.ingredients[1] = null;
        }
        this.ticks = 80;
        this.mixing = false;
        this.sync();
    }

    public void retrieveResult() {
        ItemStack container2;
        EntityItem e = new EntityItem(this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, this.result);
        this.field_70331_k.func_72838_d((Entity)e);
        ItemStack container1 = this.ingredients[0].func_77973_b().getContainerItemStack(this.ingredients[0]);
        if (container1 != null) {
            e = new EntityItem(this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, container1);
            this.field_70331_k.func_72838_d((Entity)e);
        }
        if ((container2 = this.ingredients[1].func_77973_b().getContainerItemStack(this.ingredients[1])) != null) {
            e = new EntityItem(this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, container2);
            this.field_70331_k.func_72838_d((Entity)e);
        }
        this.ingredients[0] = null;
        this.ingredients[1] = null;
        this.result = null;
        this.ticks = 0;
        this.mixing = false;
        this.sync();
    }

    public void finishMixing() {
        this.result = this.getResult(this.getIngredients());
        this.sync();
    }

    public boolean addToMixer(ItemStack ingredient) {
        if (this.ingredients[0] == null) {
            Ingredient i;
            if (!(ingredient.field_77993_c == TropicraftItems.cocktail.field_77779_bT || (i = TileEntityEIHMixer.findMatchingIngredient(ingredient)) != null && i.isPrimary())) {
                return false;
            }
            this.ingredients[0] = ingredient;
            this.sync();
            return true;
        }
        if (this.ingredients[1] == null) {
            if (ingredient.field_77993_c == TropicraftItems.cocktail.field_77779_bT) {
                return false;
            }
            List<Ingredient> ingredients0 = TileEntityEIHMixer.listIngredients(this.ingredients[0]);
            Ingredient i = TileEntityEIHMixer.findMatchingIngredient(ingredient);
            if (i == null || i.isPrimary() || ingredients0.contains(i)) {
                return false;
            }
            this.ingredients[1] = ingredient;
            this.sync();
            return true;
        }
        return false;
    }

    public boolean isMixing() {
        return this.mixing;
    }

    private boolean isMixerFull() {
        return this.ingredients[0] != null && this.ingredients[1] != null;
    }

    public boolean canMix() {
        return !this.mixing && this.isMixerFull();
    }

    public void sync() {
        PacketDispatcher.sendPacketToAllInDimension((Packet)this.func_70319_e(), (int)this.field_70331_k.field_73011_w.field_76574_g);
    }

    public Packet func_70319_e() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_70310_b(var1);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, var1);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.func_70307_a(pkt.field_73331_e);
    }

    public ItemStack getResult(ItemStack[] ingredients2) {
        return MixerRecipeRegistry.getInstance().getResult(ingredients2);
    }
}

