/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.blocks.tileentities;

import CoroUtil.OldUtil;
import CoroUtil.componentAI.ICoroAI;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.entities.hostile.land.tribes.koa.v3.EntityKoaBase;
import tropicraft.entities.hostile.land.tribes.koa.v3.EntityKoaFisher;
import tropicraft.entities.hostile.land.tribes.koa.v3.EntityKoaHunter;

public class TileEntityKoaChest
extends TileEntityChest
implements IInventory {
    private boolean unbreakable = false;
    private int delay;
    public int housePop = 2;
    public int housePop_hunters = 1;
    public int housePop_fishers = 1;
    public int[] entIDs = new int[this.housePop];
    public EntityKoaBase[] entRefs = new EntityKoaBase[this.housePop];
    private int hunters;
    private int fishers;
    private boolean needListUpdate = false;

    public TileEntityKoaChest() {
        for (int i = 0; i < this.entIDs.length; ++i) {
            this.entIDs[i] = -1;
            this.entRefs[i] = null;
        }
        this.delay = 80;
    }

    public void spawnKoa(World world) {
        this.updateList();
        int koaCount = this.getHomeKoaCount();
        int spawnCount = this.housePop - koaCount;
        int spawnTry = 0;
        while ((this.hunters < this.housePop_hunters || this.fishers < this.housePop_fishers) && spawnTry < 40) {
            EntityKoaBase var2;
            ++spawnTry;
            if (this.hunters < this.housePop_hunters) {
                ++this.hunters;
                var2 = new EntityKoaHunter(this.field_70331_k);
            } else {
                ++this.fishers;
                var2 = new EntityKoaFisher(this.field_70331_k);
            }
            if (var2 != null) {
                double var4 = (double)this.field_70329_l + 0.5;
                double var6 = this.field_70330_m + 1;
                double var8 = (double)this.field_70327_n + 0.5;
                EntityKoaBase var10 = var2 instanceof EntityLiving ? var2 : null;
                var2.func_70012_b(var4, var6, var8, this.field_70331_k.field_73012_v.nextFloat() * 360.0f, 0.0f);
                var2.getAIAgent().homeX = this.field_70329_l;
                var2.getAIAgent().homeY = this.field_70330_m;
                var2.getAIAgent().homeZ = this.field_70327_n;
                this.addToList(var2);
                this.field_70331_k.func_72838_d((Entity)var2);
                var2.getAIAgent().spawnedOrNBTReloadedInit();
                if (var10 == null) continue;
                var10.func_70656_aK();
                continue;
            }
            return;
        }
    }

    public void addToList(EntityKoaBase ent) {
        for (int j = 0; j < this.entIDs.length; ++j) {
            if (this.entIDs[j] != -1) continue;
            this.entIDs[j] = ent.getAIAgent().entID;
            this.entRefs[j] = ent;
            break;
        }
    }

    public void updateList() {
        for (int j = 0; j < this.entIDs.length; ++j) {
            Entity ent = OldUtil.getEntByPersistantID((World)this.field_70331_k, (int)this.entIDs[j]);
            if (ent == null) {
                this.entIDs[j] = -1;
                this.entRefs[j] = null;
                continue;
            }
            if (!ent.field_70128_L) continue;
            this.entIDs[j] = -1;
            this.entRefs[j] = null;
        }
    }

    public int getHomeKoaCount() {
        float dist = 160.0f;
        List ents = this.field_70331_k.func_72872_a(ICoroAI.class, AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1)).func_72314_b((double)dist, (double)(dist / 2.0f), (double)dist));
        this.hunters = 0;
        this.fishers = 0;
        int existing = 0;
        for (int i = 0; i < ents.size(); ++i) {
            int j = 0;
            for (j = 0; j < this.entIDs.length; ++j) {
                Entity ent = (Entity)ents.get(i);
                if (!(ent instanceof EntityKoaBase) || ent == null || this.entIDs[j] != ((EntityKoaBase)ent).getAIAgent().entID || ((EntityKoaBase)ent).getAIAgent().entID == -1) continue;
                ++existing;
                if (ent instanceof EntityKoaHunter) {
                    ++this.hunters;
                }
                if (ent instanceof EntityKoaFisher) {
                    ++this.fishers;
                    break;
                }
                boolean dsdf = false;
                break;
            }
            if (j >= this.entIDs.length) continue;
        }
        return existing;
    }

    public boolean getCanSpawnHere(Entity ent) {
        boolean b1 = !this.field_70331_k.func_72829_c(ent.field_70121_D);
        boolean b2 = ent.field_70170_p.func_72945_a(ent, ent.field_70121_D).isEmpty();
        boolean b3 = !ent.field_70170_p.func_72953_d(ent.field_70121_D);
        return b1 && b3;
    }

    public boolean anyPlayerInRange() {
        return this.field_70331_k.func_72977_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, 80.0) != null;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.anyPlayerInRange()) {
            return;
        }
        if (this.delay == 0) {
            this.delay = 6000;
            if (!this.field_70331_k.field_72995_K && !this.needListUpdate) {
                this.spawnKoa(this.field_70331_k);
            }
        }
        if (this.delay > 0) {
            if (this.needListUpdate && this.delay < 20) {
                for (int i = 0; i < this.entIDs.length; ++i) {
                    Entity ent = OldUtil.getEntByPersistantID((World)this.field_70331_k, (int)this.entIDs[i]);
                    if (ent instanceof EntityKoaBase) {
                        this.entRefs[i] = (EntityKoaBase)ent;
                        continue;
                    }
                    this.entIDs[i] = -1;
                    this.entRefs[i] = null;
                }
                this.needListUpdate = false;
            }
            --this.delay;
            return;
        }
    }

    public String func_70303_b() {
        return "Koa chest";
    }

    public void func_70418_i() {
        if (this.field_70425_a) {
            return;
        }
        this.field_70425_a = true;
        this.field_70423_b = null;
        this.field_70424_c = null;
        this.field_70421_d = null;
        this.field_70422_e = null;
        if (this.field_70331_k.func_72798_a(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) == TropicraftBlocks.koaChest.field_71990_ca) {
            this.field_70421_d = (TileEntityKoaChest)this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) == TropicraftBlocks.koaChest.field_71990_ca) {
            this.field_70424_c = (TileEntityKoaChest)this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) == TropicraftBlocks.koaChest.field_71990_ca) {
            this.field_70423_b = (TileEntityKoaChest)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) == TropicraftBlocks.koaChest.field_71990_ca) {
            this.field_70422_e = (TileEntityKoaChest)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
        }
        if (this.field_70423_b != null) {
            this.field_70423_b.func_70321_h();
        }
        if (this.field_70422_e != null) {
            this.field_70422_e.func_70321_h();
        }
        if (this.field_70424_c != null) {
            this.field_70424_c.func_70321_h();
        }
        if (this.field_70421_d != null) {
            this.field_70421_d.func_70321_h();
        }
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setIsUnbreakable(boolean flag) {
        this.unbreakable = flag;
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.unbreakable = nbttagcompound.func_74767_n("unbreakable");
        try {
            for (int i = 0; i < this.entIDs.length; ++i) {
                this.entIDs[i] = nbttagcompound.func_74762_e("entID_" + i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.needListUpdate = true;
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("unbreakable", this.unbreakable);
        try {
            for (int i = 0; i < this.entIDs.length; ++i) {
                nbttagcompound.func_74768_a("entID_" + i, this.entIDs[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void func_70295_k_() {
        ++this.field_70427_h;
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, TropicraftBlocks.koaChest.field_71990_ca, 1, this.field_70427_h);
    }

    public void func_70305_f() {
        --this.field_70427_h;
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, TropicraftBlocks.koaChest.field_71990_ca, 1, this.field_70427_h);
    }
}

