/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.blocks.tileentities.TileEntityBambooChest;
import tropicraft.blocks.tileentities.TileEntityFlowerPot;
import tropicraft.items.TropicraftItems;
import tropicraft.world.biomes.BiomeGenTropicraft;
import tropicraft.world.worldgen.TCGenBase;

public class WorldGenForestAltarRuin
extends TCGenBase {
    private int x;
    private int z;
    private final int DIR;

    public WorldGenForestAltarRuin(World world, Random random) {
        super(world, random, true);
        this.DIR = this.rand.nextInt(4);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int x;
        int z;
        if (this.worldObj.func_72807_a(i, k) != BiomeGenTropicraft.rainforestPlains && this.worldObj.func_72807_a(i, k) != BiomeGenTropicraft.rainforestHills) {
            return false;
        }
        this.x = i;
        this.z = k;
        int width = (this.rand.nextInt(2) + 3) * 2;
        int length = this.rand.nextInt(6) + 10;
        int halfWidth = width / 2;
        boolean hasGennedTunnel = false;
        for (z = 0; z < length; ++z) {
            for (x = 0; x < width; ++x) {
                if (this.getTerrainHeightWithDir(x, z) >= j) continue;
                j = this.getTerrainHeightWithDir(x, z);
            }
        }
        for (z = 0; z < length; ++z) {
            for (x = 0; x < width; ++x) {
                int y;
                for (y = 0; y < 4; ++y) {
                    this.placeBlockWithDir(x, y + j, z, 0, 0);
                }
                y = j;
                this.placeBlockWithDir(x, y, z, TropicraftBlocks.tropicsBuildingBlock.field_71990_ca, 1);
                if (z == 0) {
                    if (x == 0 || x == width - 1) {
                        this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tropicsFence.field_71990_ca, 0);
                        this.placeBlockWithDir(x, y + 2, z, TropicraftBlocks.tropicsFence.field_71990_ca, 0);
                        continue;
                    }
                    this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tropicsSingleSlab.field_71990_ca, 2);
                    this.placeBlockWithDir(x, y + 2, z, TropicraftBlocks.tropicsFence.field_71990_ca, 0);
                    continue;
                }
                if (z == 1) {
                    if (x == 0 || x == width - 1) {
                        this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tropicsFence.field_71990_ca, 0);
                        continue;
                    }
                    if (x == 1 || x == width - 2) {
                        this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.chunkOHead.field_71990_ca, 0);
                        this.placeBlockWithDir(x, y + 2, z, TropicraftBlocks.flowerPot.field_71990_ca, 0);
                        TileEntityFlowerPot pot = (TileEntityFlowerPot)this.getTEWithDir(x, y + 2, z);
                        if (pot == null) continue;
                        pot.setDamage((short)(this.rand.nextInt(13) + 1));
                        continue;
                    }
                    if (x == halfWidth - 1 || x == halfWidth) {
                        this.placeBlockWithDir(x, y, z, Block.field_72012_bb.field_71990_ca, 0);
                        this.placeBlockWithDir(x, y + 1, z, Block.field_72067_ar.field_71990_ca, 0);
                        continue;
                    }
                    this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tropicsSingleSlab.field_71990_ca, 2);
                    continue;
                }
                if (z == 2) {
                    if (x == 0 || x == width - 1) {
                        this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tropicsFence.field_71990_ca, 0);
                        continue;
                    }
                    this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tropicsSingleSlab.field_71990_ca, 2);
                    continue;
                }
                if (z % 2 == 1) {
                    if (x != 0 && x != width - 1) continue;
                    this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tropicsFence.field_71990_ca, 0);
                    continue;
                }
                if (x == 0 || x == width - 1) {
                    this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.tikiTorch.field_71990_ca, 1);
                    this.placeBlockWithDir(x, y + 2, z, TropicraftBlocks.tikiTorch.field_71990_ca, 1);
                    this.placeBlockWithDir(x, y + 3, z, TropicraftBlocks.tikiTorch.field_71990_ca, 0);
                    continue;
                }
                if (x == halfWidth - 1 || x == halfWidth) continue;
                this.placeBlockWithDir(x, y + 1, z, TropicraftBlocks.palmStairs.field_71990_ca, this.DIR);
                if (hasGennedTunnel) continue;
                this.generateTunnel(x, y, z);
                hasGennedTunnel = true;
            }
        }
        return false;
    }

    private void generateTunnel(int i, int j, int k) {
        int depth = this.rand.nextInt(5) + 8;
        for (int y = 0; y < depth; ++y) {
            this.placeBlockWithDir(i, j - y, k, 0, 0);
        }
        j -= depth;
        int length = this.rand.nextInt(20) + 30;
        int dir = this.rand.nextInt(4);
        for (int x = 0; x < length; ++x) {
            switch (dir) {
                case 0: {
                    ++i;
                    break;
                }
                case 1: {
                    ++k;
                    break;
                }
                case 2: {
                    --i;
                    break;
                }
                case 3: {
                    --k;
                }
            }
            if (this.rand.nextInt(3) == 0) {
                j += this.rand.nextInt(3) - 1;
            }
            this.placeBlockWithDir(i, j, k, 0, 0);
            this.placeBlockWithDir(i, j + 1, k, 0, 0);
            this.placeBlockWithDir(i, j + 2, k, 0, 0);
            if (this.rand.nextInt(5) != 0) continue;
            dir = this.rand.nextInt(4);
        }
        this.placeBlockWithDir(i, j, k, TropicraftBlocks.bambooChest.field_71990_ca, 0);
        TileEntityBambooChest chest = (TileEntityBambooChest)this.getTEWithDir(i, j, k);
        if (chest != null) {
            chest.func_70299_a(0, this.randLoot());
        }
    }

    public ItemStack randLoot() {
        int picker = this.rand.nextInt(18);
        if (picker < 6) {
            return new ItemStack(TropicraftItems.bambooChute, this.rand.nextInt(20) + 1);
        }
        if (picker < 8) {
            return new ItemStack(TropicraftItems.coconutBomb, this.rand.nextInt(3) + 1);
        }
        if (picker < 10) {
            return new ItemStack(TropicraftItems.scale, this.rand.nextInt(3) + 1);
        }
        if (picker < 12) {
            return new ItemStack(TropicraftBlocks.tropicsBuildingBlock, this.rand.nextInt(20) + 1);
        }
        if (picker < 15) {
            return new ItemStack(TropicraftItems.cookedFrogLeg, this.rand.nextInt(4) + 1);
        }
        if (picker == 14) {
            return new ItemStack(TropicraftItems.ashenMasks, 1, this.rand.nextInt(7));
        }
        if (picker == 15) {
            return new ItemStack(TropicraftItems.recordTradeWinds, 1);
        }
        if (picker == 16) {
            return new ItemStack(TropicraftItems.recordEasternIsles, 1);
        }
        return new ItemStack(TropicraftItems.blowGun, 1);
    }

    private void placeBlockWithDir(int i, int j, int k, int blockID, int meta) {
        switch (this.DIR) {
            case 2: {
                this.worldObj.func_72832_d(this.x + i, j, this.z + k, blockID, meta, 3);
                return;
            }
            case 0: {
                this.worldObj.func_72832_d(this.x + k, j, this.z + i, blockID, meta, 3);
                return;
            }
            case 3: {
                this.worldObj.func_72832_d(this.x - i, j, this.z - k, blockID, meta, 3);
                return;
            }
            case 1: {
                this.worldObj.func_72832_d(this.x - k, j, this.z - i, blockID, meta, 3);
                return;
            }
        }
    }

    private TileEntity getTEWithDir(int i, int j, int k) {
        switch (this.DIR) {
            case 2: {
                return this.worldObj.func_72796_p(this.x + i, j, this.z + k);
            }
            case 0: {
                return this.worldObj.func_72796_p(this.x + k, j, this.z + i);
            }
            case 3: {
                return this.worldObj.func_72796_p(this.x - i, j, this.z - k);
            }
            case 1: {
                return this.worldObj.func_72796_p(this.x - k, j, this.z - i);
            }
        }
        return null;
    }

    private int getTerrainHeightWithDir(int i, int k) {
        switch (this.DIR) {
            case 2: {
                return this.getTerrainHeightAt(this.x + i, this.z + k);
            }
            case 0: {
                return this.getTerrainHeightAt(this.x + k, this.z + i);
            }
            case 3: {
                return this.getTerrainHeightAt(this.x - i, this.z - k);
            }
            case 1: {
                return this.getTerrainHeightAt(this.x - k, this.z - i);
            }
        }
        return 64;
    }
}

