/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.biomes.BiomeGenTropicraft;
import tropicraft.world.worldgen.TCGenBase;

public class WorldGenMedRTree
extends TCGenBase {
    private boolean gen = false;
    private int woodBlockId;
    private int leafBlockId;

    public WorldGenMedRTree(World world, Random random, boolean flag) {
        super(world, random, true);
        this.woodBlockId = TropicraftBlocks.treeWood.field_71990_ca;
        this.leafBlockId = TropicraftBlocks.tropicsLeaves.field_71990_ca;
        this.gen = flag;
    }

    public WorldGenMedRTree(World world, Random random, boolean flag, boolean rainforestOnly) {
        super(world, random, rainforestOnly);
        this.woodBlockId = TropicraftBlocks.treeWood.field_71990_ca;
        this.leafBlockId = TropicraftBlocks.tropicsLeaves.field_71990_ca;
        this.gen = flag;
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int bid;
        BiomeGenBase biome = this.worldObj.func_72807_a(i, k);
        if (this.gen && this.isRainforestOnly && !BiomeGenTropicraft.rainforestBiomes.contains(biome)) {
            return false;
        }
        if (this.gen) {
            j = this.getTerrainHeightAt(i, k);
        }
        if ((bid = this.worldObj.func_72798_a(i, j - 1, k)) != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        bid = this.worldObj.func_72798_a(i + 1, j - 1, k);
        if (bid != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        bid = this.worldObj.func_72798_a(i - 1, j - 1, k);
        if (bid != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        bid = this.worldObj.func_72798_a(i, j - 1, k + 1);
        if (bid != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        bid = this.worldObj.func_72798_a(i, j - 1, k - 1);
        if (bid != Block.field_71979_v.field_71990_ca && bid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        int tMod = 1;
        int height = this.rand.nextInt(8) + 10;
        int bs1 = height - this.rand.nextInt(3) - 2;
        int xm = 0;
        int zm = 0;
        if (this.rand.nextBoolean()) {
            int n = xm = this.rand.nextBoolean() ? -1 : 1;
            if (this.rand.nextBoolean()) {
                zm = this.rand.nextBoolean() ? -1 : 1;
            }
        } else {
            int n = zm = this.rand.nextBoolean() ? -1 : 1;
            if (this.rand.nextBoolean()) {
                xm = this.rand.nextBoolean() ? -1 : 1;
            }
        }
        int xb = xm;
        int zb = zm;
        if (xb == 0) {
            xb = 1;
        }
        if (zb == 0) {
            zb = 1;
        }
        int tbx = i;
        int tbz = k;
        for (int y = j; y <= j + height; ++y) {
            int id;
            if (y - j > tMod) {
                tbx += xm;
                tbz += zm;
                tMod *= 2;
            }
            if ((id = this.worldObj.func_72798_a(tbz, y, tbz)) == 0 || id == Block.field_71962_X.field_71990_ca || id == this.leafBlockId) continue;
            return false;
        }
        int tx = i;
        int tz = k;
        System.out.println();
        for (int y = j; y <= j + height; ++y) {
            int ty;
            int ttx;
            int az;
            int ax;
            int branchLength;
            int b;
            int branches;
            int leafSize;
            int oz;
            int ox;
            if (y - j > tMod) {
                tx += xm;
                tz += zm;
                tMod *= 2;
            }
            this.worldObj.func_72832_d(tx, y, tz, this.woodBlockId, 1, 3);
            this.worldObj.func_72832_d(tx - 1, y, tz, this.woodBlockId, 1, 3);
            this.worldObj.func_72832_d(tx + 1, y, tz, this.woodBlockId, 1, 3);
            this.worldObj.func_72832_d(tx, y, tz - 1, this.woodBlockId, 1, 3);
            this.worldObj.func_72832_d(tx, y, tz + 1, this.woodBlockId, 1, 3);
            if (y - j == bs1) {
                ox = tx + this.rand.nextInt(2) - 3;
                oz = tz + this.rand.nextInt(4) - 3;
                leafSize = this.rand.nextInt(4) + 4;
                this.genCircle(ox, y + 2, oz, leafSize, 0.0, this.leafBlockId, 3, false);
                this.genCircle(ox, y + 1, oz, leafSize + 1, leafSize - 1, this.leafBlockId, 3, false);
                branches = this.rand.nextInt(4) + 4;
                for (b = 0; b < branches; ++b) {
                    double randAngle = this.randAngle();
                    branchLength = this.rand.nextInt(leafSize - 2) + 2;
                    ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)ox);
                    az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)oz);
                    this.checkAndPlaceBlockLine(new int[]{tx, y, tz}, new int[]{ax, y + 1, az}, this.woodBlockId, 1, Arrays.asList(0, Block.field_71952_K.field_71990_ca, Block.field_71998_bu.field_71990_ca));
                }
                for (ttx = ox - leafSize; ttx < ox + leafSize; ++ttx) {
                    for (int ttz = oz - leafSize; ttz < oz + leafSize; ++ttz) {
                        for (ty = y; ty <= y + 2; ++ty) {
                            if (this.rand.nextInt(3) != 0) continue;
                            this.genVines(ttx, ty, ttz);
                        }
                    }
                }
            }
            if (y - j != height) continue;
            ox = tx + this.rand.nextInt(4) - 3;
            oz = tz + this.rand.nextInt(4) - 3;
            leafSize = this.rand.nextInt(4) + 4;
            this.genCircle(ox, y + 2, oz, leafSize, 0.0, this.leafBlockId, 3, false);
            this.genCircle(ox, y + 1, oz, leafSize + 1, leafSize - 1, this.leafBlockId, 3, false);
            branches = this.rand.nextInt(4) + 5;
            for (b = 0; b < branches; ++b) {
                double randAngle = this.randAngle();
                branchLength = this.rand.nextInt(leafSize - 2) + 2;
                ax = (int)Math.round((double)branchLength * Math.sin(randAngle) + (double)ox);
                az = (int)Math.round((double)branchLength * Math.cos(randAngle) + (double)oz);
                this.checkAndPlaceBlockLine(new int[]{tx, y, tz}, new int[]{ax, y + 1, az}, this.woodBlockId, 1, Arrays.asList(0, Block.field_71952_K.field_71990_ca, Block.field_71998_bu.field_71990_ca));
            }
            for (ttx = ox - leafSize; ttx < ox + leafSize; ++ttx) {
                for (int ttz = oz - leafSize; ttz < oz + leafSize; ++ttz) {
                    for (ty = y; ty <= y + 2; ++ty) {
                        if (this.rand.nextInt(3) != 0) continue;
                        this.genVines(ttx, ty, ttz);
                    }
                }
            }
        }
        return true;
    }

    private boolean genVines(int i, int j, int k) {
        int m = 2;
        while (true) {
            if (m > 5) {
                return false;
            }
            if (Block.field_71998_bu.func_71850_a_(this.worldObj, i, j, k, m) && this.worldObj.func_72798_a(i, j, k) == 0) break;
            ++m;
        }
        this.worldObj.func_72832_d(i, j, k, Block.field_71998_bu.field_71990_ca, 1 << Direction.field_71579_d[Facing.field_71588_a[m]], 3);
        int length = this.rand.nextInt(4) + 4;
        for (int y = j - 1; y > j - length; --y) {
            if (this.worldObj.func_72798_a(i, y, k) != 0) {
                return true;
            }
            this.worldObj.func_72832_d(i, y, k, Block.field_71998_bu.field_71990_ca, 1 << Direction.field_71579_d[Facing.field_71588_a[m]], 3);
        }
        return true;
    }
}

