/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.biomes.BiomeGenTropicraft;
import tropicraft.world.worldgen.TCGenBase;

public class WorldGenTallRainforestTree
extends TCGenBase {
    public int woodBlockId;
    public int leafBlockID;

    public WorldGenTallRainforestTree(World world, Random random) {
        super(world, random);
        this.woodBlockId = TropicraftBlocks.treeWood.field_71990_ca;
        this.leafBlockID = TropicraftBlocks.tropicsLeaves.field_71990_ca;
    }

    @Override
    public boolean generate(int i, int j, int k) {
        if (!BiomeGenTropicraft.rainforestBiomes.contains(this.worldObj.func_72807_a(i, k))) {
            return false;
        }
        int height = this.rand.nextInt(15) + 25 + j;
        if (height + 5 > 127) {
            return false;
        }
        if (this.worldObj.func_72798_a(i, j - 1, k) != Block.field_71979_v.field_71990_ca && this.worldObj.func_72798_a(i, j - 1, k) != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        for (int x = i - 1; x <= i + 1; ++x) {
            for (int z = k - 1; z <= k + 1; ++z) {
                for (int y = j; y < j + height; ++y) {
                    int bId = this.worldObj.func_72798_a(x, y, z);
                    if (bId == 0 || this.isLeafId(bId) || bId == Block.field_71962_X.field_71990_ca || bId == Block.field_72037_aS.field_71990_ca) continue;
                    return false;
                }
            }
        }
        this.genCircle(i, j - 1, k, 1.0, 0.0, Block.field_71979_v.field_71990_ca, 0, true);
        this.placeBlockCircleLine(new int[]{i, j, k}, new int[]{i, height, k}, 1.3, 0.0, this.woodBlockId, 1);
        this.genSphere(i, height, k, 4, this.leafBlockID, 3);
        this.genSphere(i - 3, height, k, 4, this.leafBlockID, 3);
        this.genSphere(i + 3, height, k, 4, this.leafBlockID, 3);
        this.genSphere(i, height, k + 3, 4, this.leafBlockID, 3);
        this.genSphere(i, height, k - 3, 4, this.leafBlockID, 3);
        return true;
    }
}

