/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.ai;

import CoroAI.ChunkCoordinatesSize;
import CoroAI.DimensionChunkCache;
import CoroAI.PFQueue;
import CoroAI.PathEntityEx;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tropicraft.ai.WorldDirector;

public class AreaScanner
implements Runnable {
    public World world;
    public WorldDirector worldDirector;
    public EntityPlayer player;
    public ArrayList<ChunkCoordinates> tempSurfaceCaves = new ArrayList();
    public ArrayList<ChunkCoordinates> tempCaves = new ArrayList();
    public ArrayList<Integer> groundBlocks = new ArrayList();
    public boolean pfToPlayer = false;

    public AreaScanner(WorldDirector wd, World parWorld, EntityPlayer parPlayer) {
        this.world = parWorld;
        this.worldDirector = wd;
        this.player = parPlayer;
        this.groundBlocks.add(Block.field_71981_t.field_71990_ca);
        this.groundBlocks.add(Block.field_71979_v.field_71990_ca);
    }

    @Override
    public void run() {
        try {
            this.tempSurfaceCaves = (ArrayList)WorldDirector.coordSurfaceCaves.get(this.world.field_73011_w.field_76574_g).clone();
            this.tempCaves = (ArrayList)WorldDirector.coordCaves.get(this.world.field_73011_w.field_76574_g).clone();
            if (this.tempSurfaceCaves == null) {
                this.tempSurfaceCaves = new ArrayList();
            }
            if (this.tempCaves == null) {
                this.tempCaves = new ArrayList();
            }
            this.findGoodSurfaceSpot();
            this.worldDirector.areaScanCompleteCallback();
        }
        catch (Exception ex) {
            WorldDirector.dbg("Area scanner aborted due to exception.");
            this.worldDirector.areaScanCompleteCallback();
            ex.printStackTrace();
        }
    }

    public int getBlockId(int x, int y, int z) {
        try {
            if (!this.world.func_72904_c(x, 0, z, x, 128, z)) {
                return 10;
            }
            return this.world.func_72798_a(x, y, z);
        }
        catch (Exception ex) {
            return 10;
        }
    }

    public int getBlockMetadata(int x, int y, int z) {
        if (!this.world.func_72904_c(x, 0, z, x, 128, z)) {
            return 0;
        }
        return this.world.func_72805_g(x, y, z);
    }

    public float getLightBrightness(int x, int y, int z) {
        if (!this.world.func_72904_c(x, 0, z, x, 128, z)) {
            return 0.0f;
        }
        return this.world.func_72801_o(x, y, z);
    }

    public int getHeightValue(int x, int z) {
        if (!this.world.func_72904_c(x, 0, z, x, 128, z)) {
            return 0;
        }
        return this.world.func_72976_f(x, z);
    }

    public float distanceTo(int x1, int y1, int z1, int x2, int y2, int z2) {
        float f = x2 - x1;
        float f1 = y2 - y1;
        float f2 = z2 - z1;
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public void findGoodSurfaceSpot() {
        boolean foundSafeSpot = false;
        ChunkCoordinates dest = null;
        int randX = -1;
        int randZ = -1;
        int maxDistance = 200;
        int minDistance = 50;
        for (int tries = 0; !foundSafeSpot && tries < 100; ++tries) {
            randX = (int)this.player.field_70165_t - maxDistance / 2 + this.player.field_70170_p.field_73012_v.nextInt(maxDistance);
            if (!(this.player.func_70011_f((double)randX, this.player.field_70163_u, (double)(randZ = (int)this.player.field_70161_v - maxDistance / 2 + this.player.field_70170_p.field_73012_v.nextInt(maxDistance))) > (double)minDistance)) continue;
            int tryY = this.player.field_70170_p.func_72976_f(randX, randZ) - 1;
            int id = this.world.func_72798_a(randX, tryY, randZ);
            if (!this.worldDirector.isCoordAndNearAreaNaturalBlocks(this.world, randX, tryY, randZ, 8)) continue;
            while (this.worldDirector.isLogOrLeafBlock(id)) {
                id = this.world.func_72798_a(randX, tryY -= 2, randZ);
            }
            WorldDirector.dbg("Found TC spawn site! " + randX + " - " + tryY + " - " + randZ);
            foundSafeSpot = true;
            dest = new ChunkCoordinates(randX, tryY, randZ);
        }
        if (foundSafeSpot) {
            ChunkCoordinates spawn = new ChunkCoordinates((int)this.player.field_70165_t - maxDistance / 2 + this.player.field_70170_p.field_73012_v.nextInt(maxDistance), 500, (int)this.player.field_70161_v - maxDistance / 2 + this.player.field_70170_p.field_73012_v.nextInt(maxDistance));
            this.tempSurfaceCaves.add(dest);
        } else {
            WorldDirector.dbg("couldnt find a safe TC spawn spot D:");
        }
    }

    public void areaScan() {
        if (this.pfToPlayer) {
            this.tempCaves.clear();
        }
        if (PFQueue.lastCacheUpdate < System.currentTimeMillis()) {
            PFQueue.lastCacheUpdate = System.currentTimeMillis() + 10000L;
            DimensionChunkCache.updateAllWorldCache();
        }
        PFQueue pathfinder = new PFQueue((IBlockAccess)DimensionChunkCache.dimCacheLookup.get(this.world.field_73011_w.field_76574_g), false);
        int size = 512;
        if (this.pfToPlayer) {
            size = 96;
        }
        int hsize = size / 2;
        int curX = (int)this.player.field_70165_t;
        int curY = (int)this.player.field_70163_u;
        int curZ = (int)this.player.field_70161_v;
        int firstY = 100;
        int lastY = 40;
        int yDir = -3;
        int horizontalStep = 5;
        int distBetweenLocations = 50;
        if (this.pfToPlayer) {
            firstY = 0;
            lastY = 90;
            yDir = 3;
        }
        for (int xx = curX - hsize; xx < curX + hsize; xx += horizontalStep) {
            for (int yy = firstY; this.pfToPlayer && yy < lastY || !this.pfToPlayer && yy > lastY; yy += yDir) {
                for (int zz = curZ - hsize; zz < curZ + hsize; zz += horizontalStep) {
                    int testID;
                    int j;
                    int id = this.getBlockId(xx, yy, zz);
                    if (id != 0) continue;
                    boolean proxFail = false;
                    boolean proxFail2 = false;
                    for (j = 0; j < this.tempSurfaceCaves.size(); ++j) {
                        if (!(Math.sqrt(this.tempSurfaceCaves.get(j).func_71569_e(xx, yy, zz)) < (double)distBetweenLocations)) continue;
                        proxFail2 = true;
                        break;
                    }
                    for (j = 0; j < this.tempCaves.size(); ++j) {
                        if (!(Math.sqrt(this.tempCaves.get(j).func_71569_e(xx, yy, zz)) < (double)distBetweenLocations)) continue;
                        proxFail2 = true;
                        break;
                    }
                    if (proxFail || proxFail2) continue;
                    float blockLight = this.getLightBrightness(xx, yy, zz);
                    if (!this.pfToPlayer && !((double)blockLight <= 0.3)) continue;
                    int downScan = 0;
                    for (downScan = 0; !(downScan >= 30 || (testID = this.getBlockId(xx, yy - downScan, zz)) != 0 && this.groundBlocks.contains(testID)); ++downScan) {
                    }
                    if (downScan >= 30 || downScan == 0) continue;
                    PathEntityEx pe = null;
                    ChunkCoordinates coordsDest = null;
                    ChunkCoordinates coordsSource = null;
                    coordsDest = this.pfToPlayer ? new ChunkCoordinates((int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v) : new ChunkCoordinates(xx, this.getHeightValue(xx, zz), zz);
                    coordsSource = new ChunkCoordinates(xx, yy - downScan + 1, zz);
                    pe = pathfinder.createPathTo(new ChunkCoordinatesSize(coordsSource.field_71574_a, coordsSource.field_71572_b, coordsSource.field_71573_c, this.world.field_73011_w.field_76574_g, 128.0f, 2.0f), (double)coordsDest.field_71574_a, (double)coordsDest.field_71572_b, (double)coordsDest.field_71573_c, 256.0f, 0);
                    if (pe != null) {
                        double dist = this.distanceTo(pe.points[pe.pathLength - 1].xCoord, pe.points[pe.pathLength - 1].yCoord, pe.points[pe.pathLength - 1].zCoord, coordsDest.field_71574_a, coordsDest.field_71572_b, coordsDest.field_71573_c);
                        if (dist < 5.0) {
                            if (proxFail2) continue;
                            this.tempSurfaceCaves.add(new ChunkCoordinates(xx, yy - downScan, zz));
                            continue;
                        }
                        if (proxFail) continue;
                        this.tempCaves.add(new ChunkCoordinates(xx, yy - downScan, zz));
                        continue;
                    }
                    if (proxFail) continue;
                    this.tempCaves.add(new ChunkCoordinates(xx, yy - downScan, zz));
                }
            }
        }
    }
}

