/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import tropicraft.TropicraftUtils;
import tropicraft.encyclopedia.Encyclopedia;
import tropicraft.encyclopedia.TropicalBook;
import tropicraft.gui.GuiClearButton;

@SideOnly(value=Side.CLIENT)
public class GuiTropicalBook
extends GuiScreen {
    private TropicalBook book;
    private int indexPage = -1;
    private int selectedIndex = 0;
    private TropicalBook.ContentMode contentMode = TropicalBook.ContentMode.INFO;
    private int contentPage = 0;
    private String coverBackground;
    private String pageBackground;
    private String closedTextureIndex;
    private String openTextureIndex;
    private RenderItem itemRenderer = new RenderItem();
    private static final int buttonNextIndexPage = 2000;
    private static final int buttonPrevIndexPage = 2001;
    private static final int buttonBookCover = 2003;
    private static final int buttonCraftingPage = 2010;
    private static final int buttonInfoPage = 2011;
    private static final int buttonNextContentPage = 2012;
    private static final int buttonPrevContentPage = 2013;

    public GuiTropicalBook(TropicalBook tropbook) {
        this.book = tropbook;
        this.coverBackground = tropbook.outsideTexture;
        this.pageBackground = tropbook.insideTexture;
        this.closedTextureIndex = tropbook.outsideTexture;
        this.openTextureIndex = tropbook.insideTexture;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        this.addButtons();
    }

    protected void func_73875_a(GuiButton guibutton) {
        switch (guibutton.field_73741_f) {
            case 2003: {
                this.indexPage = 0;
                this.contentMode = TropicalBook.ContentMode.INFO;
                this.contentPage = 0;
                break;
            }
            case 2000: {
                ++this.indexPage;
                this.contentPage = 0;
                break;
            }
            case 2001: {
                --this.indexPage;
                this.contentPage = 0;
                break;
            }
            case 2010: {
                this.contentMode = TropicalBook.ContentMode.RECIPE;
                this.contentPage = 0;
                break;
            }
            case 2011: {
                this.contentMode = TropicalBook.ContentMode.INFO;
                this.contentPage = 0;
                break;
            }
            case 2012: {
                ++this.contentPage;
                break;
            }
            case 2013: {
                --this.contentPage;
                break;
            }
            default: {
                this.selectedIndex = guibutton.field_73741_f;
                if (this.book.isPageVisible(this.selectedIndex) && !this.book.hasPageBeenRead(this.selectedIndex)) {
                    this.book.markPageAsRead(this.selectedIndex);
                }
                this.contentMode = TropicalBook.ContentMode.INFO;
                this.contentPage = 0;
            }
        }
    }

    private void addButtons() {
        this.field_73887_h.clear();
        if (this.indexPage == -1) {
            this.field_73887_h.add(new GuiClearButton(2003, 0, 0, this.field_73880_f, this.field_73881_g, "", 0, this.coverBackground, 0x440000));
        } else {
            int indexPosition = 0;
            for (int entry = this.indexPage * this.book.entriesPerIndexPage(); entry < (this.indexPage + 1) * this.book.entriesPerIndexPage() && entry < this.book.getPageCount(); ++entry) {
                String pageTitle = this.book.getPageTitleNotVisible(entry);
                int color = 0x440000;
                if (this.book.isPageVisible(entry)) {
                    pageTitle = this.book.getPageTitleByIndex(entry);
                    if (!this.book.hasPageBeenRead(entry)) {
                        color = 0x3333FF;
                    }
                }
                this.field_73887_h.add(new GuiClearButton(entry, this.field_73880_f / 2 - 129, this.field_73881_g / 2 - 87 + indexPosition * 15, 90, 10, pageTitle, -1, this.pageBackground, color));
                ++indexPosition;
            }
            if (this.indexPage > 0) {
                this.field_73887_h.add(new GuiClearButton(2001, this.field_73880_f / 2 - 168, this.field_73881_g / 2 - 20, 11, 22, "", 2, this.pageBackground, 0x440000));
            }
            if ((this.indexPage + 1) * this.book.entriesPerIndexPage() < this.book.getPageCount()) {
                this.field_73887_h.add(new GuiClearButton(2000, this.field_73880_f / 2 - 168, this.field_73881_g / 2 - 50, 11, 22, "", 1, this.pageBackground, 0x440000));
            }
            if (this.indexPage >= 0) {
                if (this.book.hasRecipeList()) {
                    switch (this.contentMode) {
                        case INFO: {
                            List<ShapedRecipes> recipes = ((Encyclopedia)this.book).getRecipesForEntry(this.selectedIndex);
                            if (recipes == null) break;
                            System.out.println(recipes.size());
                            this.field_73887_h.add(new GuiClearButton(2010, this.field_73880_f / 2 + 158, this.field_73881_g / 2 - 80, 11, 22, "aa", 5, this.pageBackground, 0x440000));
                            break;
                        }
                        case RECIPE: {
                            this.field_73887_h.add(new GuiClearButton(2011, this.field_73880_f / 2 + 158, this.field_73881_g / 2 - 80, 11, 22, "", 6, this.pageBackground, 0x440000));
                            break;
                        }
                    }
                }
                if (this.contentPage > 0) {
                    this.field_73887_h.add(new GuiClearButton(2013, this.field_73880_f / 2 + 158, this.field_73881_g / 2 - 20, 11, 22, "", 4, this.pageBackground, 0x440000));
                }
                if ((this.contentPage + 1) * this.book.entriesPerContentPage(this.contentMode) < this.book.getContentPageCount(this.selectedIndex, this.contentMode)) {
                    this.field_73887_h.add(new GuiClearButton(2012, this.field_73880_f / 2 + 158, this.field_73881_g / 2 - 50, 11, 22, "", 3, this.pageBackground, 0x440000));
                }
            }
        }
    }

    public void addIcons() {
        int indexPosition = 0;
        for (int entry = this.indexPage * this.book.entriesPerIndexPage(); entry < (this.indexPage + 1) * this.book.entriesPerIndexPage(); ++entry) {
            if (entry >= this.book.getPageCount()) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            TropicraftUtils.bindTextureMod(this.openTextureIndex);
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            GL11.glTranslatef((float)((float)this.field_73880_f / 1.5f), (float)((float)this.field_73881_g / 1.5f), (float)0.0f);
            this.func_73729_b(-195, -121 + indexPosition * 20, 3, 190, 18, 18);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            GL11.glTranslatef((float)((float)this.field_73880_f / 1.5f - 1.0f), (float)((float)this.field_73881_g / 1.5f), (float)0.0f);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            this.itemRenderer.field_77024_a = this.book.isPageVisible(entry);
            ItemStack is = this.book.getPageItemStack(entry);
            if (is != null) {
                this.itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, is, -193, -120 + indexPosition * 20);
            }
            GL11.glPopMatrix();
            ++indexPosition;
        }
    }

    protected void func_73864_a(int x, int y, int mousebutton) {
        if (mousebutton == 0) {
            for (int l = 0; l < this.field_73887_h.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_73887_h.get(l);
                if (!guibutton.func_73736_c(this.field_73882_e, x, y)) continue;
                this.field_73882_e.field_71416_A.func_77366_a("pageFlip", 1.0f, 1.0f);
                this.func_73875_a(guibutton);
            }
        }
    }

    public void func_73860_n() {
        super.func_73860_n();
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == this.field_73882_e.field_71474_y.field_74315_B.field_74512_d) {
                this.field_73882_e.func_71373_a((GuiScreen)new GuiInventory((EntityPlayer)this.field_73882_e.field_71439_g));
                return;
            }
            this.func_73869_a(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void func_73863_a(int i, int j, float f) {
        this.func_73873_v_();
        if (this.indexPage == -1) {
            float f1 = 1.35f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            TropicraftUtils.bindTextureMod(this.closedTextureIndex);
            GL11.glTranslatef((float)(this.field_73880_f / 2), (float)(this.field_73881_g / 2), (float)0.0f);
            GL11.glScalef((float)f1, (float)f1, (float)f1);
            this.func_73729_b(-64, -86, 0, 0, 128, 173);
        } else {
            float f2 = 1.35f;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            TropicraftUtils.bindTextureMod(this.openTextureIndex);
            GL11.glTranslatef((float)(this.field_73880_f / 2), (float)(this.field_73881_g / 2), (float)0.0f);
            GL11.glScalef((float)f2, (float)f2, (float)f2);
            this.func_73729_b(-128, -88, 0, 0, 256, 176);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            TropicraftUtils.bindTextureMod(this.openTextureIndex);
            this.func_73729_b(this.field_73880_f / 2 - 162, this.field_73881_g / 2 - 115, 145, 201, 111, 32);
            GL11.glPopMatrix();
            this.field_73886_k.func_78276_b("Table of Contents", this.field_73880_f / 2 - 150, this.field_73881_g / 2 - 110, 0x440000);
            this.field_73886_k.func_78276_b("" + (1 + this.indexPage), this.field_73880_f / 2 - 159, this.field_73881_g / 2 + 93, 0x440000);
            if (this.book.hasIndexIcons()) {
                this.addIcons();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            switch (this.contentMode) {
                case INFO: {
                    String pageTitle = this.book.isPageVisible(this.selectedIndex) ? this.book.getPageTitleByIndex(this.selectedIndex) : "\u00a7nPage not found";
                    this.field_73886_k.func_78276_b(pageTitle, this.field_73880_f / 2 + 150 - this.field_73886_k.func_78256_a(pageTitle), this.field_73881_g / 2 - 110, 0x440000);
                    this.field_73886_k.func_78279_b("  " + (this.book.isPageVisible(this.selectedIndex) ? this.book.getPageDescriptionsByIndex(this.selectedIndex) : "???"), this.field_73880_f / 2 + 20, this.field_73881_g / 2 - 80, 135, 0x440000);
                    break;
                }
                case RECIPE: {
                    this.field_73886_k.func_78276_b("Crafting", this.field_73880_f / 2 + 110, this.field_73881_g / 2 - 110, 0x440000);
                    try {
                        this.printRecipes();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            TropicraftUtils.bindTextureMod(this.openTextureIndex);
            this.func_73729_b(this.field_73880_f / 2 + 20, this.field_73881_g / 2 - 115, 90, 201, 142, 32);
            GL11.glPopMatrix();
            if (this.book.hasIndexIcons()) {
                GL11.glPushMatrix();
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                GL11.glTranslatef((float)((float)this.field_73880_f / 3.0f + 0.6f), (float)((float)this.field_73881_g / 3.0f - 1.2f), (float)0.0f);
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
                this.itemRenderer.field_77024_a = this.book.isPageVisible(this.selectedIndex);
                ItemStack is = this.book.getPageItemStack(this.selectedIndex);
                if (is != null) {
                    this.itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, is, 15, -73);
                }
                GL11.glPopMatrix();
            }
        }
        this.addButtons();
        super.func_73863_a(i, j, f);
    }

    private void printRecipes() throws Exception {
        List<ShapedRecipes> recipes = ((Encyclopedia)this.book).getRecipesForEntry(this.selectedIndex);
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        int newx = this.field_73880_f / 2 + 25;
        int newy = this.field_73881_g / 2 - 80;
        int indexPosition = 0;
        for (int entry = this.contentPage * this.book.entriesPerContentPage(this.contentMode); entry < (this.contentPage + 1) * this.book.entriesPerContentPage(this.contentMode); ++entry) {
            int renderY;
            int renderX;
            int itemIndex;
            int col;
            int row;
            if (entry >= this.book.getContentPageCount(this.selectedIndex, this.contentMode)) {
                return;
            }
            Encyclopedia.RecipeEntry recipe = ((Encyclopedia)this.book).getFormattedRecipe(recipes.get(entry));
            TropicraftUtils.bindTextureMod(this.openTextureIndex);
            this.func_73729_b(newx - 3, newy - 3, 0, 187, 122, 60);
            int offsetX = 18;
            int offsetY = 18;
            for (row = 0; row < recipe.height; ++row) {
                for (col = 0; col < recipe.width; ++col) {
                    itemIndex = row * recipe.width + col;
                    if (recipe.ingredients[itemIndex] == null) continue;
                    renderX = newx + offsetX * col + 1;
                    renderY = newy + offsetY * row + 1;
                    GL11.glPushMatrix();
                    RenderHelper.func_74518_a();
                    this.itemRenderer.field_77024_a = true;
                    this.itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, recipe.ingredients[itemIndex], renderX, renderY);
                    this.itemRenderer.field_77024_a = false;
                    RenderHelper.func_74519_b();
                    GL11.glPopMatrix();
                }
            }
            for (row = 0; row < recipe.height; ++row) {
                for (col = 0; col < recipe.width; ++col) {
                    itemIndex = row * recipe.width + col;
                    renderX = newx + offsetX * col + 1;
                    renderY = newy + offsetY * row + 1;
                    this.checkMouseHover(recipe.ingredients[itemIndex], renderX, renderY, 18);
                }
            }
            GL11.glPushMatrix();
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glTranslatef((float)((float)newx / 3.0f + 1.0f), (float)((float)newy / 3.0f - 0.75f), (float)0.0f);
            RenderHelper.func_74518_a();
            this.itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, recipe.output, newx / 3 + 60, newy / 3 + 11);
            this.itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, recipe.output, newx / 3 + 60, newy / 3 + 11);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            this.checkMouseHover(recipe.output, newx + 90, newy + 20, 25);
            GL11.glPopMatrix();
            ++indexPosition;
            newy += 62;
        }
    }

    private void checkMouseHover(ItemStack itemstack, int k, int l, int size) {
        String s;
        boolean flag;
        float scale;
        switch (this.field_73882_e.field_71474_y.field_74335_Z) {
            case 1: {
                scale = 4.0f;
                break;
            }
            case 2: {
                scale = 2.0f;
                break;
            }
            case 3: {
                scale = 3.0f;
                break;
            }
            default: {
                scale = 2.0f;
            }
        }
        int i = (int)((float)Mouse.getEventX() / scale);
        int j = (int)((float)this.field_73881_g - (float)Mouse.getEventY() / scale);
        boolean bl = flag = i >= k && j >= l && i < k + size && j < l + size;
        if (itemstack != null && flag && (s = itemstack.func_77973_b().func_77628_j(itemstack)).length() > 0) {
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int l2 = this.field_73886_k.func_78256_a(s);
            int i2 = i - l2 - 4;
            int k2 = j;
            this.func_73733_a(i2 - 3, k2 - 3, i2 + l2 + 3, k2 + 8 + 3, -1073741824, -1073741824);
            this.field_73886_k.func_78261_a(s, i2, k2, -1);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
    }
}

