/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.config.TropicraftConfig;
import tropicraft.world.worldgen.WorldGenBamboo;
import tropicraft.world.worldgen.WorldGenEIH;
import tropicraft.world.worldgen.WorldGenTallFlower;
import tropicraft.world.worldgen.WorldGenTropicraftCurvedPalm;
import tropicraft.world.worldgen.WorldGenTropicraftFlowers;
import tropicraft.world.worldgen.WorldGenTropicraftLargePalmTrees;
import tropicraft.world.worldgen.WorldGenTropicraftNormalPalms;

public class TCWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateSurface(world, random, chunkX, chunkZ);
    }

    public void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        if (!TropicraftConfig.genTropicraftInOverworld) {
            chunkX *= 16;
            chunkZ *= 16;
            if (world.field_73011_w.field_76574_g == 0) {
                WorldType cfr_ignored_0 = world.field_73011_w.field_76577_b;
                if (world.field_73011_w.field_76577_b != WorldType.field_77138_c) {
                    int j3;
                    int k = chunkX + random.nextInt(16) + 8;
                    int l = random.nextInt(62) + 64;
                    int i1 = chunkZ + random.nextInt(16) + 8;
                    if (TropicraftConfig.genTropicraftFlowersInOverworld) {
                        for (j3 = 0; j3 < 10; ++j3) {
                            l = random.nextInt(62) + 64;
                            new WorldGenTropicraftFlowers(TropicraftBlocks.tropicsFlowers.field_71990_ca, false).func_76484_a(world, random, k, l, i1);
                        }
                    }
                    if (TropicraftConfig.genTropicraftEIHInOverworld && random.nextInt(27) == 0) {
                        l = random.nextInt(62) + 64;
                        new WorldGenEIH().func_76484_a(world, random, k, l, i1);
                    }
                    if (TropicraftConfig.genPalmsInOverworld && (TropicraftConfig.palmChanceOfGenInOverworld < 0 || random.nextFloat() < (float)TropicraftConfig.palmChanceOfGenInOverworld / 100.0f)) {
                        for (j3 = 0; j3 < TropicraftConfig.palmPopulationFactorInOverworld; ++j3) {
                            l = random.nextInt(62) + 64;
                            if (random.nextInt(5) == 0) {
                                new WorldGenTropicraftLargePalmTrees().func_76484_a(world, random, k, l, i1);
                                continue;
                            }
                            if (random.nextInt(5) < 3) {
                                new WorldGenTropicraftCurvedPalm().func_76484_a(world, random, k, l, i1);
                                continue;
                            }
                            new WorldGenTropicraftNormalPalms().func_76484_a(world, random, k, l, i1);
                        }
                    }
                    if (TropicraftConfig.genPineapplesInOverworld) {
                        l = random.nextInt(62) + 64;
                        new WorldGenTallFlower(7, 9).func_76484_a(world, random, k, l, i1);
                    }
                    if (TropicraftConfig.genBambooInOverworld) {
                        l = random.nextInt(62) + 64;
                        new WorldGenBamboo().func_76484_a(world, random, k, l, i1);
                    }
                }
            }
        }
    }
}

