/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.blocks.tileentities.TileEntityBambooChest;
import tropicraft.items.TropicraftItems;
import tropicraft.world.worldgen.TCGenBase;

public class WorldGenTropiSkellyDung
extends TCGenBase {
    public WorldGenTropiSkellyDung(World worldObj, Random rand) {
        super(worldObj, rand);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int y;
        int z;
        int x;
        int length = (this.rand.nextInt(3) + 4) * 2 + 1;
        int width = (this.rand.nextInt(2) + 3) * 2 + 1;
        int height = 4;
        int dir = this.rand.nextInt(4);
        if (dir % 2 == 0) {
            length ^= width;
            width = length ^ width;
            length ^= width;
        }
        int num = 0;
        for (x = i; x <= i + length; ++x) {
            for (z = k; z <= k + width; ++z) {
                for (y = j; y <= j + height; ++y) {
                    if (this.worldObj.func_72798_a(x, y, z) != 0) continue;
                    ++num;
                }
            }
        }
        if (num < length * width * height / 2) {
            return false;
        }
        for (x = i; x <= i + length; ++x) {
            for (z = k; z <= k + width; ++z) {
                for (y = j; y <= j + height; ++y) {
                    if (x == i || x == i + length || z == k || z == k + width || y == j || y == j + height) {
                        int meta;
                        if (this.worldObj.func_72799_c(x, y, z)) continue;
                        if (y == j || y == j + height) {
                            this.worldObj.func_72832_d(x, y, z, TropicraftBlocks.tropicsBuildingBlock.field_71990_ca, 1, 3);
                            continue;
                        }
                        if (y == j + 1) {
                            this.worldObj.func_72832_d(x, y, z, TropicraftBlocks.tropiOres.field_71990_ca, 2, 3);
                            if (x != i + length / 2 && x != i + length / 2 + 1 && z != k + width / 2 && z != k + width / 2 + 1) continue;
                            meta = 5;
                            if (z == k || z == k + width) {
                                meta = 9;
                            }
                            this.worldObj.func_72832_d(x, y, z, TropicraftBlocks.treeWood.field_71990_ca, meta, 3);
                            continue;
                        }
                        if (y == j + 2) {
                            meta = 5;
                            if (z == k || z == k + width) {
                                meta = 9;
                            }
                            this.worldObj.func_72832_d(x, y, z, TropicraftBlocks.treeWood.field_71990_ca, meta, 3);
                            continue;
                        }
                        if (y != j + 3) continue;
                        this.worldObj.func_72832_d(x, y, z, TropicraftBlocks.tropicsBuildingBlock.field_71990_ca, 1, 3);
                        if (x != i + length / 2 - 1 && x != i + length / 2 + 2 && z != k + width / 2 - 1 && z != k + width / 2 + 2) continue;
                        meta = 5;
                        if (z == k || z == k + width) {
                            meta = 9;
                        }
                        this.worldObj.func_72832_d(x, y, z, TropicraftBlocks.treeWood.field_71990_ca, meta, 3);
                        continue;
                    }
                    this.worldObj.func_94571_i(x, y, z);
                }
            }
        }
        int iMin = i + 1;
        int kMin = k + 1;
        int jMin = j + 1;
        int iMax = i + length - 1;
        int kMax = k + width - 1;
        switch (dir) {
            case 0: {
                this.putSpawner(iMin, jMin, kMin);
                this.putSpawner(iMax, jMin, kMin);
                this.putChest(iMin + length / 2, jMin, kMin, 3);
                this.putChest(iMin + length / 2 - 1, jMin, kMin, 3);
            }
            case 1: {
                this.putSpawner(iMin, jMin, kMin);
                this.putSpawner(iMin, jMin, kMax);
                this.putChest(iMin, jMin, kMin + width / 2, 5);
                this.putChest(iMin, jMin, kMin + width / 2 - 1, 5);
                break;
            }
            case 2: {
                this.putSpawner(iMin, jMin, kMax);
                this.putSpawner(iMax, jMin, kMax);
                this.putChest(iMin + length / 2, jMin, kMax, 2);
                this.putChest(iMin + length / 2 - 1, jMin, kMax, 2);
                break;
            }
            case 3: {
                this.putSpawner(iMax, jMin, kMin);
                this.putSpawner(iMax, jMin, kMax);
                this.putChest(iMax, jMin, kMin + width / 2, 4);
                this.putChest(iMax, jMin, kMin + width / 2 - 1, 4);
            }
        }
        return true;
    }

    public ItemStack randLoot() {
        int picker = this.rand.nextInt(18);
        if (picker < 6) {
            return new ItemStack(TropicraftItems.bambooChute, this.rand.nextInt(20) + 1);
        }
        if (picker < 8) {
            return new ItemStack(TropicraftItems.coconutBomb, this.rand.nextInt(3) + 1);
        }
        if (picker < 10) {
            return new ItemStack(TropicraftItems.scale, this.rand.nextInt(3) + 1);
        }
        if (picker < 12) {
            return new ItemStack(TropicraftBlocks.tropicsBuildingBlock, this.rand.nextInt(20) + 1);
        }
        if (picker < 15) {
            return new ItemStack(TropicraftItems.cookedFrogLeg, this.rand.nextInt(4) + 1);
        }
        if (picker == 15) {
            return new ItemStack(TropicraftItems.recordTradeWinds, 1);
        }
        if (picker == 16) {
            return new ItemStack(TropicraftItems.recordEasternIsles, 1);
        }
        return new ItemStack(TropicraftItems.blowGun, 1);
    }

    private void putSpawner(int x, int y, int z) {
        this.worldObj.func_94575_c(x, y, z, Block.field_72065_as.field_71990_ca);
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)this.worldObj.func_72796_p(x, y, z);
        spawner.func_98049_a().func_98272_a("TropiSkeleton");
    }

    private void putChest(int x, int y, int z, int dir) {
        this.worldObj.func_72832_d(x, y, z, TropicraftBlocks.bambooChest.field_71990_ca, dir, 3);
        this.worldObj.func_72921_c(x, y, z, dir, 3);
        TileEntityBambooChest chest = (TileEntityBambooChest)this.worldObj.func_72796_p(x, y, z);
        int amount = this.rand.nextInt(4) + 2;
        for (int i = 0; i < amount; ++i) {
            chest.func_70299_a(this.rand.nextInt(chest.func_70302_i_()), this.randLoot());
        }
    }
}

