/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.drinks;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.tropicraft.drinks.DrinkAction;
import net.tropicraft.drinks.DrinkActionFood;
import net.tropicraft.drinks.DrinkActionPotion;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCItemRegistry;

public class Ingredient
implements Comparable<Ingredient> {
    public static final Ingredient[] ingredientsList = new Ingredient[128];
    public static final Ingredient sugar = new Ingredient(0, new ItemStack(Items.field_151102_aT), false, 0xFFFFFF, 0.1f).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient lemon = new Ingredient(5, new ItemStack((Item)TCItemRegistry.lemon), true, 0xFFFF00).addAction(new DrinkActionFood(2, 0.2f));
    public static final Ingredient lime = new Ingredient(6, new ItemStack((Item)TCItemRegistry.lime), true, 0x7FFF00).addAction(new DrinkActionFood(2, 0.2f));
    public static final Ingredient orange = new Ingredient(7, new ItemStack((Item)TCItemRegistry.orange), true, 16753920).addAction(new DrinkActionFood(3, 0.2f));
    public static final Ingredient grapefruit = new Ingredient(8, new ItemStack((Item)TCItemRegistry.grapefruit), true, 16737095).addAction(new DrinkActionFood(4, 0.2f));
    public static final Ingredient pineapple = new Ingredient(9, new ItemStack((Block)TCBlockRegistry.pineapple, 1, 0), true, 0xEEFF00).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient pineappleChunks = new Ingredient(10, new ItemStack((Item)TCItemRegistry.pineappleCubes), false, 0xEEFF00, 0.1f).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient coconut = new Ingredient(11, new ItemStack((Block)TCBlockRegistry.coconut), true, 0xEFEFEF).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient coconutChunk = new Ingredient(12, new ItemStack((Item)TCItemRegistry.coconutChunk), false, 0xEFEFEF, 0.1f).addAction(new DrinkActionFood(1, 0.1f));
    public static final Ingredient sugarcane = new Ingredient(13, new ItemStack(Items.field_151120_aE), false, 11665259, 0.1f);
    public static final Ingredient roastedCoffeeBean = new Ingredient(14, new ItemStack((Item)TCItemRegistry.coffeeBean, 1, 1), false, 6833196, 0.95f).addAction(new DrinkActionFood(4, 0.2f)).addAction(new DrinkActionPotion(Potion.field_76424_c.field_76415_H, 5, 1));
    public static final Ingredient waterBucket = new Ingredient(15, new ItemStack((Item)TCItemRegistry.bucketTropicsWater), true, 0xFFFFFF);
    public static final Ingredient milkBucket = new Ingredient(16, new ItemStack(Items.field_151117_aB), false, 0xFFFFFF, 0.1f).addAction(new DrinkActionFood(2, 0.2f));
    public static final Ingredient cocoaBean = new Ingredient(17, new ItemStack(Items.field_151100_aR, 1, 3), false, 8411710, 0.95f).addAction(new DrinkActionFood(4, 0.2f));
    private ItemStack ingredientItem;
    private int color;
    public int ingredientId;
    private boolean primary;
    private float alpha = 1.0f;
    private List<DrinkAction> actions = new LinkedList<DrinkAction>();

    public Ingredient(int id, ItemStack ingredient, boolean primary, int color) {
        if (ingredientsList[id] != null) {
            throw new IllegalArgumentException("Ingredient Id slot " + id + " already occupied by " + Ingredient.ingredientsList[id].ingredientItem.func_77977_a() + "!");
        }
        this.ingredientId = id;
        this.ingredientItem = ingredient;
        this.primary = primary;
        this.color = color;
        Ingredient.ingredientsList[id] = this;
    }

    public Ingredient(int id, ItemStack ingredient, boolean primary, int color, float alpha) {
        this(id, ingredient, primary, color);
        this.alpha = alpha;
    }

    public Ingredient addAction(DrinkAction action) {
        this.actions.add(action);
        return this;
    }

    public ItemStack getIngredient() {
        return this.ingredientItem;
    }

    public Item getIngredientItem() {
        return this.ingredientItem.func_77973_b();
    }

    public int getColor() {
        return this.color;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int compareTo(Ingredient other) {
        return this.ingredientId < other.ingredientId ? -1 : (this.ingredientId == other.ingredientId ? 0 : 1);
    }

    public void onDrink(EntityPlayer player) {
        for (DrinkAction action : this.actions) {
            action.onDrink(player);
        }
    }
}

