/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.render;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RotatingEffectRenderer {
    public int layers = 6;
    public World worldObj;
    public List[] fxLayers = new List[this.layers];
    public TextureManager renderer;
    public Random rand = new Random();
    public static final ResourceLocation particleTextures = new ResourceLocation("textures/particle/particles.png");
    public static final ResourceLocation resLayer4 = new ResourceLocation(ExtendedRenderer.modid + ":textures/particles/particles_64.png");
    public static final ResourceLocation resLayer5 = new ResourceLocation(ExtendedRenderer.modid + ":textures/particles/particles_16.png");

    public RotatingEffectRenderer(World var1, TextureManager par2TextureManager) {
        if (var1 != null) {
            this.worldObj = var1;
        }
        this.renderer = par2TextureManager;
        for (int var3 = 0; var3 < this.layers; ++var3) {
            this.fxLayers[var3] = new ArrayList();
        }
    }

    public void addEffect(EntityFX var1) {
        int var2 = var1.func_70537_b();
        if (this.fxLayers[var2].size() >= 4000) {
            this.fxLayers[var2].remove(0);
        }
        this.fxLayers[var2].add(var1);
    }

    public void updateEffects() {
        for (int var1 = 0; var1 < this.layers; ++var1) {
            for (int var2 = 0; var2 < this.fxLayers[var1].size(); ++var2) {
                EntityFX var3 = (EntityFX)this.fxLayers[var1].get(var2);
                if (var3 == null) continue;
                if (!((EntityRotFX)var3).weatherEffect) {
                    var3.func_70071_h_();
                }
                if (var3.func_70032_d((Entity)FMLClientHandler.instance().getClient().field_71439_g) > 64.0f) {
                    // empty if block
                }
                if (!var3.field_70128_L) continue;
                this.fxLayers[var1].remove(var2--);
            }
        }
    }

    public void renderParticles(Entity var1, float var2) {
        EntityFX.field_70556_an = var1.field_70142_S + (var1.field_70165_t - var1.field_70142_S) * (double)var2;
        EntityFX.field_70554_ao = var1.field_70137_T + (var1.field_70163_u - var1.field_70137_T) * (double)var2;
        EntityFX.field_70555_ap = var1.field_70136_U + (var1.field_70161_v - var1.field_70136_U) * (double)var2;
        try {
            for (int var8 = 0; var8 < this.layers; ++var8) {
                if (this.fxLayers[var8].size() == 0) continue;
                if (var8 == 0) {
                    this.renderer.func_110577_a(particleTextures);
                }
                if (var8 == 1) {
                    this.renderer.func_110577_a(TextureMap.field_110575_b);
                }
                if (var8 == 2 || var8 == 3) {
                    this.renderer.func_110577_a(TextureMap.field_110576_c);
                }
                if (var8 == 4) {
                    this.renderer.func_110577_a(resLayer4);
                }
                if (var8 == 5) {
                    this.renderer.func_110577_a(resLayer5);
                }
                Tessellator var10 = Tessellator.field_78398_a;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                GL11.glDisable((int)2884);
                var10.func_78382_b();
                for (int var11 = this.fxLayers[var8].size() - 1; var11 >= 0; --var11) {
                    EntityFX var12 = (EntityFX)this.fxLayers[var8].get(var11);
                    if (var12 == null) continue;
                    boolean render = true;
                    if (var12 instanceof EntityRotFX && var1.func_70032_d((Entity)var12) > ((EntityRotFX)var12).maxRenderRange()) {
                        render = false;
                    }
                    if (!render) continue;
                    float var3 = MathHelper.func_76134_b((float)(var12.field_70177_z * (float)Math.PI / 180.0f));
                    float var4 = MathHelper.func_76126_a((float)(var12.field_70177_z * (float)Math.PI / 180.0f));
                    float var5 = -var4 * MathHelper.func_76126_a((float)(var12.field_70125_A * (float)Math.PI / 180.0f));
                    float var6 = var3 * MathHelper.func_76126_a((float)(var12.field_70125_A * (float)Math.PI / 180.0f));
                    float var7 = MathHelper.func_76134_b((float)(var12.field_70125_A * (float)Math.PI / 180.0f));
                    var12.func_70539_a(var10, var2, var3, var7, var4, var5, var6);
                }
                var10.func_78381_a();
                GL11.glEnable((int)2884);
                GL11.glDisable((int)3042);
                GL11.glDepthMask((boolean)true);
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void clearEffects(World var1) {
        this.worldObj = var1;
        for (int var2 = 0; var2 < this.layers; ++var2) {
            this.fxLayers[var2].clear();
        }
    }

    public String getStatistics() {
        int count = 0;
        for (int i = 0; i < this.layers; ++i) {
            count += this.fxLayers[i].size();
        }
        return "" + count;
    }
}

